/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.list;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.communication.management.WorkflowHostSetListener;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.workflow.api.WorkflowConstants;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowStateNotificationSubscriber;
import de.rcenvironment.core.component.workflow.execution.spi.MultipleWorkflowsStateChangeListener;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditorAction;
import de.rcenvironment.core.gui.workflow.view.list.Messages;
import de.rcenvironment.core.gui.workflow.view.list.WorkflowInformationColumnSorter;
import de.rcenvironment.core.gui.workflow.view.list.WorkflowInformationContentProvider;
import de.rcenvironment.core.gui.workflow.view.list.WorkflowInformationLabelProvider;
import de.rcenvironment.core.gui.workflow.view.list.WorkflowStateModel;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.notification.SimpleNotificationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class WorkflowListView
extends ViewPart
implements MultipleWorkflowsStateChangeListener {
    private static final int MAX_BATCH_SIZE = 500;
    private static final long MAX_BATCH_LATENCY_MSEC = 500L;
    private final List<String> idsOfRemoteWorkflowsSubscribedFor = new ArrayList<String>();
    private final Set<InstanceNodeSessionId> nodesSubscribedForNewWorkflows = new HashSet<InstanceNodeSessionId>();
    private final WorkflowStateNotificationSubscriber workflowStateChangeListener = new WorkflowStateNotificationSubscriber((MultipleWorkflowsStateChangeListener)this);
    private final SimpleNotificationService sns = new SimpleNotificationService();
    private TableViewer viewer;
    private Table table;
    private WorkflowInformationColumnSorter columnSorter;
    private Action pauseAction;
    private Action resumeAction;
    private Action cancelAction;
    private Action disposeAction;
    private Display display;
    private ServiceRegistryPublisherAccess serviceRegistryPublisherAccess;
    private WorkflowExecutionService workflowExecutionService;
    private Object syncUpdateLock = new Object();
    private final BatchAggregator<Set<WorkflowExecutionInformation>> batchAggregator;

    public WorkflowListView() {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.workflowExecutionService = (WorkflowExecutionService)serviceRegistryAccess.getService(WorkflowExecutionService.class);
        this.serviceRegistryPublisherAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        BatchProcessor<Set<WorkflowExecutionInformation>> batchProcessor = new BatchProcessor<Set<WorkflowExecutionInformation>>(){

            public void processBatch(final List<Set<WorkflowExecutionInformation>> batch) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkflowListView.this.refresh((Set)batch.get(batch.size() - 1));
                    }
                });
            }
        };
        this.batchAggregator = ConcurrencyUtils.getFactory().createBatchAggregator(500, 500L, (BatchProcessor)batchProcessor);
    }

    private void registerWorkflowHostSetListener() {
        this.serviceRegistryPublisherAccess.registerService(WorkflowHostSetListener.class, (Object)new WorkflowHostSetListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReachableWorkflowHostsChanged(Set<InstanceNodeSessionId> reachableWfHosts, Set<InstanceNodeSessionId> addedWfHosts, Set<InstanceNodeSessionId> removedWfHosts) {
                WorkflowListView.this.updateSubscriptionsForNewlyCreatedWorkflows();
                Object object = WorkflowListView.this.syncUpdateLock;
                synchronized (object) {
                    Set<WorkflowExecutionInformation> wis = WorkflowListView.this.updateWorkflowInformations();
                    if (!WorkflowListView.this.table.isDisposed()) {
                        WorkflowListView.this.batchAggregator.enqueue(wis);
                    }
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getShell().getDisplay();
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
            }

            public void keyPressed(KeyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 97) {
                    WorkflowListView.this.viewer.getTable().selectAll();
                    WorkflowListView.this.getSite().getSelectionProvider().setSelection(WorkflowListView.this.viewer.getSelection());
                    WorkflowListView.this.updateSelectedWorkflowState();
                }
                if (event.keyCode == 127 && WorkflowListView.this.disposeAction.isEnabled()) {
                    WorkflowListView.this.disposeAction.run();
                }
            }
        });
        this.table = this.viewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.columnSorter = new WorkflowInformationColumnSorter();
        this.viewer.setSorter((ViewerSorter)this.columnSorter);
        String[] titles = new String[]{Messages.name, Messages.status, "Controller", "Start", "Started From", "Comment"};
        int i = 0;
        while (i < titles.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(titles[i]);
            column.setWidth(150);
            column.setResizable(true);
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowListView.this.columnSorter.setColumn(index);
                    int direction = WorkflowListView.this.viewer.getTable().getSortDirection();
                    direction = WorkflowListView.this.viewer.getTable().getSortColumn() == column ? (direction == 128 ? 1024 : 128) : 128;
                    WorkflowListView.this.viewer.getTable().setSortDirection(direction);
                    WorkflowListView.this.viewer.getTable().setSortColumn(column);
                    WorkflowListView.this.viewer.refresh();
                }
            });
            ++i;
        }
        Action[] actionArray = this.createToolbarActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            action.setEnabled(false);
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
            ++n2;
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                WorkflowExecutionInformation wi = (WorkflowExecutionInformation)((IStructuredSelection)WorkflowListView.this.viewer.getSelection()).getFirstElement();
                if (wi == null) {
                    return;
                }
                new WorkflowRunEditorAction(wi).run();
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent eve) {
                this.widgetDefaultSelected(eve);
            }

            public void widgetDefaultSelected(SelectionEvent eve) {
                WorkflowListView.this.updateSelectedWorkflowState();
            }
        });
        Job job = new Job(Messages.workflows){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.fetchingWorkflows, 7);
                    try {
                        WorkflowListView.this.sns.subscribe("rce.component.workflow.state:.*", (NotificationSubscriber)WorkflowListView.this.workflowStateChangeListener, null);
                    }
                    catch (RemoteOperationException e) {
                        LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to set up remote subscriptions; the workflow list will not update properly: " + e.getMessage()));
                    }
                    monitor.worked(2);
                    WorkflowListView.this.updateSubscriptionsForNewlyCreatedWorkflows();
                    monitor.worked(3);
                    monitor.worked(2);
                    final Set<WorkflowExecutionInformation> wis = WorkflowListView.this.updateWorkflowInformations();
                    WorkflowListView.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowListView.this.refresh(wis);
                        }
                    });
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        this.hookContextMenu();
        this.registerWorkflowHostSetListener();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.pauseAction);
        menuManager.add((IAction)this.resumeAction);
        menuManager.add((IAction)this.cancelAction);
        menuManager.add((IAction)this.disposeAction);
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void refresh(Set<WorkflowExecutionInformation> wis) {
        if (this.table.isDisposed()) {
            return;
        }
        this.viewer.setContentProvider((IContentProvider)new WorkflowInformationContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkflowInformationLabelProvider());
        TableItem[] selectedItems = this.viewer.getTable().getSelection();
        String selWiId = null;
        if (selectedItems.length == 1) {
            selWiId = ((WorkflowExecutionInformation)selectedItems[0].getData()).getExecutionIdentifier();
        }
        this.viewer.setInput(wis);
        if (selWiId != null) {
            TableItem[] tableItemArray = this.viewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem i = tableItemArray[n2];
                WorkflowExecutionInformation wei = (WorkflowExecutionInformation)i.getData();
                if (selWiId.equals(wei.getExecutionIdentifier())) {
                    this.viewer.getTable().setSelection(i);
                    break;
                }
                ++n2;
            }
        }
        this.updateSelectedWorkflowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<WorkflowExecutionInformation> updateWorkflowInformations() {
        List<String> list = this.idsOfRemoteWorkflowsSubscribedFor;
        synchronized (list) {
            Set wis = this.workflowExecutionService.getWorkflowExecutionInformations(true);
            CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Void.class);
            ArrayList<String> alreadySubscribedWiIds = new ArrayList<String>(this.idsOfRemoteWorkflowsSubscribedFor);
            this.idsOfRemoteWorkflowsSubscribedFor.clear();
            for (final WorkflowExecutionInformation wi : wis) {
                final String executionId = wi.getExecutionIdentifier();
                this.idsOfRemoteWorkflowsSubscribedFor.add(executionId);
                if (alreadySubscribedWiIds.contains(executionId)) continue;
                callablesGroup.add((Callable)new Callable<Void>(){

                    @Override
                    @TaskDescription(value="Subscribe to new workflow")
                    public Void call() throws Exception {
                        WorkflowListView.this.sns.subscribe("rce.component.workflow.state:" + executionId, (NotificationSubscriber)WorkflowListView.this.workflowStateChangeListener, (ResolvableNodeId)wi.getNodeId());
                        WorkflowStateModel.getInstance().setState(wi.getExecutionIdentifier(), wi.getWorkflowState());
                        return null;
                    }
                });
            }
            callablesGroup.executeParallel(new AsyncExceptionListener(){

                public void onAsyncException(Exception e) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Asynchronous exception while subscribing to a new workflow: " + e.toString()));
                }
            });
            return wis;
        }
    }

    public void setFocus() {
        this.table.setFocus();
        this.updateSelectedWorkflowState();
    }

    private Action[] createToolbarActions() {
        this.pauseAction = new WorflowLifeCycleAction(this, Messages.pause, Activator.getInstance().getImageRegistry().getDescriptor(WorkflowState.PAUSED.name())){

            @Override
            protected void performAction(WorkflowExecutionInformation wfExeInfo) throws ExecutionControllerException, RemoteOperationException {
                workflowExecutionService.pause(wfExeInfo.getExecutionIdentifier(), (ResolvableNodeId)wfExeInfo.getNodeId());
            }

            @Override
            protected String getActionAsString() {
                return "Pausing";
            }
        };
        this.resumeAction = new WorflowLifeCycleAction(this, Messages.resume, Activator.getInstance().getImageRegistry().getDescriptor(WorkflowState.RESUMING.name())){

            @Override
            protected void performAction(WorkflowExecutionInformation wfExeInfo) throws ExecutionControllerException, RemoteOperationException {
                workflowExecutionService.resume(wfExeInfo.getExecutionIdentifier(), (ResolvableNodeId)wfExeInfo.getNodeId());
            }

            @Override
            protected String getActionAsString() {
                return "Resuming";
            }
        };
        this.cancelAction = new WorflowLifeCycleAction(this, Messages.cancel, Activator.getInstance().getImageRegistry().getDescriptor(WorkflowState.CANCELLED.name())){

            @Override
            protected void performAction(WorkflowExecutionInformation wfExeInfo) throws ExecutionControllerException, RemoteOperationException {
                workflowExecutionService.cancel(wfExeInfo.getExecutionIdentifier(), (ResolvableNodeId)wfExeInfo.getNodeId());
            }

            @Override
            protected String getActionAsString() {
                return "Cancelling";
            }
        };
        this.disposeAction = new WorflowLifeCycleAction(this, Messages.dispose, ImageDescriptor.createFromImage((Image)ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.REMOVE_16))){

            @Override
            protected void performAction(WorkflowExecutionInformation wfExeInfo) throws ExecutionControllerException, RemoteOperationException {
                workflowExecutionService.dispose(wfExeInfo.getExecutionIdentifier(), (ResolvableNodeId)wfExeInfo.getNodeId());
            }

            @Override
            protected String getActionAsString() {
                return "Disposing";
            }
        };
        return new Action[]{this.pauseAction, this.resumeAction, this.cancelAction, this.disposeAction};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubscriptionsForNewlyCreatedWorkflows() {
        Set<InstanceNodeSessionId> set = this.nodesSubscribedForNewWorkflows;
        synchronized (set) {
            CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(InstanceNodeSessionId.class);
            ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
            Set nodes = ((WorkflowHostService)registryAccess.getService(WorkflowHostService.class)).getWorkflowHostNodesAndSelf();
            for (final InstanceNodeSessionId node : nodes) {
                if (this.nodesSubscribedForNewWorkflows.contains(node)) continue;
                this.nodesSubscribedForNewWorkflows.add(node);
                callablesGroup.add((Callable)new Callable<InstanceNodeSessionId>(){

                    @Override
                    @TaskDescription(value="Distributed subscriptions for newly created workflow notifications")
                    public InstanceNodeSessionId call() throws Exception {
                        WorkflowListView.this.sns.subscribe("rce.component.workflow.new", (NotificationSubscriber)WorkflowListView.this.workflowStateChangeListener, (ResolvableNodeId)node);
                        return node;
                    }
                });
            }
            List nodesAdded = callablesGroup.executeParallel(new AsyncExceptionListener(){

                public void onAsyncException(Exception e) {
                    Log log = LogFactory.getLog(this.getClass());
                    if (e.getCause() == null || e.getCause() instanceof RemoteOperationException) {
                        log.warn((Object)("Asynchronous exception during parallel subscriptions for newly created workflow notifications: " + e.toString()));
                    } else {
                        log.warn((Object)"Asynchronous exception during parallel subscriptions for newly created workflow notifications", e.getCause());
                    }
                }
            });
            this.nodesSubscribedForNewWorkflows.retainAll(nodesAdded);
        }
    }

    private void updateSelectedWorkflowState() {
        this.setAllIconsEnabled(true);
        if (this.viewer.getSelection() != null) {
            if (((IStructuredSelection)this.viewer.getSelection()).size() > 0) {
                for (Object o : ((IStructuredSelection)this.viewer.getSelection()).toList()) {
                    WorkflowExecutionInformation wi = (WorkflowExecutionInformation)o;
                    WorkflowState workflowState = WorkflowStateModel.getInstance().getState(wi.getExecutionIdentifier());
                    if (workflowState == WorkflowState.RUNNING || workflowState == WorkflowState.PREPARING) {
                        this.resumeAction.setEnabled(false);
                        this.disposeAction.setEnabled(false);
                        continue;
                    }
                    if (workflowState == WorkflowState.PAUSED) {
                        this.pauseAction.setEnabled(false);
                        this.disposeAction.setEnabled(false);
                        continue;
                    }
                    if (WorkflowConstants.FINAL_WORKFLOW_STATES.contains(workflowState)) {
                        this.pauseAction.setEnabled(false);
                        this.resumeAction.setEnabled(false);
                        this.cancelAction.setEnabled(false);
                        continue;
                    }
                    this.setAllIconsEnabled(false);
                }
            } else {
                this.setAllIconsEnabled(false);
            }
        }
    }

    private void setAllIconsEnabled(boolean enabled) {
        this.pauseAction.setEnabled(enabled);
        this.resumeAction.setEnabled(enabled);
        this.cancelAction.setEnabled(enabled);
        this.disposeAction.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorkflowStateChanged(String wfExecutionId, WorkflowState newState) {
        if (newState != null) {
            WorkflowStateModel.getInstance().setState(wfExecutionId, newState);
        }
        Object object = this.syncUpdateLock;
        synchronized (object) {
            Set<WorkflowExecutionInformation> wis = this.updateWorkflowInformations();
            this.batchAggregator.enqueue(wis);
        }
    }

    private abstract class WorflowLifeCycleAction
    extends Action {
        protected WorflowLifeCycleAction(String text, ImageDescriptor image) {
            super(text, image);
        }

        public void run() {
            final List selection = ((StructuredSelection)WorkflowListView.this.viewer.getSelection()).toList();
            Job job = new Job(String.valueOf(this.getActionAsString()) + " workflow(s)"){

                protected IStatus run(IProgressMonitor monitor) {
                    CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Void.class);
                    for (Object o : selection) {
                        WorkflowExecutionInformation wfExeInfo = (WorkflowExecutionInformation)o;
                        try {
                            WorflowLifeCycleAction.this.performAction(wfExeInfo);
                        }
                        catch (ExecutionControllerException | RemoteOperationException e) {
                            LogFactory.getLog(WorkflowListView.class).error((Object)StringUtils.format((String)"%s workflow failed", (Object[])new Object[]{WorflowLifeCycleAction.this.getActionAsString()}), e);
                        }
                    }
                    callablesGroup.executeParallel(new AsyncExceptionListener(){

                        public void onAsyncException(Exception e) {
                            LogFactory.getLog(WorkflowListView.class).error((Object)StringUtils.format((String)"%s workflow failed", (Object[])new Object[]{WorflowLifeCycleAction.this.getActionAsString()}), (Throwable)e);
                        }
                    });
                    final Set<WorkflowExecutionInformation> wfExeInfos = WorkflowListView.this.updateWorkflowInformations();
                    try {
                        if (!WorkflowListView.this.table.isDisposed()) {
                            WorkflowListView.this.table.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    WorkflowListView.this.refresh(wfExeInfos);
                                }
                            });
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(false);
            job.schedule();
        }

        protected abstract void performAction(WorkflowExecutionInformation var1) throws ExecutionControllerException, RemoteOperationException;

        protected abstract String getActionAsString();
    }
}

