/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef.commands.Command;

public class WorkflowNodeDisEnableImitiationModeCommand
extends Command {
    private Set<WorkflowNode> nodes;
    private Set<WorkflowNode> nodesToggled = new HashSet<WorkflowNode>();

    public WorkflowNodeDisEnableImitiationModeCommand(Set<WorkflowNode> nodes) {
        this.nodes = nodes;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        boolean setActive = false;
        for (WorkflowNode node : this.nodes) {
            if (node.isImitiationModeActive()) continue;
            setActive = true;
            break;
        }
        for (WorkflowNode node : this.nodes) {
            if (node.isImitiationModeActive() == setActive) continue;
            this.nodesToggled.add(node);
            node.setImitiationModeActive(setActive);
        }
    }

    public void undo() {
        for (WorkflowNode node : this.nodesToggled) {
            node.setImitiationModeActive(!node.isImitiationModeActive());
        }
    }
}

