/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class WorkflowLabelMoveCommand
extends Command {
    private final WorkflowLabel label;
    private final ChangeBoundsRequest request;
    private final Point newLocation;
    private final Point oldLocation;
    private final Dimension oldSize;
    private final Dimension newSize;
    private final boolean resize;

    public WorkflowLabelMoveCommand(WorkflowLabel label, ChangeBoundsRequest req, Rectangle newBounds) {
        this.label = label;
        this.request = req;
        this.resize = !req.getSizeDelta().equals(0, 0);
        this.newLocation = newBounds.getLocation();
        this.newSize = newBounds.getSize();
        this.oldLocation = new Point(label.getX(), label.getY());
        this.oldSize = new Dimension(label.getWidth(), label.getHeight());
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        this.label.setSize(this.newSize.width, this.newSize.height);
        this.label.setLocation(this.newLocation.x, this.newLocation.y);
        this.label.firePropertyChange("de.rcenvironment.rce.component.workflow.WorkflowLabelProperty");
    }

    public void undo() {
        this.label.setSize(this.oldSize.width, this.oldSize.height);
        this.label.setLocation(this.oldLocation.x, this.oldLocation.y);
        this.label.firePropertyChange("de.rcenvironment.rce.component.workflow.WorkflowLabelProperty");
    }
}

