/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.editparts.ZoomManager;

public class WorkflowZoomManager
extends ZoomManager {
    public static final String FIT_WORKFLOW = "Fit Workflow";
    public static final String FIT_WORKFLOW_HEIGHT = "Fit Height";
    public static final String FIT_WORKFLOW_WIDTH = "Fit Width";
    protected static final double MAX_ZOOM = 2.0;
    protected static final double MIN_ZOOM = 0.1;
    private double previousLevel = 1.0;

    public WorkflowZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    public double getMaxZoom() {
        return 2.0;
    }

    public double getMinZoom() {
        return 0.1;
    }

    public void setZoomAsText(String zoomString) {
        String zString = FIT_WORKFLOW.equalsIgnoreCase(zoomString) ? FIT_ALL : (FIT_WORKFLOW_HEIGHT.equalsIgnoreCase(zoomString) ? FIT_HEIGHT : (FIT_WORKFLOW_WIDTH.equalsIgnoreCase(zoomString) ? FIT_WIDTH : zoomString));
        boolean fitMin = FIT_ALL.equalsIgnoreCase(zString) && this.getFitPageZoomLevel() < 0.1;
        fitMin |= FIT_WIDTH.equalsIgnoreCase(zString) && this.getFitWidthZoomLevel() < 0.1;
        if (fitMin |= FIT_HEIGHT.equalsIgnoreCase(zString) && this.getFitHeightZoomLevel() < 0.1) {
            super.setZoom(0.1);
            return;
        }
        super.setZoomAsText(zString);
    }

    public void restorePreviousZoomLevel() {
        this.setZoom(this.previousLevel);
    }

    public void setZoom(double zoom) {
        this.previousLevel = this.getZoom();
        super.setZoom(zoom);
    }
}

