/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.integration.IntegrationHistoryDataItem;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class IntegrationHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static Image defaultIconImage;
    private final Map<String, Image> componentIconImageCache = new HashMap<String, Image>();

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{String.valueOf("de.rcenvironment.integration.common.".replace(".", "\\.")) + ".*"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parent) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            IntegrationHistoryDataItem historyData;
            try {
                historyData = IntegrationHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildCommonHistoryDataItemSubtrees((CommonComponentHistoryDataItem)historyData, (DMBrowserNode)parent);
            if (historyData.getWorkingDirectory() != null) {
                for (DMBrowserNode node : parent.getChildren()) {
                    if (!node.getTitle().equals("Execution Log")) continue;
                    DMBrowserNode.addNewLeafNode((String)("Working directory: " + historyData.getWorkingDirectory()), (DMBrowserNodeType)DMBrowserNodeType.InformationText, (DMBrowserNode)node);
                }
            }
        }
    }

    public Image getComponentIcon(String identifier) {
        if (!this.componentIconImageCache.containsKey(identifier)) {
            byte[] icon = null;
            ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
            DistributedComponentKnowledgeService componentKnowledgeService = (DistributedComponentKnowledgeService)serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
            Collection installations = componentKnowledgeService.getCurrentComponentKnowledge().getAllInstallations();
            for (ComponentInstallation installation : installations) {
                if (!installation.getInstallationId().startsWith(identifier)) continue;
                icon = installation.getComponentRevision().getComponentInterface().getIcon16();
                break;
            }
            if (icon != null) {
                this.componentIconImageCache.put(identifier, ImageDescriptor.createFromImage((Image)new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(icon))).createImage());
            }
        }
        if (this.componentIconImageCache.containsKey(identifier)) {
            return this.componentIconImageCache.get(identifier);
        }
        if (defaultIconImage == null) {
            InputStream inputStream = null;
            try {
                inputStream = IntegrationHistoryDataItemSubtreeBuilder.class.getResourceAsStream("/resources/icons/tool16.png");
                defaultIconImage = ImageDescriptor.createFromImage((Image)new Image((Device)Display.getCurrent(), inputStream)).createImage();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return defaultIconImage;
    }
}

