/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.gui.utils.incubator.AlphanumericalTextContraintListener;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.PathChooserButtonListener;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.wizards.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ToolCharacteristicsPage
extends ToolIntegrationWizardPage {
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.wizard.toolintegration.integration_characteristics";
    private static final String DOTS = "  ...  ";
    private static final String DOC_EXTENTION_NOT_VALID = "Documentation extension not valid. Valid extensions: ";
    private static final String VALID_EXTENSION_SEPERATOR = ", ";
    private static final String DOC_DOES_NOT_EXIST = "Documentation path is invalid.";
    private static final int TOOL_DESCRIPTION_TEXT_HEIGHT = 50;
    private static final String KEY_KEYS = "properties";
    private static final char[] FORBIDDEN_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '>', '<', '|'};
    protected Map<String, Object> configurationMap;
    private Text toolNameText;
    private Text iconText;
    private final List<String> usedToolnames;
    private Text groupNameText;
    private Text descriptionTextArea;
    private Text integratorName;
    private Text integratorEmail;
    private Button uploadIconToFolder;
    private List<String> groupNames;
    private Text documenationText;
    private String docValid = "";
    private String iconValid = "";
    private String nameValid = "";
    private PathChooserButtonListener docPathChooserButtonListener;

    protected ToolCharacteristicsPage(String pageName, Map<String, Object> configurationMap, List<String> usedToolnames, List<String> groupNames) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.firstPageDescription);
        this.configurationMap = configurationMap;
        this.usedToolnames = usedToolnames;
        this.groupNames = groupNames;
        if (configurationMap.get("uploadIcon") == null) {
            configurationMap.put("uploadIcon", true);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData containerData = new GridData(1808);
        container.setLayoutData((Object)containerData);
        Composite toolDataComp = new Composite(container, 0);
        toolDataComp.setLayout((Layout)new GridLayout(1, false));
        GridData toolData = new GridData(1808);
        toolDataComp.setLayoutData((Object)toolData);
        Group toolPropertiesGroup = new Group(toolDataComp, 0);
        toolPropertiesGroup.setText(Messages.toolPropGroup);
        toolPropertiesGroup.setLayout((Layout)new GridLayout(3, false));
        GridData toolPropertyData = new GridData(1808);
        toolPropertiesGroup.setLayoutData((Object)toolPropertyData);
        this.toolNameText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, Messages.nameRequired, "toolName");
        ((GridData)this.toolNameText.getLayoutData()).horizontalSpan = 2;
        this.toolNameText.addListener(25, (Listener)new AlphanumericalTextContraintListener(FORBIDDEN_CHARS));
        this.toolNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ToolCharacteristicsPage.this.nameValid = ToolCharacteristicsPage.this.validateName();
                ToolCharacteristicsPage.this.validate(true);
            }
        });
        this.iconText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, Messages.iconPath, "toolIconPath");
        this.iconText.setMessage(Messages.iconSizeMessage);
        this.iconText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ToolCharacteristicsPage.this.iconValid = ToolCharacteristicsPage.this.validateIcon();
                ToolCharacteristicsPage.this.validate(true);
            }
        });
        GridLayout iconCompLayout = new GridLayout(2, false);
        iconCompLayout.marginWidth = 0;
        Composite iconComp = new Composite((Composite)toolPropertiesGroup, 0);
        iconComp.setLayout((Layout)iconCompLayout);
        Button choosePathButton = new Button(iconComp, 8);
        choosePathButton.setText(DOTS);
        choosePathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.iconText, false, this.getShell()));
        this.uploadIconToFolder = new Button(iconComp, 32);
        this.uploadIconToFolder.setText(Messages.copyIconButtonLabel);
        this.uploadIconToFolder.setSelection(true);
        this.uploadIconToFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolCharacteristicsPage.this.configurationMap.put("uploadIcon", ToolCharacteristicsPage.this.uploadIconToFolder.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.groupNameText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, Messages.groupNameText, "groupName");
        GridData groupNameTextData = new GridData(768);
        this.groupNameText.setLayoutData((Object)groupNameTextData);
        Button chooseGroupButton = new Button((Composite)toolPropertiesGroup, 8);
        chooseGroupButton.setText(DOTS);
        chooseGroupButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolCharacteristicsPage.this.showGroupSelectionDialog();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.documenationText = this.addLabelAndTextfieldForPropertyToComposite((Composite)toolPropertiesGroup, "Documentation: ", "documentationFilePath");
        Button chooseDocButton = new Button((Composite)toolPropertiesGroup, 8);
        chooseDocButton.setText(DOTS);
        this.docPathChooserButtonListener = new PathChooserButtonListener(this.documenationText, false, this.getShell());
        chooseDocButton.addSelectionListener((SelectionListener)this.docPathChooserButtonListener);
        this.documenationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ToolCharacteristicsPage.this.docValid = ToolCharacteristicsPage.this.validateDoc();
                ToolCharacteristicsPage.this.validate(true);
            }
        });
        Label toolDescriptionLabel = new Label((Composite)toolPropertiesGroup, 0);
        toolDescriptionLabel.setText(Messages.toolDescription);
        GridData toolDescriptionLabelData = new GridData();
        toolDescriptionLabelData.verticalAlignment = 1;
        toolDescriptionLabel.setLayoutData((Object)toolDescriptionLabelData);
        this.descriptionTextArea = new Text((Composite)toolPropertiesGroup, 2626);
        this.descriptionTextArea.addModifyListener((ModifyListener)new TextModifyListener(this.descriptionTextArea));
        this.descriptionTextArea.setData(KEY_KEYS, (Object)"toolDescription");
        this.descriptionTextArea.addTraverseListener((TraverseListener)new DescriptionTraverseListener());
        GridData descriptionData = new GridData(1808);
        descriptionData.heightHint = 50;
        descriptionData.horizontalSpan = 2;
        this.descriptionTextArea.setLayoutData((Object)descriptionData);
        Group userInformationGroup = new Group(toolDataComp, 0);
        userInformationGroup.setText(Messages.userInformationGroup);
        userInformationGroup.setLayout((Layout)new GridLayout(2, false));
        GridData userInfoData = new GridData(768);
        userInformationGroup.setLayoutData((Object)userInfoData);
        this.integratorName = this.addLabelAndTextfieldForPropertyToComposite((Composite)userInformationGroup, Messages.nameIntegrator, "toolIntegratorName");
        this.integratorEmail = this.addLabelAndTextfieldForPropertyToComposite((Composite)userInformationGroup, Messages.email, "toolIntegratorE-Mail");
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.validate(false);
    }

    private String validateDoc() {
        if (this.documenationText.getText() != null && !this.documenationText.getText().isEmpty()) {
            File doc = new File(this.documenationText.getText());
            if (!(doc.exists() || doc.isAbsolute() || this.configurationMap.get("toolName") == null || ((String)this.configurationMap.get("toolName")).isEmpty())) {
                ToolIntegrationContext context = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext();
                doc = new File(new File(new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), (String)this.configurationMap.get("toolName")), "docs"), this.documenationText.getText());
            }
            if (doc.exists()) {
                String extension = FilenameUtils.getExtension((String)doc.getAbsolutePath());
                if (!ArrayUtils.contains((Object[])ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS, (Object)extension)) {
                    String allowedExt = DOC_EXTENTION_NOT_VALID;
                    String[] stringArray = ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS;
                    int n = ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String current = stringArray[n2];
                        allowedExt = String.valueOf(allowedExt) + current + VALID_EXTENSION_SEPERATOR;
                        ++n2;
                    }
                    return allowedExt.substring(0, allowedExt.length() - VALID_EXTENSION_SEPERATOR.length());
                }
            } else {
                return DOC_DOES_NOT_EXIST;
            }
        }
        return "";
    }

    private String validateIcon() {
        if (this.iconText.getText() != null && !this.iconText.getText().isEmpty()) {
            try {
                BufferedImage image;
                File icon = new File(this.iconText.getText());
                if (!(icon.exists() || icon.isAbsolute() || (String)this.configurationMap.get("toolName") == null || ((String)this.configurationMap.get("toolName")).isEmpty())) {
                    ToolIntegrationContext context = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext();
                    icon = new File(new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), (String)this.configurationMap.get("toolName")), this.iconText.getText());
                }
                if ((image = ImageIO.read(icon)) == null) {
                    return "Icon path or file format is invalid. The default icon will be used.";
                }
            }
            catch (IOException iOException) {
                return "Icon path or file format is invalid. The default icon will be used.";
            }
        }
        return "";
    }

    private String validateName() {
        if (!CrossPlatformFilenameUtils.isFilenameValid((String)this.toolNameText.getText())) {
            return "The chosen filename is not valid.";
        }
        return "";
    }

    private void showGroupSelectionDialog() {
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider());
        dlg.setElements(this.groupNames.toArray());
        dlg.setHelpAvailable(false);
        dlg.setMultipleSelection(false);
        dlg.setStatusLineAboveButtons(false);
        dlg.setMessage(Messages.chooseGroupDlgMessage);
        dlg.setTitle(Messages.chooseGroupDlgTitle);
        if (!this.groupNameText.getText().isEmpty() && this.groupNames.contains(this.groupNameText.getText())) {
            dlg.setInitialSelections((Object[])new String[]{this.groupNameText.getText()});
        }
        if (dlg.open() == 0) {
            this.groupNameText.setText(dlg.getFirstResult().toString());
        }
    }

    private Text addLabelAndTextfieldForPropertyToComposite(Composite composite, String propertyMessage, String key) {
        Label propertyLabel = new Label(composite, 0);
        propertyLabel.setText(propertyMessage);
        Point prefSize = propertyLabel.computeSize(-1, -1);
        GridData labelData = new GridData();
        labelData.widthHint = prefSize.x;
        propertyLabel.setLayoutData((Object)labelData);
        Text propertyText = new Text(composite, 2048);
        GridData gridDataText = new GridData(768);
        propertyText.setLayoutData((Object)gridDataText);
        propertyText.setData(KEY_KEYS, (Object)key);
        propertyText.addModifyListener((ModifyListener)new TextModifyListener(propertyText));
        return propertyText;
    }

    private void validate(boolean update) {
        String name;
        this.setMessage(null, 0);
        this.setPageComplete(true);
        String nameError = StringUtils.checkAgainstCommonInputRules((String)this.toolNameText.getText());
        if (nameError != null) {
            this.setMessage("This tool name is invalid for running the tool via Remote Access:\n  " + nameError, 2);
        }
        if (!this.iconValid.isEmpty()) {
            this.setMessage(this.iconValid, 2);
        }
        if (!this.docValid.isEmpty()) {
            this.setMessage(this.docValid, 3);
            this.setPageComplete(false);
        }
        if ((name = (String)this.configurationMap.get("toolName")) == null || name.trim().isEmpty()) {
            this.setMessage(Messages.toolFilenameInvalid, 3);
            this.setPageComplete(false);
        } else if (!update && this.usedToolnames.contains(this.configurationMap.get("toolName"))) {
            this.setMessage(Messages.toolFilenameUsed, 3);
            this.setPageComplete(false);
        }
        if (!this.nameValid.isEmpty()) {
            this.setMessage(this.nameValid, 3);
            this.setPageComplete(false);
        }
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        if ((String)this.configurationMap.get("toolName") != null) {
            this.usedToolnames.add((String)this.configurationMap.get("toolName"));
        }
        this.configurationMap = newConfigurationMap;
        if (this.configurationMap.get("toolName") != null) {
            this.usedToolnames.remove(this.configurationMap.get("toolName"));
        }
        if (this.configurationMap.get("uploadIcon") == null) {
            this.configurationMap.put("uploadIcon", true);
        }
        this.updatePageValues();
    }

    private void updatePageValues() {
        if ((String)this.configurationMap.get("toolName") != null) {
            this.toolNameText.setText((String)this.configurationMap.get("toolName"));
        } else {
            this.toolNameText.setText("");
        }
        if (this.configurationMap.get("toolIconPath") != null) {
            this.iconText.setText((String)this.configurationMap.get("toolIconPath"));
        } else {
            this.iconText.setText("");
        }
        if (((Boolean)this.configurationMap.get("uploadIcon")).booleanValue()) {
            this.uploadIconToFolder.setSelection(true);
        } else {
            this.uploadIconToFolder.setSelection(false);
        }
        if (this.configurationMap.get("documentationFilePath") != null) {
            this.documenationText.setText((String)this.configurationMap.get("documentationFilePath"));
            File pathToOpen = new File(this.documenationText.getText());
            if (!pathToOpen.isAbsolute()) {
                ToolIntegrationContext context = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext();
                pathToOpen = new File(new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), (String)this.configurationMap.get("toolName")), "docs");
            }
            this.docPathChooserButtonListener.setOpenPath(pathToOpen);
        } else {
            this.documenationText.setText("");
        }
        if (this.configurationMap.get("groupName") != null) {
            this.groupNameText.setText((String)this.configurationMap.get("groupName"));
        } else {
            this.groupNameText.setText("");
        }
        if (this.configurationMap.get("toolDescription") != null) {
            this.descriptionTextArea.setText((String)this.configurationMap.get("toolDescription"));
        } else {
            this.descriptionTextArea.setText("");
        }
        if (this.configurationMap.get("toolIntegratorName") != null) {
            this.integratorName.setText((String)this.configurationMap.get("toolIntegratorName"));
        } else {
            this.integratorName.setText("");
        }
        if (this.configurationMap.get("toolIntegratorE-Mail") != null) {
            this.integratorEmail.setText((String)this.configurationMap.get("toolIntegratorE-Mail"));
        } else {
            this.integratorEmail.setText("");
        }
        this.validate(true);
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    @Override
    public void updatePage() {
    }

    private class DescriptionTraverseListener
    implements TraverseListener {
        private DescriptionTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                e.doit = true;
            }
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private final Text text;

        TextModifyListener(Text text) {
            this.text = text;
        }

        public void modifyText(ModifyEvent arg0) {
            ToolCharacteristicsPage.this.configurationMap.put((String)this.text.getData(ToolCharacteristicsPage.KEY_KEYS), this.text.getText());
            ToolCharacteristicsPage.this.validate(false);
        }
    }
}

