/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser.spi;

import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import java.util.Comparator;
import java.util.Map;

public abstract class DMBrowserNodeUtils {
    public static final Comparator<DMBrowserNode> COMPARATOR_BY_HISTORY_TIMESTAMP = new Comparator<DMBrowserNode>(){

        @Override
        public int compare(DMBrowserNode o1, DMBrowserNode o2) {
            boolean o2NullCheck;
            boolean o1NullCheck = o1 == null || o1.getMetaData() == null;
            boolean bl = o2NullCheck = o2 == null || o2.getMetaData() == null;
            if (o1NullCheck && o2NullCheck) {
                return 0;
            }
            if (o1NullCheck) {
                return Integer.MAX_VALUE;
            }
            if (o2NullCheck) {
                return Integer.MIN_VALUE;
            }
            String val1 = o1.getMetaData().getValue(METADATA_HISTORY_TIMESTAMP);
            String val2 = o2.getMetaData().getValue(METADATA_HISTORY_TIMESTAMP);
            long time1 = this.nullSafeLongValue(val1);
            long time2 = this.nullSafeLongValue(val2);
            return Long.compare(time1, time2);
        }

        private long nullSafeLongValue(String val1) {
            if (val1 == null) {
                return 0L;
            }
            return Long.parseLong(val1);
        }
    };
    public static final Comparator<DMBrowserNode> COMPARATOR_BY_HISTORY_TIMESTAMP_DESC = new Comparator<DMBrowserNode>(){

        @Override
        public int compare(DMBrowserNode o1, DMBrowserNode o2) {
            boolean o2NullCheck;
            boolean o1NullCheck = o1 == null || o1.getMetaData() == null;
            boolean bl = o2NullCheck = o2 == null || o2.getMetaData() == null;
            if (o1NullCheck && o2NullCheck) {
                return 0;
            }
            if (o1NullCheck) {
                return Integer.MAX_VALUE;
            }
            if (o2NullCheck) {
                return Integer.MIN_VALUE;
            }
            String val1 = o1.getMetaData().getValue(METADATA_HISTORY_TIMESTAMP);
            String val2 = o2.getMetaData().getValue(METADATA_HISTORY_TIMESTAMP);
            long time1 = this.nullSafeLongValue(val1);
            long time2 = this.nullSafeLongValue(val2);
            return Long.compare(time1, time2) * -1;
        }

        private long nullSafeLongValue(String val1) {
            if (val1 == null) {
                return 0L;
            }
            return Long.parseLong(val1);
        }
    };
    public static final Comparator<DMBrowserNode> COMPARATOR_BY_FILENAME = new Comparator<DMBrowserNode>(){

        @Override
        public int compare(DMBrowserNode o1, DMBrowserNode o2) {
            boolean o2NullCheck;
            boolean o1NullCheck = o1 == null || o1.getAssociatedFilename() == null;
            boolean bl = o2NullCheck = o2 == null || o2.getAssociatedFilename() == null;
            if (o1NullCheck && o2NullCheck) {
                return 0;
            }
            if (o1NullCheck) {
                return Integer.MIN_VALUE;
            }
            if (o2NullCheck) {
                return Integer.MAX_VALUE;
            }
            String val1 = o1.getAssociatedFilename().toLowerCase();
            String val2 = o2.getAssociatedFilename().toLowerCase();
            return val1.compareTo(val2);
        }
    };
    public static final Comparator<DMBrowserNode> COMPARATOR_BY_NODE_TITLE = new Comparator<DMBrowserNode>(){

        @Override
        public int compare(DMBrowserNode o1, DMBrowserNode o2) {
            boolean o2NullCheck;
            boolean o1NullCheck = o1 == null || o1.getTitle() == null;
            boolean bl = o2NullCheck = o2 == null || o2.getTitle() == null;
            if (o1NullCheck && o2NullCheck) {
                return 0;
            }
            if (o1NullCheck) {
                return Integer.MIN_VALUE;
            }
            if (o2NullCheck) {
                return Integer.MAX_VALUE;
            }
            String val1 = o1.getTitle().toLowerCase();
            String val2 = o2.getTitle().toLowerCase();
            return val1.compareTo(val2);
        }
    };
    public static final Comparator<DMBrowserNode> COMPARATOR_BY_NODE_TITLE_DESC = new Comparator<DMBrowserNode>(){

        @Override
        public int compare(DMBrowserNode o1, DMBrowserNode o2) {
            boolean o2NullCheck;
            boolean o1NullCheck = o1 == null || o1.getTitle() == null;
            boolean bl = o2NullCheck = o2 == null || o2.getTitle() == null;
            if (o1NullCheck && o2NullCheck) {
                return 0;
            }
            if (o1NullCheck) {
                return Integer.MIN_VALUE;
            }
            if (o2NullCheck) {
                return Integer.MAX_VALUE;
            }
            String val1 = o1.getTitle().toLowerCase();
            String val2 = o2.getTitle().toLowerCase();
            return val1.compareTo(val2) * -1;
        }
    };
    private static final int DESC = -1;
    private static final MetaData METADATA_HISTORY_TIMESTAMP = new MetaData("rce.history.orderingindex", true, true);

    private DMBrowserNodeUtils() {
    }

    public static void createDMFileResourceNodesFromMap(Map<String, String> fileMap, DMBrowserNode folder) {
        for (Map.Entry<String, String> entry : fileMap.entrySet()) {
            DMBrowserNode fileNode = DMBrowserNode.addNewLeafNode(entry.getKey(), DMBrowserNodeType.DMFileResource, folder);
            fileNode.setAssociatedFilename(entry.getKey());
            fileNode.setDataReferenceId(entry.getValue());
        }
        folder.sortChildren(COMPARATOR_BY_FILENAME);
    }
}

