/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListenerAdapter;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.gui.communication.views.contributors.AddSshConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EditSshConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EnterPassphraseDialog;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.SimpleNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.net.URL;
import java.util.Collection;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;

public class SshConnectionSetupsListContributor
extends NetworkViewContributorBase {
    private static final AnchorPoints PARENT_ANCHOR = AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE;
    private static final int ROOT_PRIORITY = 30;
    private final Log log = LogFactory.getLog(this.getClass());
    private SelfRenderingNetworkViewNode rootNode;
    private final Image connectedImage;
    private final Image disconnectedImage;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private SshConnectionService sshConnectionService;
    private Collection<SshConnectionSetup> sshConnectionSetups;
    private final WeakHashMap<SshConnectionSetup, SshConnectionSetupNode> wrapperMap = new WeakHashMap();

    public SshConnectionSetupsListContributor() {
        this.connectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/connectSsh.png")).createImage();
        this.disconnectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/disconnectSsh.png")).createImage();
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.sshConnectionService = (SshConnectionService)this.serviceRegistryAccess.getService(SshConnectionService.class);
        this.sshConnectionSetups = this.sshConnectionService.getAllSshConnectionSetups();
        this.registerListeners();
    }

    @Override
    public int getRootElementsPriority() {
        return 30;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        if (parentNode != PARENT_ANCHOR) {
            return null;
        }
        boolean hasChildren = this.sshConnectionSetups != null && !this.sshConnectionSetups.isEmpty();
        this.rootNode = new SimpleNetworkViewNode("SSH Remote Access Connections", this.disconnectedImage, this, hasChildren);
        return new Object[]{this.rootNode};
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 0;
    }

    public void showAddConnectionDialog() {
        AddSshConnectionDialog dialog = new AddSshConnectionDialog(this.treeViewer.getTree().getShell());
        if (dialog.open() == 0) {
            final String connectionName = dialog.getConnectionName();
            final boolean connectImmediately = dialog.getConnectImmediately();
            final String host = dialog.getHost();
            final int port = dialog.getPort();
            final String username = dialog.getUsername();
            final String passphrase = dialog.getPassphrase();
            final boolean storePassphrase = dialog.shouldStorePassPhrase();
            final String keyfileLocation = dialog.getKeyfileLocation();
            final boolean usePassphrase = dialog.getUsePassphrase();
            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                @Override
                @TaskDescription(value="Create new SSH Connection.")
                public void run() {
                    String id = SshConnectionSetupsListContributor.this.sshConnectionService.addSshConnection(connectionName, host, port, username, keyfileLocation, usePassphrase, connectImmediately);
                    SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(id, passphrase, storePassphrase);
                    if (connectImmediately) {
                        SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(id, passphrase);
                    }
                }
            });
        }
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext instanceNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object node) {
        if (node != this.rootNode) {
            throw this.newUnexpectedCallException();
        }
        if (this.sshConnectionSetups.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Object[] nodes = new SshConnectionSetupNode[this.sshConnectionSetups.size()];
        int pos = 0;
        for (SshConnectionSetup setup : this.sshConnectionSetups) {
            SshConnectionSetupNode setupNode = new SshConnectionSetupNode(setup.getId(), setup);
            nodes[pos++] = setupNode;
        }
        return nodes;
    }

    @Override
    public Object getParent(Object node) {
        if (node == this.rootNode) {
            return PARENT_ANCHOR;
        }
        return this.rootNode;
    }

    @Override
    public String getText(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public void dispose() {
        this.connectedImage.dispose();
        this.disconnectedImage.dispose();
        this.serviceRegistryAccess.dispose();
    }

    private void registerListeners() {
        SshConnectionListenerAdapter listener = new SshConnectionListenerAdapter(){

            public void onCollectionChanged(final Collection<SshConnectionSetup> connections) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SshConnectionSetupsListContributor.this.sshConnectionSetups = connections;
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)PARENT_ANCHOR, false);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)SshConnectionSetupsListContributor.this.rootNode, true);
                    }
                });
            }

            public void onConnected(final SshConnectionSetup setup) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)node, true);
                    }
                });
            }

            public void onConnectionAttemptFailed(final SshConnectionSetup setup, final String reason, boolean firstConsecutiveFailure, boolean willAutoRetry) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox dialog = new MessageBox((this).SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 33);
                        dialog.setMessage(StringUtils.format((String)"SSH connection attempt to host %s on port %s failed:\n%s", (Object[])new Object[]{setup.getHost(), setup.getPort(), reason}));
                        dialog.open();
                    }
                });
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    }
                });
            }

            public void onConnectionClosed(final SshConnectionSetup setup, boolean willAutoRetry) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    }
                });
            }
        };
        this.serviceRegistryAccess.registerService(SshConnectionListener.class, (Object)listener);
    }

    private SshConnectionSetupNode getSetupNodeForSetup(SshConnectionSetup setup) {
        return this.wrapperMap.get(setup);
    }

    private final class SshConnectionSetupNode
    implements SelfRenderingNetworkViewNode,
    StandardUserNodeActionNode {
        private final String connectionId;
        private final SshConnectionSetup sshConnectionSetup;

        SshConnectionSetupNode(String connectionId, SshConnectionSetup setup) {
            this.connectionId = connectionId;
            this.sshConnectionSetup = setup;
            SshConnectionSetupsListContributor.this.wrapperMap.put(setup, this);
        }

        @Override
        public NetworkViewContributor getContributor() {
            return SshConnectionSetupsListContributor.this;
        }

        @Override
        public boolean isActionApplicable(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    return !this.sshConnectionSetup.isConnected();
                }
                case STOP: {
                    return this.sshConnectionSetup.isConnected();
                }
                case EDIT: 
                case DELETE: {
                    return !this.sshConnectionSetup.isConnected();
                }
            }
            return false;
        }

        @Override
        public void performAction(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SshConnectionSetupNode.this.sshConnectionSetup.getUsePassphrase() && !SshConnectionSetupNode.this.sshConnectionSetup.getStorePassphrase()) {
                                EnterPassphraseDialog dialog = new EnterPassphraseDialog(((SshConnectionSetupNode)SshConnectionSetupNode.this).SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell());
                                if (dialog.open() == 0) {
                                    SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(SshConnectionSetupNode.this.connectionId, dialog.getPassphrase(), dialog.getStorePassphrase());
                                    SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(SshConnectionSetupNode.this.connectionId, dialog.getPassphrase());
                                }
                            } else {
                                SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(SshConnectionSetupNode.this.connectionId);
                            }
                        }
                    });
                    break;
                }
                case STOP: {
                    SshConnectionSetupsListContributor.this.sshConnectionService.disconnectSession(this.connectionId);
                    break;
                }
                case EDIT: {
                    this.performEdit();
                    break;
                }
                case DELETE: {
                    SshConnectionSetupsListContributor.this.sshConnectionService.disposeConnection(this.connectionId);
                    break;
                }
            }
        }

        private void performEdit() {
            String passphrase;
            EditSshConnectionDialog dialog = new EditSshConnectionDialog(SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), this.sshConnectionSetup.getDisplayName(), this.sshConnectionSetup.getHost(), this.sshConnectionSetup.getPort(), this.sshConnectionSetup.getUsername(), this.sshConnectionSetup.getKeyfileLocation(), this.sshConnectionSetup.getUsePassphrase(), this.sshConnectionSetup.getStorePassphrase(), this.sshConnectionSetup.getConnectOnStartUp());
            if (this.sshConnectionSetup.getStorePassphrase() && (passphrase = SshConnectionSetupsListContributor.this.sshConnectionService.retreiveSshConnectionPassword(this.sshConnectionSetup.getId())) != null) {
                dialog.setPassphrase(passphrase);
            }
            final String id = this.sshConnectionSetup.getId();
            if (dialog.open() == 0) {
                final String connectionName = dialog.getConnectionName();
                final boolean connectImmediately = dialog.getConnectImmediately();
                final String host = dialog.getHost();
                final int port = dialog.getPort();
                final String username = dialog.getUsername();
                final String passphrase2 = dialog.getPassphrase();
                final boolean storePassphrase = dialog.shouldStorePassPhrase();
                final String keyfileLocation = dialog.getKeyfileLocation();
                final boolean usePassphrase = dialog.getUsePassphrase();
                ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                    @Override
                    @TaskDescription(value="Edit SSH Connection.")
                    public void run() {
                        SshConnectionSetupsListContributor.this.sshConnectionService.editSshConnection(new SshConnectionContext(id, connectionName, host, port, username, keyfileLocation, usePassphrase, connectImmediately));
                        SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(id, passphrase2, storePassphrase);
                        if (connectImmediately) {
                            SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(id, passphrase2);
                        }
                    }
                });
            }
        }

        @Override
        public String getText() {
            String status = "connected";
            if (!SshConnectionSetupsListContributor.this.sshConnectionService.isConnected(this.connectionId)) {
                status = "disconnected";
            }
            return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{this.sshConnectionSetup.getDisplayName(), status});
        }

        @Override
        public Image getImage() {
            if (SshConnectionSetupsListContributor.this.sshConnectionService.isConnected(this.connectionId)) {
                return SshConnectionSetupsListContributor.this.connectedImage;
            }
            return SshConnectionSetupsListContributor.this.disconnectedImage;
        }

        @Override
        public boolean getHasChildren() {
            return false;
        }
    }
}

