/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.view.internal;

import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ClusterJobInformationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image runningImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/running.gif")).createImage();
    private Image queuedImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/queued.gif")).createImage();
    private Image completedImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/completed.gif")).createImage();
    private Image othersImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/others.gif")).createImage();

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof ClusterJobInformation) {
            ClusterJobInformation logEntry = (ClusterJobInformation)element;
            if (columnIndex == 0) {
                switch (logEntry.getJobState()) {
                    case Running: {
                        image = this.runningImage;
                        break;
                    }
                    case Queued: 
                    case Waiting: 
                    case DepWait: 
                    case Unsched: {
                        image = this.queuedImage;
                        break;
                    }
                    case Completed: {
                        image = this.completedImage;
                        break;
                    }
                    default: {
                        image = this.othersImage;
                    }
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String returnValue = "";
        if (element instanceof ClusterJobInformation) {
            ClusterJobInformation logEntry = (ClusterJobInformation)element;
            switch (columnIndex) {
                case 0: {
                    returnValue = logEntry.getJobId();
                    break;
                }
                case 1: {
                    returnValue = logEntry.getJobName();
                    break;
                }
                case 2: {
                    returnValue = logEntry.getUser();
                    break;
                }
                case 3: {
                    returnValue = logEntry.getQueue();
                    break;
                }
                case 4: {
                    returnValue = logEntry.getRemainingTime();
                    break;
                }
                case 5: {
                    returnValue = logEntry.getStartTime();
                    break;
                }
                case 6: {
                    returnValue = logEntry.getQueueTime();
                    break;
                }
                case 7: {
                    returnValue = logEntry.getJobState().toString();
                    break;
                }
            }
        }
        return returnValue;
    }

    public void dispose() {
        this.runningImage.dispose();
        this.queuedImage.dispose();
        this.completedImage.dispose();
        this.othersImage.dispose();
    }
}

