/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public final class SshAccountRole {
    private String roleName;
    private List<String> allowedCommandPatterns;
    private String allowedCommandRegEx = null;

    public SshAccountRole(String roleName) {
        this.roleName = roleName;
        this.allowedCommandPatterns = new ArrayList<String>();
        switch (roleName) {
            case "remote access": 
            case "remote_access_user": {
                this.allowedCommandPatterns.add("ra .*");
                this.allowedCommandPatterns.add("sysmon.*");
                break;
            }
            case "remote_access_admin": {
                this.allowedCommandPatterns.add("ra.*");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedCommandPatterns.add("components.*");
                break;
            }
            case "workflow_observer": {
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("net info|net");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedCommandPatterns.add("wf list");
                this.allowedCommandPatterns.add("wf details");
                this.allowedCommandPatterns.add("wf");
                break;
            }
            case "workflow_admin": {
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("net info|net");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedCommandPatterns.add("wf.*");
                break;
            }
            case "local_admin": {
                this.allowedCommandPatterns.add("cn.*");
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("mail.*");
                this.allowedCommandPatterns.add("net.*");
                this.allowedCommandPatterns.add("restart");
                this.allowedCommandPatterns.add("shutdown");
                this.allowedCommandPatterns.add("stop");
                this.allowedCommandPatterns.add("stats");
                this.allowedCommandPatterns.add("tasks.*");
                break;
            }
            case "instance_management_admin": {
                this.allowedCommandPatterns.add("im.*");
                this.allowedCommandPatterns.add("net info|net");
                break;
            }
            case "instance_management_delegate_user": {
                this.allowedCommandPatterns.add("cn.*");
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("net.*");
                this.allowedCommandPatterns.add("restart");
                this.allowedCommandPatterns.add("shutdown");
                this.allowedCommandPatterns.add("stop");
                this.allowedCommandPatterns.add("stats");
                this.allowedCommandPatterns.add("tasks.*");
                this.allowedCommandPatterns.add("wf.*");
                this.allowedCommandPatterns.add("ra-admin.*");
                break;
            }
            case "developer": {
                this.allowedCommandPatterns.add(".*");
                break;
            }
            default: {
                this.roleName = "default";
                LogFactory.getLog(this.getClass()).warn((Object)("Tried to create a role with a name that is not allowed: " + roleName));
            }
            case "default": 
        }
        this.allowedCommandPatterns.add("dummy");
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getAllowedCommandRegEx() {
        if (this.allowedCommandRegEx == null) {
            this.allowedCommandRegEx = "help|exit|(version.*)";
            for (String pattern : this.allowedCommandPatterns) {
                this.allowedCommandRegEx = String.valueOf(this.allowedCommandRegEx) + "|(" + pattern.trim() + ")";
            }
        }
        return this.allowedCommandRegEx;
    }

    public int hashCode() {
        return this.roleName.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof SshAccountRole) {
            SshAccountRole other = (SshAccountRole)obj;
            result = this.roleName.equals(other.getRoleName());
        }
        return result;
    }
}

