/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.testutils;

import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamanagement.backend.MetaDataBackendService;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.EndpointInstance;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalComponentState;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;

public class DMCommandPlugin
implements CommandPlugin {
    private static final int NUMBER_100 = 100;
    private static final int WORKFLOWS_TO_CREATE_IN_PARALLEL = 20;
    private static final int DEFAULT_NUMBER_OF_INPUTS = 5;
    private static final int DEFAULT_NUMBER_OF_ITERATIONS = 10;
    private static final int DEFAULT_NUMBER_OF_COMPONENTS = 10;
    private static final int DEFAULT_NUMBER_OF_WORKFLOWS = 10;
    private static final String DEFAULT_WORKFLOWNAME_PREFIX = "dummy_workflow";
    private static final double DEFAULT_ALLOWED_DEVIATION_IN_PERCENT = 20.0;
    private MetaDataBackendService metaDataService;
    private PlatformService platformService;
    private TypedDatumService typedDatumService;
    private DataManagementService dataManagementService;
    private TypedDatumFactory typedDatumFactory;
    private TypedDatumSerializer typedDatumSerializer;

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken("dm");
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            throw CommandException.unknownCommand((CommandContext)context);
        }
        if (!"create-test-data".equals(subCmd)) {
            throw CommandException.unknownCommand((CommandContext)context);
        }
        this.performDmCreateTestData(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performDmCreateTestData(CommandContext context) throws CommandException {
        CommandException e;
        File dummyFile;
        File logFile;
        File wfFile;
        FileCreationOption fileCreationOption;
        double userDefinedAllowedDeviation;
        int userDefinednumberOfIterations;
        int userDefinednumberOfWorkflows;
        String userDefinedWorkflowNamePrefix;
        block46: {
            InputStream dummyFileStream;
            Object var18_17;
            Throwable throwable;
            TempFileService tempFileService;
            block45: {
                String workflowPrefix = this.readOptionalStringParameter(context, "--prefix");
                userDefinedWorkflowNamePrefix = workflowPrefix != null ? workflowPrefix : DEFAULT_WORKFLOWNAME_PREFIX;
                Integer w = this.readOptionalIntParameter(context, "--workflows");
                userDefinednumberOfWorkflows = w != null ? w : 10;
                Integer iter = this.readOptionalIntParameter(context, "--iterations");
                userDefinednumberOfIterations = iter != null ? iter : 10;
                Double deviationInPercent = this.readOptionalDoubleParameter(context, "--allowedDeviation");
                userDefinedAllowedDeviation = deviationInPercent != null ? deviationInPercent / 100.0 : 0.2;
                if (userDefinednumberOfWorkflows < 0) throw CommandException.executionError((String)"Negative values are not supported.", (CommandContext)context);
                if (userDefinednumberOfIterations < 0) throw CommandException.executionError((String)"Negative values are not supported.", (CommandContext)context);
                if (userDefinedAllowedDeviation < 0.0) {
                    throw CommandException.executionError((String)"Negative values are not supported.", (CommandContext)context);
                }
                if (userDefinedAllowedDeviation > 1.0) {
                    throw CommandException.executionError((String)"Deviation of more than 100% is not supported.", (CommandContext)context);
                }
                List fileTokens = context.consumeRemainingTokens();
                fileCreationOption = FileCreationOption.NONE;
                if (fileTokens.contains("--smallfiles")) {
                    fileCreationOption = FileCreationOption.SMALL;
                    if (fileTokens.contains("--bigfiles")) {
                        context.println((Object)"Both --smallfiles and --bigfiles were set, --smallfiles will be used.");
                    }
                } else if (fileTokens.contains("--bigfiles")) {
                    fileCreationOption = FileCreationOption.BIG;
                }
                tempFileService = TempFileServiceAccess.getInstance();
                try {
                    throwable = null;
                    var18_17 = null;
                    try {
                        InputStream wfFileStream = this.getClass().getResourceAsStream("/DummyWorkflowFile.txt");
                        try {
                            try (InputStream logFileStream = this.getClass().getResourceAsStream("/DummyLogFile.txt");){
                                wfFile = tempFileService.createTempFileWithFixedFilename("DummyWorkflowFile.txt");
                                FileUtils.copyInputStreamToFile((InputStream)wfFileStream, (File)wfFile);
                                logFile = tempFileService.createTempFileWithFixedFilename("DummyLogFile.txt");
                                FileUtils.copyInputStreamToFile((InputStream)logFileStream, (File)logFile);
                            }
                            if (wfFileStream == null) break block45;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (wfFileStream == null) throw throwable;
                            wfFileStream.close();
                            throw throwable;
                        }
                        wfFileStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw CommandException.executionError((String)"Could not read dummy files from resources folder.", (CommandContext)context);
                }
            }
            if (fileCreationOption.equals((Object)FileCreationOption.SMALL)) {
                try {
                    throwable = null;
                    var18_17 = null;
                    try {
                        dummyFileStream = this.getClass().getResourceAsStream("/SmallDummyFile.txt");
                        try {
                            dummyFile = tempFileService.createTempFileWithFixedFilename("SmallDummyFile.txt");
                            FileUtils.copyInputStreamToFile((InputStream)dummyFileStream, (File)dummyFile);
                            break block46;
                        }
                        finally {
                            if (dummyFileStream != null) {
                                dummyFileStream.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw CommandException.executionError((String)"Could not read dummy file from resources folder.", (CommandContext)context);
                }
            }
            if (fileCreationOption.equals((Object)FileCreationOption.BIG)) {
                try {
                    throwable = null;
                    var18_17 = null;
                    try {
                        dummyFileStream = this.getClass().getResourceAsStream("/BigDummyFile.xml");
                        try {
                            dummyFile = tempFileService.createTempFileWithFixedFilename("BigDummyFile.xml");
                            FileUtils.copyInputStreamToFile((InputStream)dummyFileStream, (File)dummyFile);
                            break block46;
                        }
                        finally {
                            if (dummyFileStream != null) {
                                dummyFileStream.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                            throw throwable;
                        }
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw CommandException.executionError((String)"Could not read dummy file from resources folder.", (CommandContext)context);
                }
            }
            dummyFile = null;
        }
        String localNodeId = this.platformService.getLocalInstanceNodeSessionId().getInstanceNodeSessionIdString();
        this.typedDatumFactory = this.typedDatumService.getFactory();
        this.typedDatumSerializer = this.typedDatumService.getSerializer();
        context.println((Object)"Creating workflows...");
        int workflowIndex = 0;
        block23: while (true) {
            if (workflowIndex >= userDefinednumberOfWorkflows) {
                context.println((Object)("Finished creating test data: created " + userDefinednumberOfWorkflows + " workflows."));
                return;
            }
            CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(CommandException.class);
            int i = 0;
            while (i < 20) {
                int numberOfComponents = this.randomizeValue(10, userDefinedAllowedDeviation);
                int numberOfInputs = this.randomizeValue(5, userDefinedAllowedDeviation);
                int numberOfIterations = this.randomizeValue(userDefinednumberOfIterations, userDefinedAllowedDeviation);
                CreateWorkflowCallableContext workflowCreationContext = new CreateWorkflowCallableContext(wfFile, userDefinedWorkflowNamePrefix, localNodeId, context, dummyFile, logFile, numberOfComponents, numberOfInputs, ++workflowIndex, numberOfIterations, fileCreationOption);
                callablesGroup.add((Callable)new CreateWorkflowCallable(workflowCreationContext));
                if (workflowIndex >= userDefinednumberOfWorkflows) break;
                ++i;
            }
            List exceptions = callablesGroup.executeParallel(null);
            Iterator iterator = exceptions.iterator();
            do {
                if (!iterator.hasNext()) continue block23;
            } while ((e = (CommandException)iterator.next()) == null);
            break;
        }
        throw e;
    }

    private int randomizeValue(int defaultValue, double allowedDeviation) {
        return (int)Math.round((Math.random() * (2.0 * allowedDeviation) + (1.0 - allowedDeviation)) * (double)defaultValue);
    }

    private Integer readOptionalIntParameter(CommandContext context, String parameter) throws CommandException {
        if (context.consumeNextTokenIfEquals(parameter)) {
            String number = context.consumeNextToken();
            if (number == null) {
                throw CommandException.syntaxError((String)"Missing number", (CommandContext)context);
            }
            try {
                return Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }
        return null;
    }

    private String readOptionalStringParameter(CommandContext context, String parameter) throws CommandException {
        if (context.consumeNextTokenIfEquals(parameter)) {
            String prefix = context.consumeNextToken();
            if (prefix == null) {
                throw CommandException.syntaxError((String)"Missing Workflow Name Prefix", (CommandContext)context);
            }
            return prefix;
        }
        return null;
    }

    private Double readOptionalDoubleParameter(CommandContext context, String parameter) throws CommandException {
        if (context.consumeNextTokenIfEquals(parameter)) {
            String number = context.consumeNextToken();
            if (number == null) {
                throw CommandException.syntaxError((String)"Missing number", (CommandContext)context);
            }
            try {
                return Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }
        return null;
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription("dm create-test-data [--workflows <number of workflows>] [--iterations <number of iterations per workflow>]\n\t [--allowedDeviation <allowed deviation of values in %>] [--smallfiles] [--bigfiles]", "", true, "creates test data in the database. ", new String[]{"If --smallfiles or --bigfiles is set, files are generated as inputs/outputs of the components.", " Values for number of iterations, number of components, number of inputs/outputs are randomized, deviating at most <allowedDeviation> % from default values (default 20%)"}));
        return contributions;
    }

    public void bindMetaDataService(MetaDataBackendService newInstance) {
        this.metaDataService = newInstance;
    }

    public void bindTypedDatumService(TypedDatumService newInstance) {
        this.typedDatumService = newInstance;
    }

    public void bindPlatformService(PlatformService newInstance) {
        this.platformService = newInstance;
    }

    public void bindDataManagementService(DataManagementService newInstance) {
        this.dataManagementService = newInstance;
    }

    public void activate() {
    }

    private final class CreateWorkflowCallable
    implements Callable<CommandException> {
        private CreateWorkflowCallableContext workflowCreationContext;

        private CreateWorkflowCallable(CreateWorkflowCallableContext workflowCreationContext) {
            this.workflowCreationContext = workflowCreationContext;
        }

        @Override
        @TaskDescription(value="Create a single workflow entry.")
        public CommandException call() {
            try {
                String workflowTitle = String.valueOf(this.workflowCreationContext.prefixName) + "_" + this.workflowCreationContext.workflowNumber;
                Long id = DMCommandPlugin.this.metaDataService.addWorkflowRun(workflowTitle, this.workflowCreationContext.localNodeId, this.workflowCreationContext.localNodeId, System.currentTimeMillis());
                MetaDataSet mds = new MetaDataSet();
                MetaData mdWorkflowRunId = new MetaData("rce.common.workflow_run_id", true, true);
                mds.setValue(mdWorkflowRunId, id.toString());
                try {
                    String wfFileReference = DMCommandPlugin.this.dataManagementService.createReferenceFromLocalFile(this.workflowCreationContext.wfFile, mds, (ResolvableNodeId)DMCommandPlugin.this.platformService.getLocalInstanceNodeSessionId());
                    FileReferenceTD fileRefTD = DMCommandPlugin.this.typedDatumFactory.createFileReference(wfFileReference, this.workflowCreationContext.wfFile.getName());
                    DMCommandPlugin.this.metaDataService.addWorkflowFileToWorkflowRun(id, DMCommandPlugin.this.typedDatumSerializer.serialize((TypedDatum)fileRefTD));
                }
                catch (AuthorizationException | CommunicationException | IOException | InterruptedException e) {
                    return CommandException.executionError((String)("Failed to upload wf file." + e), (CommandContext)this.workflowCreationContext.context);
                }
                HashSet<ComponentInstance> componentInstances = new HashSet<ComponentInstance>();
                int j = 1;
                while (j <= this.workflowCreationContext.numberOfComponents) {
                    componentInstances.add(new ComponentInstance(UUID.randomUUID().toString(), "de.rcenvironment.script/3.4", "Script " + j, null));
                    ++j;
                }
                Map<String, Long> compInstDmIds = DMCommandPlugin.this.metaDataService.addComponentInstances(id, componentInstances);
                HashSet<EndpointInstance> endpointInstancesIn = new HashSet<EndpointInstance>();
                HashSet<EndpointInstance> endpointInstancesOut = new HashSet<EndpointInstance>();
                int z = 1;
                while (z <= this.workflowCreationContext.numberOfInputs) {
                    HashMap<String, String> metaData = new HashMap<String, String>();
                    metaData.put("rce.common.data_type", DataType.Float.getShortName());
                    endpointInstancesIn.add(new EndpointInstance("input_" + z, EndpointType.INPUT, metaData));
                    endpointInstancesOut.add(new EndpointInstance("output_" + z, EndpointType.OUTPUT, metaData));
                    ++z;
                }
                for (Long componentInstanceId : compInstDmIds.values()) {
                    Map<String, Long> endpointIdsIn = DMCommandPlugin.this.metaDataService.addEndpointInstances(componentInstanceId, endpointInstancesIn);
                    Map<String, Long> endpointIdsOut = DMCommandPlugin.this.metaDataService.addEndpointInstances(componentInstanceId, endpointInstancesOut);
                    long typedDatumId = 0L;
                    int j2 = 1;
                    while (j2 <= this.workflowCreationContext.numberOfIterations) {
                        String logFileReference;
                        Long componentRunId = DMCommandPlugin.this.metaDataService.addComponentRun(componentInstanceId, this.workflowCreationContext.localNodeId, j2, System.currentTimeMillis());
                        for (Long endpointInstanceId : endpointIdsOut.values()) {
                            FloatTD datum;
                            if ((this.workflowCreationContext.fileCreationOption.equals((Object)FileCreationOption.SMALL) || this.workflowCreationContext.fileCreationOption.equals((Object)FileCreationOption.BIG)) && this.workflowCreationContext.dummyFile != null) {
                                String dummyFileReference;
                                try {
                                    dummyFileReference = DMCommandPlugin.this.dataManagementService.createReferenceFromLocalFile(this.workflowCreationContext.dummyFile, mds, (ResolvableNodeId)DMCommandPlugin.this.platformService.getLocalInstanceNodeSessionId());
                                }
                                catch (AuthorizationException | CommunicationException | IOException | InterruptedException throwable) {
                                    return CommandException.executionError((String)"Could not create reference for dummy file.", (CommandContext)this.workflowCreationContext.context);
                                }
                                datum = DMCommandPlugin.this.typedDatumFactory.createFileReference(dummyFileReference, this.workflowCreationContext.dummyFile.getName());
                            } else {
                                datum = DMCommandPlugin.this.typedDatumFactory.createFloat(7.0);
                            }
                            String datumSerialized = DMCommandPlugin.this.typedDatumSerializer.serialize((TypedDatum)datum);
                            typedDatumId = DMCommandPlugin.this.metaDataService.addOutputDatum(componentRunId, endpointInstanceId, datumSerialized, j2);
                        }
                        for (Long endpointInstanceId : endpointIdsIn.values()) {
                            DMCommandPlugin.this.metaDataService.addInputDatum(componentRunId, typedDatumId, endpointInstanceId, j2);
                        }
                        DMCommandPlugin.this.metaDataService.setComponentRunFinished(componentRunId, System.currentTimeMillis(), FinalComponentRunState.FINISHED);
                        HashMap<String, String> properties = new HashMap<String, String>();
                        try {
                            logFileReference = DMCommandPlugin.this.dataManagementService.createReferenceFromLocalFile(this.workflowCreationContext.logFile, mds, (ResolvableNodeId)DMCommandPlugin.this.platformService.getLocalInstanceNodeSessionId());
                        }
                        catch (AuthorizationException | CommunicationException | IOException | InterruptedException throwable) {
                            return CommandException.executionError((String)"Could not store dummy component log file.", (CommandContext)this.workflowCreationContext.context);
                        }
                        FileReferenceTD logRefTD = DMCommandPlugin.this.typedDatumFactory.createFileReference(logFileReference, this.workflowCreationContext.logFile.getName());
                        properties.put("compLogFile", DMCommandPlugin.this.typedDatumService.getSerializer().serialize((TypedDatum)logRefTD));
                        DMCommandPlugin.this.metaDataService.addComponentRunProperties(componentRunId, properties);
                        ++j2;
                    }
                    DMCommandPlugin.this.metaDataService.setComponentInstanceFinalState(componentInstanceId, FinalComponentState.FINISHED);
                }
                DMCommandPlugin.this.metaDataService.setWorkflowRunFinished(id, System.currentTimeMillis(), FinalWorkflowState.FINISHED);
                String type = "float";
                if (this.workflowCreationContext.fileCreationOption.equals((Object)FileCreationOption.BIG)) {
                    type = "big files";
                } else if (this.workflowCreationContext.fileCreationOption.equals((Object)FileCreationOption.SMALL)) {
                    type = "small files";
                }
                this.workflowCreationContext.context.println((Object)StringUtils.format((String)"Created workflow %s: %d components, %d iterations, %d inputs/outputs (%s) per component.", (Object[])new Object[]{workflowTitle, this.workflowCreationContext.numberOfComponents, this.workflowCreationContext.numberOfIterations, this.workflowCreationContext.numberOfInputs, type}));
            }
            catch (RemoteOperationException remoteOperationException) {
                return CommandException.executionError((String)"Could not store workflow runs.", (CommandContext)this.workflowCreationContext.context);
            }
            return null;
        }
    }

    private final class CreateWorkflowCallableContext {
        private File wfFile;
        private String prefixName;
        private String localNodeId;
        private CommandContext context;
        private File dummyFile;
        private File logFile;
        private int numberOfComponents;
        private int numberOfInputs;
        private int workflowNumber;
        private int numberOfIterations;
        private FileCreationOption fileCreationOption;

        private CreateWorkflowCallableContext(File wfFile, String prefixName, String localNodeId, CommandContext context, File dummyFile, File logFile, int numberOfComponents, int numberOfInputs, int workflowNumber, int numberOfIterations, FileCreationOption fileCreationOption) {
            this.wfFile = wfFile;
            this.prefixName = prefixName;
            this.localNodeId = localNodeId;
            this.context = context;
            this.dummyFile = dummyFile;
            this.logFile = logFile;
            this.numberOfComponents = numberOfComponents;
            this.numberOfInputs = numberOfInputs;
            this.workflowNumber = workflowNumber;
            this.numberOfIterations = numberOfIterations;
            this.fileCreationOption = fileCreationOption;
        }
    }

    private static enum FileCreationOption {
        NONE,
        SMALL,
        BIG;

    }
}

