/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.commons;

import de.rcenvironment.core.utils.incubator.Assertions;
import java.io.Serializable;

public final class MetaData
implements Cloneable,
Serializable {
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_VALUE_LENGTH = 32000;
    public static final String PROTECTEDKEYPREFIX = "de.rcenvironment.rce.datamanagement.";
    public static final MetaData AUTHOR = new MetaData("de.rcenvironment.rce.datamanagement.author", false, true);
    public static final MetaData DATE = new MetaData("de.rcenvironment.rce.datamanagement.date", false, true);
    public static final MetaData SIZE = new MetaData("de.rcenvironment.rce.datamanagement.size", false, true);
    public static final MetaData CREATOR = new MetaData("de.rcenvironment.rce.datamanagement.creator", true, true);
    private static final long serialVersionUID = -8984237820030181855L;
    private final String key;
    private final boolean isReadOnly;

    public MetaData(String key, boolean isRevisionIndependent) {
        this(key, isRevisionIndependent, false);
    }

    public MetaData(String key, boolean isRevisionIndependent, boolean isReadOnly) {
        Assertions.isTrue((key.length() <= 255 ? 1 : 0) != 0, (String)"key > 255");
        this.key = key;
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Deprecated
    public static MetaData create(String key, boolean isRevisionIndependent) {
        Assertions.isDefined((Object)key, (String)"Key must not be null.");
        Assertions.isFalse((boolean)key.isEmpty(), (String)"Key must not be empty.");
        if (key.startsWith(PROTECTEDKEYPREFIX)) {
            return new MetaData(key, isRevisionIndependent, true);
        }
        return new MetaData(key, isRevisionIndependent, false);
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int result = 1;
        result = this.isReadOnly ? 31 * result + 1231 : 31 * result + 1237;
        result = this.key == null ? (result *= 31) : 31 * result + this.key.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaData other = (MetaData)obj;
        if (this.isReadOnly != other.isReadOnly) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.getKey();
    }
}

