/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.commons;

import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.datamanagement.commons.EndpointData;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class ComponentRun
implements Serializable,
Comparable<ComponentRun> {
    private static final long serialVersionUID = -366100876644355558L;
    private final Long componentInstanceID;
    private final Long componentRunID;
    private final FinalComponentRunState finalState;
    private final String logicalNodeId;
    private transient LogicalNodeId logicalNodeIdObject;
    private final Integer runCounter;
    private final Long startTime;
    private final Long endTime;
    private final String historyDataItem;
    private final Boolean referencesDeleted;
    private Set<EndpointData> endpointData;
    private final Map<String, String> metaData;

    public ComponentRun(Long componentRunID, Long componentInstanceID, String logicalNodeId, Integer runCounter, Long startTime, Long endtime, String historyDataItem, Boolean referencesDeleted, Map<String, String> metaData, FinalComponentRunState finalState) {
        this.componentRunID = componentRunID;
        this.componentInstanceID = componentInstanceID;
        this.logicalNodeId = logicalNodeId;
        this.runCounter = runCounter;
        this.startTime = startTime;
        this.endTime = endtime;
        this.historyDataItem = historyDataItem;
        this.referencesDeleted = referencesDeleted;
        this.endpointData = null;
        this.metaData = metaData;
        this.finalState = finalState;
    }

    public ComponentRun(Long componentRunId, String logicalNodeId, Integer runCounter, Long startTime, Long endtime, String historyDataItem, Boolean referencesDeleted, Map<String, String> metaData, FinalComponentRunState finalState) {
        this.componentRunID = componentRunId;
        this.componentInstanceID = null;
        this.logicalNodeId = logicalNodeId;
        this.runCounter = runCounter;
        this.startTime = startTime;
        this.endTime = endtime;
        this.historyDataItem = historyDataItem;
        this.referencesDeleted = referencesDeleted;
        this.endpointData = null;
        this.metaData = metaData;
        this.finalState = finalState;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getHistoryDataItem() {
        return this.historyDataItem;
    }

    public String getLogicalNodeIdString() {
        return this.logicalNodeId;
    }

    public synchronized LogicalNodeId getLogicalNodeId() {
        if (this.logicalNodeIdObject == null && this.logicalNodeId != null) {
            try {
                this.logicalNodeIdObject = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeId((String)this.logicalNodeId);
            }
            catch (IdentifierException e) {
                throw new RuntimeException("Failed to parse component run location string (expected an instance id or logical node id)", e);
            }
        }
        return this.logicalNodeIdObject;
    }

    public Integer getRunCounter() {
        return this.runCounter;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getComponentInstanceID() {
        return this.componentInstanceID;
    }

    public Long getComponentRunID() {
        return this.componentRunID;
    }

    public FinalComponentRunState getFinalState() {
        return this.finalState;
    }

    public Set<EndpointData> getEndpointData() {
        return this.endpointData;
    }

    public void setEndpointData(Set<EndpointData> endpointData) {
        this.endpointData = endpointData;
    }

    public Boolean isReferencesDeleted() {
        return this.referencesDeleted;
    }

    public String getLogFile() {
        return this.metaData.get("compLogFile");
    }

    public String getErrorLogFile() {
        return this.metaData.get("compErrorLogFile");
    }

    @Override
    public int compareTo(ComponentRun arg0) {
        return this.getStartTime().compareTo(arg0.getStartTime());
    }
}

