/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.profile;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.configuration.bootstrap.profile.BaseProfile;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class CommonProfileUtils {
    private static final int COMMON_PROFILE_VERSION = 1;
    private static final int MILLIS_BETWEEN_LOCKING_ATTEMPTS = 500;
    private static final String SAVED_DEFAULT_PROFILE_ERROR_TEMPLATE = "Unable to read the default profile path from %s.";
    private static final int MAX_LOCKING_ATTEMPTS = 20;
    private static CommonProfileUtils instance;
    private BaseProfile commonProfile;
    private File profilesInformationDirectory;
    private File defaultProfileFile;
    private File recentlyUsedProfilesFile;
    private File profileParent;
    private ObjectMapper mapper;

    private CommonProfileUtils() throws CommonProfileException {
        try {
            this.profileParent = ProfileUtils.getProfilesParentDirectory();
        }
        catch (ProfileException e) {
            throw new CommonProfileException("Error while determining the profiles parent directory.", e);
        }
        File commonProfileDirectory = Paths.get(this.profileParent.getAbsolutePath(), "common").toFile();
        try {
            this.commonProfile = new BaseProfile(commonProfileDirectory, 1, true);
        }
        catch (ProfileException e) {
            throw new CommonProfileException("The common profile cannot be initialized.", e);
        }
        this.profilesInformationDirectory = new File(this.commonProfile.getProfileDirectory(), "profiles");
        this.defaultProfileFile = new File(this.profilesInformationDirectory, "defaultProfile");
        this.recentlyUsedProfilesFile = new File(this.profilesInformationDirectory, "recentlyUsed");
        this.mapper = JsonUtils.getDefaultObjectMapper();
    }

    protected static synchronized <T> T lockExecuteRelease(Command<T> command) throws CommonProfileException {
        if (instance == null) {
            instance = new CommonProfileUtils();
        } else {
            try {
                if (!CommonProfileUtils.instance.profileParent.equals(ProfileUtils.getProfilesParentDirectory())) {
                    instance = new CommonProfileUtils();
                }
            }
            catch (ProfileException e) {
                throw new CommonProfileException("Error while determining the profiles parent directory.", e);
            }
        }
        boolean lockAquired = false;
        int i = 0;
        while (i < 20) {
            try {
                lockAquired = CommonProfileUtils.instance.commonProfile.attemptToLockProfileDirectory();
                if (lockAquired) break;
                Thread.sleep(500L);
            }
            catch (ProfileException | InterruptedException e) {
                throw new CommonProfileException("Unable to lock the common profile.", e);
            }
            ++i;
        }
        if (!lockAquired) {
            throw new CommonProfileException("Unable to lock the common profile.");
        }
        try {
            T t = command.execute();
            return t;
        }
        finally {
            try {
                CommonProfileUtils.instance.commonProfile.releaseLock();
            }
            catch (IOException e) {
                throw new CommonProfileException("Unable to release the common profile lock.", e);
            }
        }
    }

    public static List<Profile> getRecentlyUsedProfiles() throws CommonProfileException {
        return CommonProfileUtils.lockExecuteRelease(new Command<List<Profile>>(){

            @Override
            public List<Profile> execute() throws CommonProfileException {
                LinkedList<Profile> recentlyUsedProfiles = new LinkedList<Profile>();
                if (instance.recentlyUsedProfilesFile.exists()) {
                    List<String> lines;
                    try {
                        lines = Files.readAllLines(instance.recentlyUsedProfilesFile.toPath(), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new CommonProfileException("Unable to read the list of recently used profiles.", e);
                    }
                    for (String line : lines) {
                        try {
                            Profile recentlyUsedProfile = new Profile(new File(line), false);
                            recentlyUsedProfiles.add(recentlyUsedProfile);
                        }
                        catch (ProfileException profileException) {}
                    }
                }
                return recentlyUsedProfiles;
            }
        });
    }

    public static void markAsRecentlyUsed(final Profile profile) throws CommonProfileException {
        CommonProfileUtils.lockExecuteRelease(new Command<Void>(){

            @Override
            public Void execute() throws CommonProfileException {
                try {
                    instance.profilesInformationDirectory.mkdirs();
                    instance.recentlyUsedProfilesFile.createNewFile();
                    List<String> lines = Files.readAllLines(instance.recentlyUsedProfilesFile.toPath(), StandardCharsets.UTF_8);
                    String lineRepresentingCurrentProfile = null;
                    for (String line : lines) {
                        File recentlyUsedProfile = new File(line);
                        if (!recentlyUsedProfile.getCanonicalPath().equals(profile.getProfileDirectory().getCanonicalPath())) continue;
                        lineRepresentingCurrentProfile = line;
                        break;
                    }
                    if (lineRepresentingCurrentProfile != null) {
                        lines.remove(lineRepresentingCurrentProfile);
                    }
                    lines.add(0, profile.getProfileDirectory().getCanonicalPath());
                    Throwable throwable = null;
                    Iterator<String> iterator = null;
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(instance.recentlyUsedProfilesFile), StandardCharsets.UTF_8);){
                        for (String line : lines) {
                            writer.write(line);
                            writer.write(System.lineSeparator());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new CommonProfileException("Cannot mark the profile as recently used.", e);
                }
                return null;
            }
        });
    }

    private static Map<File, File> readSavedDefaultProfiles() throws JsonParseException, JsonMappingException, IOException {
        Map<File, File> installationToDefaultProfileMap = CommonProfileUtils.instance.defaultProfileFile.isFile() ? (Map)CommonProfileUtils.instance.mapper.readValue(CommonProfileUtils.instance.defaultProfileFile, (TypeReference)new TypeReference<HashMap<File, File>>(){}) : new HashMap<File, File>();
        return installationToDefaultProfileMap;
    }

    public static void markAsDefaultProfile(final Profile profile) throws CommonProfileException {
        CommonProfileUtils.lockExecuteRelease(new Command<Void>(){

            @Override
            public Void execute() throws CommonProfileException {
                instance.profilesInformationDirectory.mkdirs();
                try {
                    Map installationToDefaultProfileMap = CommonProfileUtils.readSavedDefaultProfiles();
                    File currentInstallationDir = BootstrapConfiguration.getInstallationDir();
                    installationToDefaultProfileMap.put(currentInstallationDir, profile.getProfileDirectory());
                    instance.mapper.writeValue(instance.defaultProfileFile, (Object)installationToDefaultProfileMap);
                }
                catch (IOException e) {
                    throw new CommonProfileException("Error while trying to access the file storing the default profiles.", e);
                }
                return null;
            }
        });
    }

    public static File getSavedDefaultProfile() throws CommonProfileException {
        return CommonProfileUtils.lockExecuteRelease(new Command<File>(){

            @Override
            public File execute() throws CommonProfileException {
                if (instance.defaultProfileFile.isFile()) {
                    block8: {
                        File savedDefaultPath;
                        block7: {
                            try {
                                Map installationToDefaultProfileMap = CommonProfileUtils.readSavedDefaultProfiles();
                                File currentInstallationDir = BootstrapConfiguration.getInstallationDir();
                                savedDefaultPath = (File)installationToDefaultProfileMap.get(currentInstallationDir);
                                if (savedDefaultPath != null) break block7;
                                return null;
                            }
                            catch (IOException e) {
                                throw new CommonProfileException(StringUtils.format((String)CommonProfileUtils.SAVED_DEFAULT_PROFILE_ERROR_TEMPLATE, (Object[])new Object[]{instance.defaultProfileFile.getAbsolutePath()}), e);
                            }
                        }
                        if (!savedDefaultPath.isAbsolute()) break block8;
                        try {
                            new Profile(savedDefaultPath, false);
                            return savedDefaultPath;
                        }
                        catch (ProfileException profileException) {
                            return null;
                        }
                    }
                    throw new CommonProfileException(StringUtils.format((String)CommonProfileUtils.SAVED_DEFAULT_PROFILE_ERROR_TEMPLATE, (Object[])new Object[]{instance.defaultProfileFile.getAbsolutePath()}));
                }
                return null;
            }
        });
    }

    public static void clearDefaultProfile() throws CommonProfileException {
        CommonProfileUtils.lockExecuteRelease(new Command<Void>(){

            @Override
            public Void execute() throws CommonProfileException {
                try {
                    if (instance.defaultProfileFile.isFile()) {
                        Map installationToDefaultProfileMap = CommonProfileUtils.readSavedDefaultProfiles();
                        File currentInstallationDir = BootstrapConfiguration.getInstallationDir();
                        installationToDefaultProfileMap.remove(currentInstallationDir);
                        instance.mapper.writeValue(instance.defaultProfileFile, (Object)installationToDefaultProfileMap);
                    }
                }
                catch (IOException e) {
                    throw new CommonProfileException("Error while trying to access the file storing the default profiles.", e);
                }
                return null;
            }
        });
    }

    protected static interface Command<T> {
        public T execute() throws CommonProfileException;
    }
}

