/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import de.rcenvironment.core.configuration.bootstrap.CommandStack;
import de.rcenvironment.core.configuration.bootstrap.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class LaunchParameters {
    private static final String MESSAGE_CONFLICTING_PARAMETERS = "Invalid combination of command-line parameters: cannot specify the same parameter several times";
    private static final String[] PARAMETER_TOKENS_TO_IGNORE = new String[]{"-launcher", "-name", "-application", "-data", "-configuration", "-dev", "-os", "-ws", "-arch", "-nl", "-startup", "-vm", "-exitdata", "-showsplash", "--launcher.XXMaxPermSize", "--launcher.library", "--launcher.overrideVmargs"};
    private static final String[] FLAG_TOKENS_TO_IGNORE = new String[]{"-consoleLog", "-console", "-clean", "-nosplash", "-noSplash"};
    private static final LaunchParameters INSTANCE = new LaunchParameters();
    private List<String> tokens;

    private LaunchParameters() {
        this.readParameters();
    }

    public static LaunchParameters getInstance() {
        return INSTANCE;
    }

    public void readParameters() {
        String commandString = System.getProperty("eclipse.commands");
        if (commandString == null) {
            commandString = "";
        }
        String[] tokenArray = commandString.trim().split("\\n");
        ArrayList<String> filteredTokens = new ArrayList<String>();
        List<String> parametersToIgnore = Arrays.asList(PARAMETER_TOKENS_TO_IGNORE);
        List<String> flagsToIgnore = Arrays.asList(FLAG_TOKENS_TO_IGNORE);
        CommandStack tokenStack = new CommandStack(tokenArray);
        while (tokenStack.hasNext()) {
            String next = tokenStack.getNext();
            if (parametersToIgnore.contains(next)) {
                if (!tokenStack.hasNextIsValue()) continue;
                tokenStack.getNext();
                continue;
            }
            if (flagsToIgnore.contains(next)) continue;
            filteredTokens.add(next);
        }
        this.tokens = Collections.unmodifiableList(filteredTokens);
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public String getNamedParameter(String shortKey, String longKey) throws ParameterException {
        boolean lastWasKey = false;
        boolean keyFound = false;
        String resultToken = null;
        for (String token : this.tokens) {
            if (lastWasKey && !token.startsWith("-")) {
                resultToken = token;
            }
            if (shortKey.equals(token) || longKey.equals(token)) {
                if (keyFound) {
                    throw new ParameterException(MESSAGE_CONFLICTING_PARAMETERS);
                }
                lastWasKey = true;
                keyFound = true;
                continue;
            }
            lastWasKey = false;
        }
        return resultToken;
    }

    public boolean containsToken(String key) {
        return this.tokens.contains(key);
    }

    public boolean containsToken(String shortKey, String longKey) {
        return this.tokens.contains(shortKey) || this.tokens.contains(longKey);
    }
}

