/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.validation.spi;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSshExecutorComponentValidator
extends AbstractComponentValidator {
    protected abstract List<ComponentValidationMessage> validateSshComponentSpecific(ComponentDescription var1);

    @Override
    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        messages.addAll(this.checkIfStringIsConfigured(componentDescription, "host"));
        messages.addAll(this.checkIfStringIsConfigured(componentDescription, "port"));
        messages.addAll(this.checkIfStringIsConfigured(componentDescription, "sandboxRoot"));
        messages.addAll(this.checkIfStringIsConfigured(componentDescription, "script"));
        List<ComponentValidationMessage> componentSpecificMessages = this.validateSshComponentSpecific(componentDescription);
        if (componentSpecificMessages != null) {
            messages.addAll(this.validateSshComponentSpecific(componentDescription));
        }
        return messages;
    }

    protected List<ComponentValidationMessage> checkIfStringIsConfigured(ComponentDescription componentDescription, String configurationKey) {
        LinkedList<ComponentValidationMessage> messages = new LinkedList<ComponentValidationMessage>();
        String value = this.getProperty(componentDescription, configurationKey);
        if (value == null || value.isEmpty()) {
            ComponentValidationMessage validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, configurationKey, StringUtils.format((String)"%s must be configured", (Object[])new Object[]{configurationKey}), StringUtils.format((String)"%s must be configured", (Object[])new Object[]{configurationKey}));
            messages.add(validationMessage);
        }
        return messages;
    }
}

