/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.impl;

import de.rcenvironment.core.communication.api.ServiceCallContext;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WorkflowExecutionContextImpl
implements WorkflowExecutionContext {
    private static final long serialVersionUID = 238066231055021678L;
    private String executionIdentifier;
    private String instanceName;
    private WorkflowDescription workflowDescription;
    private Map<String, String> componentExecutionIdentifiers;
    private LogicalNodeId nodeIdentifierStartedExecution;
    private String additionalInformation;

    public WorkflowExecutionContextImpl(String executionIdentifier, WorkflowDescription workflowDescription) {
        this.executionIdentifier = executionIdentifier;
        this.workflowDescription = workflowDescription;
        this.componentExecutionIdentifiers = new HashMap<String, String>();
        for (WorkflowNode wfNode : workflowDescription.getWorkflowNodes()) {
            this.componentExecutionIdentifiers.put(wfNode.getIdentifier(), UUID.randomUUID().toString());
        }
    }

    public String getExecutionIdentifier() {
        return this.executionIdentifier;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public LogicalNodeId getNodeId() {
        return this.workflowDescription.getControllerNode();
    }

    public LogicalNodeId getDefaultStorageNodeId() {
        return this.getNodeId();
    }

    @Override
    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    @Override
    public String getCompExeIdByWfNodeId(String wfNodeId) {
        return this.componentExecutionIdentifiers.get(wfNodeId);
    }

    @Override
    public LogicalNodeId getNodeIdStartedExecution() {
        return this.nodeIdentifierStartedExecution;
    }

    @Override
    public String getAdditionalInformationProvidedAtStart() {
        return this.additionalInformation;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setNodeIdentifierStartedExecution(LogicalNodeId nodeIdentifier) {
        this.nodeIdentifierStartedExecution = nodeIdentifier;
    }

    public void setAdditionalInformationProvidedAtStart(String additionalInformationProvidedAtStart) {
        this.additionalInformation = additionalInformationProvidedAtStart;
    }

    public ServiceCallContext getServiceCallContext() {
        return null;
    }
}

