/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.routing.MessageRoutingService;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.ServiceCallResult;
import de.rcenvironment.core.communication.rpc.ServiceCallResultFactory;
import de.rcenvironment.core.communication.rpc.api.RemoteServiceCallSenderService;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.Assertions;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RemoteServiceCallSenderServiceImpl
implements RemoteServiceCallSenderService {
    private static final int OUTGOING_NETWORK_PAYLOAD_SIZE_WARNING_THRESHOLD = 0x100000;
    private MessageRoutingService routingService;
    private final boolean forceLocalRPCSerialization = System.getProperty("rce.internal.forceLocalRPCSerialization") != null;
    private final boolean verboseRequestLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"NetworkRequests");
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public ServiceCallResult performRemoteServiceCall(ServiceCallRequest serviceCallRequest) {
        try {
            NetworkResponse networkResponse;
            byte[] serializedRequest = MessageUtils.serializeObject(serviceCallRequest);
            if (this.forceLocalRPCSerialization) {
                this.log.debug((Object)StringUtils.format((String)"Handling local RPC with forced serialization: %s#%s()", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName()}));
            }
            if (this.verboseRequestLoggingEnabled) {
                this.log.debug((Object)StringUtils.format((String)"Converted RPC to %s.%s() on %s into a network payload of %d bytes", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), serializedRequest.length}));
            }
            if (serializedRequest.length >= 0x100000) {
                this.log.debug((Object)StringUtils.format((String)"Generated a large network message for an RPC to %s.%s() on %s (payload size: %d bytes)", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), serializedRequest.length}));
            }
            if (!(networkResponse = this.routingService.performRoutedRequest(serializedRequest, "rpc", serviceCallRequest.getTargetNodeId().convertToInstanceNodeSessionId())).isSuccess()) {
                return ServiceCallResultFactory.representNetworkErrorAsRemoteOperationException(serviceCallRequest, networkResponse);
            }
            Serializable deserializedContent = networkResponse.getDeserializedContent();
            if (deserializedContent == null) {
                String errorMessage = StringUtils.format((String)"Received null service call result for RPC to %s; response code is %s", (Object[])new Object[]{this.formatServiceRequest(serviceCallRequest), networkResponse.getResultCode()});
                return ServiceCallResultFactory.representInternalErrorAtSender(serviceCallRequest, errorMessage);
            }
            if (!(deserializedContent instanceof ServiceCallResult)) {
                return ServiceCallResultFactory.representInternalErrorAtSender(serviceCallRequest, "Received a serialized response of unexpected type " + deserializedContent.getClass().getName());
            }
            return (ServiceCallResult)deserializedContent;
        }
        catch (SerializationException | RuntimeException e) {
            return ServiceCallResultFactory.representInternalErrorAtSender(serviceCallRequest, "Uncaught exception while performing a service call to " + this.formatServiceRequest(serviceCallRequest), e);
        }
    }

    @Override
    public Object performRemoteServiceCallAsProxy(ServiceCallRequest serviceCallRequest) throws Throwable {
        ServiceCallResult serviceCallResult = this.performRemoteServiceCall(serviceCallRequest);
        if (serviceCallResult == null) {
            throw new RemoteOperationException(StringUtils.format((String)"Received a null object as result for service call to %s", (Object[])new Object[]{this.formatServiceRequest(serviceCallRequest)}));
        }
        if (serviceCallResult.isSuccess()) {
            return serviceCallResult.getReturnValue();
        }
        if (serviceCallResult.isRemoteOperationException()) {
            String errorMessage = serviceCallResult.getRemoteOperationExceptionMessage();
            this.log.debug((Object)StringUtils.format((String)"A remote call to %s#%s() on %s failed: %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), errorMessage}));
            throw new RemoteOperationException(StringUtils.format((String)"%s; the destination instance was %s", (Object[])new Object[]{errorMessage, serviceCallRequest.getTargetNodeId()}));
        }
        Throwable methodException = this.reconstructMethodException(serviceCallRequest, serviceCallResult);
        this.log.debug((Object)StringUtils.format((String)"Re-throwing method exception returned from a from call to %s: %s", (Object[])new Object[]{this.formatServiceRequest(serviceCallRequest), methodException.toString()}));
        if (methodException.getClass() == RemoteOperationException.class) {
            throw new RemoteOperationException(StringUtils.format((String)"%s; the destination instance was %s", (Object[])new Object[]{methodException.getMessage(), serviceCallRequest.getTargetNodeId()}));
        }
        throw methodException;
    }

    private String formatServiceRequest(ServiceCallRequest serviceCallRequest) {
        return StringUtils.format((String)"%s#%s() on %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId()});
    }

    private Throwable reconstructMethodException(ServiceCallRequest serviceCallRequest, ServiceCallResult serviceCallResult) throws Throwable {
        Throwable reconstructedException;
        Constructor<?> stringOnlyConstructor;
        Class<?> exceptionClass;
        String methodExceptionType = serviceCallResult.getMethodExceptionType();
        String methodExceptionMessage = serviceCallResult.getMethodExceptionMessage();
        try {
            exceptionClass = Class.forName(methodExceptionType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error((Object)("Received an unknown Exception class, generating a RemoteOperationException instead: " + methodExceptionType));
            throw new RemoteOperationException(StringUtils.format((String)"The destination instance sent an error type that is not known on the local instance: %s: %s", (Object[])new Object[]{methodExceptionType, methodExceptionMessage}));
        }
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            this.log.error((Object)("The destination node sent a non-Throwable type as the alleged method exception: " + methodExceptionType));
            return new RemoteOperationException(StringUtils.format((String)"The destination instance sent an invalid exception type (unusual behavior): %s: %s", (Object[])new Object[]{methodExceptionType, methodExceptionMessage}));
        }
        try {
            stringOnlyConstructor = exceptionClass.getConstructor(String.class);
            Assertions.isDefined(stringOnlyConstructor, (String)"Unexpected: getConstructor() should never return null");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log.error((Object)StringUtils.format((String)"The destination instance sent a known exception type, but it has no accessible String-only constructor: %s: %s", (Object[])new Object[]{methodExceptionType, methodExceptionMessage}));
            throw new RemoteOperationException(StringUtils.format((String)"%s: %s", (Object[])new Object[]{methodExceptionType, methodExceptionMessage}));
        }
        try {
            reconstructedException = (Throwable)stringOnlyConstructor.newInstance(methodExceptionMessage);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            this.log.error((Object)StringUtils.format((String)"Error reconstructing a method exception (%s: %s)", (Object[])new Object[]{methodExceptionType, methodExceptionMessage}), (Throwable)e);
            throw new RemoteOperationException(StringUtils.format((String)"%s: %s", (Object[])new Object[]{methodExceptionType, methodExceptionMessage}));
        }
        throw reconstructedException;
    }

    public void bindMessageRoutingService(MessageRoutingService newInstance) {
        this.routingService = newInstance;
    }
}

