/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.protocol;

import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageMetaData {
    private static final String KEY_MESSAGE_TYPE = "type";
    private static final String KEY_MESSAGEID = "id";
    private static final String KEY_SENDER = "src";
    private static final String KEY_FINAL_RECIPIENT = "dst";
    private static final String KEY_HOPCOUNT = "hopcount";
    private static final String KEY_TRACE = "trace";
    private Map<String, String> properties;
    private final Log log = LogFactory.getLog(MessageMetaData.class);

    public MessageMetaData() {
        this(new HashMap<String, String>());
    }

    public MessageMetaData(Map<String, String> metaData) {
        this.properties = metaData;
    }

    public static MessageMetaData create() {
        return new MessageMetaData();
    }

    public static MessageMetaData wrap(Map<String, String> metaData) {
        return new MessageMetaData(metaData);
    }

    public static MessageMetaData cloneAndWrap(Map<String, String> metaData) {
        return new MessageMetaData(new HashMap<String, String>(metaData));
    }

    public String getMessageType() {
        return this.getValue(KEY_MESSAGE_TYPE);
    }

    public MessageMetaData setMessageType(String type) {
        this.setValue(KEY_MESSAGE_TYPE, type);
        return this;
    }

    public Map<String, String> cloneData() {
        HashMap<String, String> clone = new HashMap<String, String>();
        clone.putAll(this.properties);
        return clone;
    }

    public Map<String, String> getInnerMap() {
        return this.properties;
    }

    public String getValue(String key) {
        return this.properties.get(key);
    }

    public MessageMetaData setValue(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public MessageMetaData setFinalRecipient(InstanceNodeSessionId receiver) {
        this.setValue(KEY_FINAL_RECIPIENT, receiver.getInstanceNodeSessionIdString());
        return this;
    }

    public MessageMetaData setSender(InstanceNodeSessionId sender) {
        this.setValue(KEY_SENDER, sender.getInstanceNodeSessionIdString());
        return this;
    }

    public MessageMetaData setMessageId(String id) {
        this.setValue(KEY_MESSAGEID, id);
        return this;
    }

    public MessageMetaData addTraceStep(String newStep) {
        String oldValue = this.getValue(KEY_TRACE);
        if (oldValue == null) {
            this.setValue(KEY_TRACE, newStep);
        } else {
            this.setValue(KEY_TRACE, String.valueOf(oldValue) + "," + newStep);
        }
        return this;
    }

    public MessageMetaData incHopCount() {
        if (this.properties.containsKey(KEY_HOPCOUNT)) {
            this.setValue(KEY_HOPCOUNT, Integer.toString(this.getHopCount() + 1));
        } else {
            this.setValue(KEY_HOPCOUNT, "1");
        }
        return this;
    }

    public String getTrace() {
        return this.getValue(KEY_TRACE);
    }

    public String getFinalRecipientIdString() {
        return this.getValue(KEY_FINAL_RECIPIENT);
    }

    public InstanceNodeSessionId getFinalRecipient() {
        String idString = this.getFinalRecipientIdString();
        if (idString != null) {
            return NodeIdentifierUtils.parseInstanceNodeSessionIdStringWithExceptionWrapping(idString);
        }
        return null;
    }

    public String getSenderIdString() {
        return this.getValue(KEY_SENDER);
    }

    public InstanceNodeSessionId getSender() {
        String idString = this.getSenderIdString();
        if (idString != null) {
            try {
                return NodeIdentifierContextHolder.getDeserializationServiceForCurrentThread().parseInstanceNodeSessionIdString(idString);
            }
            catch (IdentifierException e) {
                throw NodeIdentifierUtils.wrapIdentifierException(e);
            }
        }
        this.log.debug((Object)("Returning 'null' node id for empty 'sender' field; message type=" + this.getMessageType()));
        return null;
    }

    public boolean hasSender() {
        return this.getSenderIdString() != null;
    }

    public String getMessageId() {
        return this.getValue(KEY_MESSAGEID);
    }

    public int getHopCount() {
        try {
            return Integer.parseInt(this.getValue(KEY_HOPCOUNT));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

