/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.common;

import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScriptValidation {
    private static ScriptEngine engine = null;
    private static final Log LOGGER = LogFactory.getLog(ScriptValidation.class);

    private ScriptValidation() {
    }

    public static String validateScript(String script, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes, Object callerInstance) {
        if (engine == null) {
            ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)callerInstance);
            ScriptingService service = (ScriptingService)serviceRegistryAccess.getService(ScriptingService.class);
            engine = service.createScriptEngine(ScriptLanguage.getByName((String)"Jython"));
        }
        return ScriptValidation.validateScript(script, engine, inputsAndConnectionStatus, inputsAndDataTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateScript(String script, ScriptEngine scriptEngine, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes) {
        if (script == null || script.trim().isEmpty()) {
            return "No condition is defined";
        }
        String errorMessage = "";
        ArrayList<String> operatorList = new ArrayList<String>(Arrays.asList(SwitchComponentConstants.OPERATORS));
        operatorList.addAll(Arrays.asList(SwitchComponentConstants.OPERATORS_FOR_VALIDATION));
        Pattern operatorPattern = Pattern.compile(ScriptValidation.createValidationRegex(operatorList));
        Matcher operatorMatcher = operatorPattern.matcher(script);
        DataType inputToForwardDataType = inputsAndDataTypes.get("To_forward");
        while (operatorMatcher.find()) {
            if (operatorMatcher.group(0).equals("To_forward") && inputToForwardDataType != null && !inputToForwardDataType.equals((Object)DataType.Float) && !inputToForwardDataType.equals((Object)DataType.Integer) && !inputToForwardDataType.equals((Object)DataType.Boolean)) {
                errorMessage = ScriptValidation.appendErrorMessage(errorMessage, StringUtils.format((String)"Data type '%s' of input '%s' not supported in script", (Object[])new Object[]{inputToForwardDataType, "To_forward"}));
            }
            if (!(inputsAndConnectionStatus.containsKey(operatorMatcher.group(0)) || operatorList.contains(operatorMatcher.group(0)) || operatorMatcher.group(0).trim().isEmpty() || org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)operatorMatcher.group()))) {
                errorMessage = ScriptValidation.appendErrorMessage(errorMessage, StringUtils.format((String)"'%s' is not defined", (Object[])new Object[]{operatorMatcher.group(0)}));
            }
            if (!inputsAndConnectionStatus.containsKey(operatorMatcher.group(0)) || inputsAndConnectionStatus.get(operatorMatcher.group(0)).booleanValue()) continue;
            errorMessage = ScriptValidation.appendErrorMessage(errorMessage, StringUtils.format((String)"'%s' is not connected", (Object[])new Object[]{operatorMatcher.group(0)}));
        }
        for (Map.Entry<String, DataType> entry : inputsAndDataTypes.entrySet()) {
            switch (entry.getValue()) {
                case Integer: {
                    script = script.replace(entry.getKey(), "11");
                    break;
                }
                case Float: {
                    script = script.replace(entry.getKey(), "11.1");
                    break;
                }
                case Boolean: {
                    script = script.replace(entry.getKey(), "True");
                    break;
                }
            }
        }
        try {
            Map.Entry<String, DataType> entry;
            entry = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
            synchronized (entry) {
                String evalScript = "if " + script + ":\n    returnValue=True\nelse:\n    returnValue=False";
                scriptEngine.eval(evalScript);
            }
        }
        catch (ScriptException e) {
            errorMessage = ScriptValidation.appendErrorMessage(errorMessage, "Syntax error: mismatched input at line number " + e.getLineNumber() + " at column number " + e.getColumnNumber());
        }
        return errorMessage;
    }

    private static String appendErrorMessage(String errorMessage, String errorMessageToAppend) {
        if (!errorMessage.isEmpty()) {
            errorMessage = String.valueOf(errorMessage) + "\n";
        }
        errorMessage = String.valueOf(errorMessage) + errorMessageToAppend;
        return errorMessage;
    }

    private static String createValidationRegex(List<String> operatorList) {
        StringBuilder op = new StringBuilder();
        op.append("(");
        for (String operator : operatorList) {
            if (operator.equals("<") || operator.equals(">")) {
                op.append(String.valueOf(operator) + "(?!=)");
            } else {
                op.append(operator);
            }
            op.append("|");
        }
        op.append("\\b\\w+\\b");
        op.append(")");
        try {
            Pattern.compile(op.toString());
        }
        catch (PatternSyntaxException e) {
            LOGGER.error((Object)"Invalid Regex!", (Throwable)e);
        }
        return op.toString();
    }
}

