/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution;

import de.rcenvironment.components.script.common.ScriptComponentHistoryDataItem;
import de.rcenvironment.components.script.common.registry.ScriptExecutor;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.scripting.WorkflowConsoleForwardingWriter;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DefaultScriptExecutor
implements ScriptExecutor {
    protected static TypedDatumFactory typedDatumFactory;
    protected static ScriptingService scriptingService;
    protected static final String INPUT_STRING = " = \"%s\"\n";
    protected static final String INPUT_NO_STRING = " = %s \n";
    private static final Log LOGGER;
    protected ComponentContext componentContext;
    protected ScriptEngine scriptEngine;
    protected String wrappingScript;
    protected List<File> tempFiles = new LinkedList<File>();
    protected File tempDir;
    protected ScriptComponentHistoryDataItem historyDataItem;
    protected Map<String, Object> stateMap;
    private Writer stdoutWriter;
    private Writer stderrWriter;

    static {
        LOGGER = LogFactory.getLog(DefaultScriptExecutor.class);
    }

    public void reset() {
        this.stateMap = new HashMap<String, Object>();
    }

    public boolean prepareExecutor(ComponentContext compCtx) throws ComponentException {
        this.componentContext = compCtx;
        try {
            this.tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("scriptExecutor");
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create temporary directory needed to temporarely store input files/directories", (Throwable)e);
        }
        return true;
    }

    public abstract void prepareNewRun(ScriptLanguage var1, String var2, ScriptComponentHistoryDataItem var3) throws ComponentException;

    public void prepareOutputForRun() {
        StringWriter out = new StringWriter(1024);
        StringWriter err = new StringWriter(1024);
        this.stdoutWriter = new WorkflowConsoleForwardingWriter((Object)out, this.componentContext.getLog(), ConsoleRow.Type.TOOL_OUT, null);
        this.stderrWriter = new WorkflowConsoleForwardingWriter((Object)err, this.componentContext.getLog(), ConsoleRow.Type.TOOL_ERROR, null);
        this.scriptEngine.getContext().setWriter(this.stdoutWriter);
        this.scriptEngine.getContext().setErrorWriter(this.stderrWriter);
    }

    public abstract void runScript() throws ComponentException;

    public abstract void cancelScript();

    public long getCurrentRunNumber() {
        return this.componentContext.getExecutionCount();
    }

    public abstract boolean postRun() throws ComponentException;

    protected void closeConsoleWriters() throws IOException {
        this.stderrWriter.flush();
        this.stderrWriter.close();
        this.stdoutWriter.flush();
        this.stdoutWriter.close();
    }

    public void deleteTempFiles() {
        try {
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tempDir);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to delete temporary directory (probably because a file were not properly closed in the Python script)", (Throwable)e);
        }
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void setHistoryDataItem(ScriptComponentHistoryDataItem historyDataItem) {
        this.historyDataItem = historyDataItem;
    }

    public void setStateMap(Map<String, Object> stateMap) {
        this.stateMap = stateMap;
    }

    public void setStdoutWriter(Writer stdoutWriter) {
        this.stdoutWriter = stdoutWriter;
    }

    public void setStderrWriter(Writer stderrWriter) {
        this.stderrWriter = stderrWriter;
    }

    public void setWorkingPath(String path) {
    }
}

