/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;

public class ScriptComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    protected static final String FORMAT_VERSION_1 = "1";
    protected static final String CURRENT_FORMAT_VERSION = "1";
    private static final long serialVersionUID = -2017053187345233310L;
    private static final String SCRIPT_FILE_REFERENCE = "s";
    private String scriptFileReference;

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public String getIdentifier() {
        return "de.rcenvironment.script";
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String commonDataString = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(commonDataString);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ((ObjectNode)rootNode).put(SCRIPT_FILE_REFERENCE, this.scriptFileReference);
        return rootNode.toString();
    }

    public void setScriptFileReference(String scriptFileReference) {
        this.scriptFileReference = scriptFileReference;
    }

    public String getScriptFileReference() {
        return this.scriptFileReference;
    }

    public static ScriptComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer) throws IOException {
        ScriptComponentHistoryDataItem historyDataItem = new ScriptComponentHistoryDataItem();
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        ScriptComponentHistoryDataItem.readScriptFileReferenceFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readScriptFileReferenceFromString(String historyData, ScriptComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        if (((ObjectNode)rootNode).has(SCRIPT_FILE_REFERENCE)) {
            historyDataItem.scriptFileReference = ((ObjectNode)rootNode).get(SCRIPT_FILE_REFERENCE).textValue();
        }
    }
}

