/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.properties;

import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.components.excel.common.SimpleExcelService;
import de.rcenvironment.components.excel.gui.properties.Messages;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class MacrosSection
extends ValidatingWorkflowNodePropertySection {
    private Object lock = new Object();
    private Composite macroGroup;
    private CCombo comboMacroPre;
    private CCombo comboMacroRun;
    private CCombo comboMacroPost;
    private Button discoverMacrosButton;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        WorkflowNodePropertySection.LayoutComposite content = new WorkflowNodePropertySection.LayoutComposite(parent);
        content.setLayout((Layout)new GridLayout(1, true));
        Composite macrosChoosingSection = toolkit.createFlatFormComposite((Composite)content);
        this.initMacrosChoosingSection(toolkit, macrosChoosingSection);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.discoverMacros();
    }

    private void initMacrosChoosingSection(TabbedPropertySheetWidgetFactory toolkit, Composite container) {
        GridData layoutData = new GridData(770);
        container.setLayoutData((Object)layoutData);
        container.setLayout((Layout)new FillLayout());
        Section section = toolkit.createSection(container, 320);
        section.setText(Messages.macrosChoosingSectionName);
        Composite client = toolkit.createComposite((Composite)section);
        layoutData = new GridData(768);
        client.setLayoutData((Object)layoutData);
        client.setLayout((Layout)new GridLayout(1, false));
        CLabel lblDescription = toolkit.createCLabel(client, Messages.macrosSectionDescription);
        this.macroGroup = toolkit.createComposite(client);
        this.macroGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        toolkit.createCLabel(this.macroGroup, Messages.preMacro);
        this.comboMacroPre = toolkit.createCCombo(this.macroGroup);
        this.comboMacroPre.setEditable(true);
        this.comboMacroPre.setData("property.control", (Object)"preMacro");
        toolkit.createCLabel(this.macroGroup, Messages.runMacro);
        this.comboMacroRun = toolkit.createCCombo(this.macroGroup);
        this.comboMacroRun.setEditable(true);
        this.comboMacroRun.setData("property.control", (Object)"runMacro");
        toolkit.createCLabel(this.macroGroup, Messages.postMacro);
        this.comboMacroPost = toolkit.createCCombo(this.macroGroup);
        this.comboMacroPost.setEditable(true);
        this.comboMacroPost.setData("property.control", (Object)"postMacro");
        toolkit.createCLabel(this.macroGroup, "");
        this.discoverMacrosButton = toolkit.createButton(this.macroGroup, Messages.macrosDiscoverButtonLabel, 8);
        this.discoverMacrosButton.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.REFRESH_16));
        lblDescription.setLayoutData((Object)gridData);
        this.comboMacroPre.setLayoutData((Object)gridData);
        this.comboMacroRun.setLayoutData((Object)gridData);
        this.comboMacroPost.setLayoutData((Object)gridData);
        section.setClient((Control)client);
    }

    private void discoverMacros() {
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TaskDescription(value="Browses the given excel file for macros")
            public void run() {
                SimpleExcelService excelService = new SimpleExcelService();
                File xlFile = ExcelUtils.getAbsoluteFile((String)MacrosSection.this.getProperty("xlFilename"));
                if (xlFile != null) {
                    String[] macrosAvailable;
                    Object object = MacrosSection.this.lock;
                    synchronized (object) {
                        macrosAvailable = excelService.getMacros(xlFile);
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        @TaskDescription(value="Sets the items of the macro combo boxes")
                        public void run() {
                            Object object = MacrosSection.this.lock;
                            synchronized (object) {
                                if (!(MacrosSection.this.comboMacroPre.isDisposed() || MacrosSection.this.comboMacroRun.isDisposed() || MacrosSection.this.comboMacroPost.isDisposed())) {
                                    MacrosSection.this.comboMacroPre.setItems(macrosAvailable);
                                    MacrosSection.this.comboMacroRun.setItems(macrosAvailable);
                                    MacrosSection.this.comboMacroPost.setItems(macrosAvailable);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    protected void refreshBeforeValidation() {
        this.macroGroup.pack(true);
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new MacrosController();
    }

    private final class MacrosController
    extends WorkflowNodePropertySection.DefaultController {
        private MacrosController() {
            super((WorkflowNodePropertySection)MacrosSection.this);
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
            super.widgetSelected(event, source);
            if (source == MacrosSection.this.discoverMacrosButton) {
                MacrosSection.this.discoverMacros();
            }
        }
    }
}

