/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.properties;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.activeX.ActiveXInvocationProxy;
import com.jacob.com.Dispatch;
import com.jacob.com.DispatchProxy;
import com.jacob.com.Variant;
import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ExcelServiceGUIEvents;
import de.rcenvironment.components.excel.gui.properties.VariablesEditDialog;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CellSelectionDialog
extends Dialog {
    private static final int MAX_HEIGHT = 100;
    private static final int MAX_WIDTH = 430;
    protected Shell shlExcelAddress;
    private Text textCellAddress;
    private VariablesEditDialog varDialog;
    private String initAddress;
    private ExcelServiceGUIEvents excelEvents;
    private DispatchProxy dispatchProxy;

    public CellSelectionDialog(Shell parent, int style, VariablesEditDialog dialog) {
        super(parent, style);
        this.setText("SWT Dialog");
        this.varDialog = dialog;
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.excelEvents = (ExcelServiceGUIEvents)serviceRegistryAccess.getService(ExcelServiceGUIEvents.class);
    }

    public void open(String initialAddress) {
        this.createContents();
        this.shlExcelAddress.open();
        this.shlExcelAddress.layout();
        this.initAddress = initialAddress;
        this.setAddress(this.initAddress);
        ActiveXComponent objExcel = this.excelEvents.openExcelApplicationRegisterListener(this.varDialog.getFile(), this.initAddress, (ActiveXInvocationProxy)new ExcelApplicationEventsProxy());
        this.dispatchProxy = new DispatchProxy((Dispatch)objExcel);
    }

    public void close() {
        ActiveXComponent objExcel = new ActiveXComponent(this.dispatchProxy.toDispatch());
        if (objExcel != null) {
            this.excelEvents.quitExcel(objExcel, false);
        }
        this.getParent().dispose();
    }

    private void createContents() {
        this.shlExcelAddress = new Shell(this.getParent(), this.getStyle());
        this.shlExcelAddress.setSize(430, 100);
        this.shlExcelAddress.setText("Excel Address Selection Dialog");
        this.shlExcelAddress.setLayout((Layout)new FormLayout());
        this.textCellAddress = new Text((Composite)this.shlExcelAddress, 2048);
        FormData fdtextCellAddress = new FormData();
        fdtextCellAddress.top = new FormAttachment(0, 10);
        fdtextCellAddress.left = new FormAttachment(0);
        fdtextCellAddress.right = new FormAttachment(100);
        this.textCellAddress.setLayoutData((Object)fdtextCellAddress);
        final Button btnOk = new Button((Composite)this.shlExcelAddress, 0);
        FormData fdbtnOk = new FormData();
        fdbtnOk.top = new FormAttachment((Control)this.textCellAddress, 6);
        btnOk.setLayoutData((Object)fdbtnOk);
        btnOk.setText("OK");
        Button btnCancel = new Button((Composite)this.shlExcelAddress, 0);
        fdbtnOk.right = new FormAttachment((Control)btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        FormData fdbtnCancel = new FormData();
        fdbtnCancel.top = new FormAttachment((Control)this.textCellAddress, 6);
        fdbtnCancel.right = new FormAttachment((Control)this.textCellAddress, 0, 131072);
        btnCancel.setLayoutData((Object)fdbtnCancel);
        btnCancel.setText("Cancel");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget != btnOk) {
                    CellSelectionDialog.this.setAddress(CellSelectionDialog.this.initAddress);
                }
                CellSelectionDialog.this.varDialog.notifyAboutSelection();
            }
        };
        btnOk.addListener(13, listener);
        btnCancel.addListener(13, listener);
    }

    public void setAddress(String address) {
        this.textCellAddress.setText(address);
    }

    public String getAddress() {
        return this.textCellAddress.getText();
    }

    class ExcelApplicationEventsProxy
    extends ActiveXInvocationProxy {
        ExcelApplicationEventsProxy() {
        }

        public Variant invoke(String methodName, Variant[] targetParameter) {
            if (methodName.equalsIgnoreCase("SheetSelectionChange")) {
                this.sheetSelectionChange(targetParameter);
            }
            return null;
        }

        private void sheetSelectionChange(Variant[] arguments) {
            if (arguments.length == 2) {
                Dispatch range = arguments[0].getDispatch();
                String rangeAddress = Dispatch.get((Dispatch)range, (String)"Address").getString();
                Dispatch worksheet = Dispatch.get((Dispatch)range, (String)"Worksheet").toDispatch();
                String worksheetName = Dispatch.get((Dispatch)worksheet, (String)"Name").getString();
                ExcelAddress addr = new ExcelAddress(CellSelectionDialog.this.varDialog.getFile(), String.valueOf(worksheetName) + "!" + rangeAddress);
                if (addr != null) {
                    CellSelectionDialog.this.setAddress(addr.getFullAddress());
                }
            } else {
                throw new RuntimeException("Return target-arguments of 'SheetSelectionChange(Sh, Target)' does not have length of 2.");
            }
        }
    }
}

