/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;

public class DOEComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    protected static final String FORMAT_VERSION_1 = "1";
    protected static final String CURRENT_FORMAT_VERSION = "1";
    private static final long serialVersionUID = -2017053187345233310L;
    private static final String TABLE_FILE_REFERENCE = "TableFile";
    private static final String RESULT_FILE_REFERENCE = "ResultFile";
    private String tableFileReference;
    private String resultFileReference;

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public String getIdentifier() {
        return "de.rcenvironment.doe.v2";
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String commonDataString = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(commonDataString);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ((ObjectNode)rootNode).put(TABLE_FILE_REFERENCE, this.tableFileReference);
        ((ObjectNode)rootNode).put(RESULT_FILE_REFERENCE, this.resultFileReference);
        return rootNode.toString();
    }

    public static DOEComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer) throws IOException {
        DOEComponentHistoryDataItem historyDataItem = new DOEComponentHistoryDataItem();
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        historyDataItem.tableFileReference = DOEComponentHistoryDataItem.readFileReferenceFromString(TABLE_FILE_REFERENCE, historyData, historyDataItem);
        historyDataItem.resultFileReference = DOEComponentHistoryDataItem.readFileReferenceFromString(RESULT_FILE_REFERENCE, historyData, historyDataItem);
        return historyDataItem;
    }

    private static String readFileReferenceFromString(String referenceName, String historyData, DOEComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        if (((ObjectNode)rootNode).has(referenceName)) {
            return ((ObjectNode)rootNode).get(referenceName).textValue();
        }
        return null;
    }

    public void setResultFileReference(String fileReference) {
        this.resultFileReference = fileReference;
    }

    public String getResultFileReference() {
        return this.resultFileReference;
    }

    public void setTableFileReference(String inputFileReference) {
        this.tableFileReference = inputFileReference;
    }

    public String getTableFileReference() {
        return this.tableFileReference;
    }
}

