/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.execution.validator;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.database.common.DatabaseComponentConstants;
import de.rcenvironment.components.database.common.DatabaseStatement;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DatabaseComponentValidator
extends AbstractComponentValidator {
    private static final String THE_STATEMENT = "The statement";
    private static final String APOSTROPHE_PERIOD = "'.";
    private static final String APOSTROPHE_BLANK = "' ";
    private static final String BLANK_APOSTROPHE = " '";
    private static final String SEMICOLON = ";";

    public String getIdentifier() {
        return "de.rcenvironment.database";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        this.checkIfDatabaseDefinitionIsNotEmpty(componentDescription, messages);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        List<Object> models = new ArrayList<DatabaseStatement>();
        try {
            String modelsString = this.getProperty(componentDescription, "databaseStatements");
            if (modelsString != null) {
                models = (List)mapper.readValue(modelsString, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, DatabaseStatement.class));
            }
        }
        catch (JsonGenerationException | JsonMappingException throwable) {
            ComponentValidationMessage parsingError = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseStatements", "Failed to parse database statements.", "Failed to parse database statements.");
            messages.add(parsingError);
        }
        catch (IOException iOException) {
            ComponentValidationMessage readingFromFilesystemError = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseStatements", "Failed to read database statements from filesystem.", "Failed to read database statements from filesystem.");
            messages.add(readingFromFilesystemError);
        }
        this.checkIfAllStatementsAreNamed(messages, models);
        this.checkIfNoStatementIsEmpty(messages, models);
        this.checkIfStatementTypeIsValid(messages, models);
        this.checkIfSmallTableInputJustInInsert(componentDescription, messages, models);
        this.checkIfJustOneStatementIsPresent(messages, models);
        this.checkIfOutputIsSelectedWhenChecked(messages, models);
        this.checkIfSelectStatementHasOutput(messages, models);
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private void checkIfAllStatementsAreNamed(List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            if (!statement.getName().isEmpty()) continue;
            String warningMessage = "The component has as least one statement with an empty name.";
            ComponentValidationMessage statementNameEmpty = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "databaseStatements", warningMessage, warningMessage);
            messages.add(statementNameEmpty);
            break;
        }
    }

    private void checkIfNoStatementIsEmpty(List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            if (!statement.getStatement().isEmpty()) continue;
            String warningMessage = "The statement '" + statement.getName() + "' is empty.";
            ComponentValidationMessage statementEmpty = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseStatements", warningMessage, warningMessage);
            messages.add(statementEmpty);
        }
    }

    private void checkIfStatementTypeIsValid(List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            String statementPrefix = statement.getStatement().toLowerCase().split(" ")[0];
            if (Arrays.asList(DatabaseComponentConstants.STATEMENT_PREFIX_WHITELIST_GENERAL).contains(statementPrefix)) continue;
            String warningMessage = "The statement '" + statement.getName() + "' could not be recognized. " + "Does it not start with 'Select', 'Insert', 'Delete' or 'Update'? " + "See help for further information.";
            ComponentValidationMessage notRecognizedStatementType = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseStatements", warningMessage, warningMessage);
            messages.add(notRecognizedStatementType);
        }
    }

    private void checkIfSmallTableInputJustInInsert(ComponentDescription componentDescription, List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            String statementPrefix = statement.getStatement().toLowerCase().split(" ")[0];
            if (Arrays.asList(DatabaseComponentConstants.STATEMENT_PREFIX_WHITELIST_SMALLTABLE).contains(statementPrefix)) continue;
            for (String smalltablePlacerholder : this.getSmalltableInputPlaceholders(componentDescription)) {
                if (!statement.getStatement().contains(smalltablePlacerholder)) continue;
                String warningMessage = "The statement' " + statement.getName() + "' contains an input of type small table but is not an 'insert' statement. The statement is: '" + statement.getStatement() + APOSTROPHE_PERIOD;
                ComponentValidationMessage smalltableInputNotAllowedExceptInsert = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseStatements", warningMessage, warningMessage);
                messages.add(smalltableInputNotAllowedExceptInsert);
            }
        }
    }

    private List<String> getSmalltableInputPlaceholders(ComponentDescription componentDescription) {
        ArrayList<String> smalltableInputPlaceholders = new ArrayList<String>();
        for (EndpointDescription endpointDescription : this.getInputs(componentDescription, DataType.SmallTable)) {
            String placeholder = StringUtils.format((String)"${in:%s}", (Object[])new Object[]{endpointDescription.getName()});
            smalltableInputPlaceholders.add(placeholder);
        }
        return smalltableInputPlaceholders;
    }

    private void checkIfJustOneStatementIsPresent(List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            if (!statement.getStatement().contains(SEMICOLON)) continue;
            String statementAfterFirstSemicolon = statement.getStatement().substring(statement.getStatement().indexOf(SEMICOLON));
            for (String prefix : Arrays.asList(DatabaseComponentConstants.STATEMENT_PREFIX_WHITELIST_GENERAL)) {
                if (!statementAfterFirstSemicolon.toLowerCase().contains(prefix)) continue;
                String warningMessage = "The statement' " + statement.getName() + "' possibly two statements were entered in the statement textfield. " + "It is '" + statement.getStatement() + APOSTROPHE_PERIOD;
                ComponentValidationMessage possiblyTwoStatements = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "databaseStatements", warningMessage, warningMessage);
                messages.add(possiblyTwoStatements);
            }
        }
    }

    private void checkIfSelectStatementHasOutput(List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            if (!statement.getStatement().trim().toLowerCase().startsWith("select") || statement.isWillWriteToOutput() && !statement.getOutputToWriteTo().isEmpty()) continue;
            String warningMessage = "The statement' " + statement.getName() + "' is a 'SELECT' statement but has not output defined to write to.";
            ComponentValidationMessage selectStatementHasNoOutput = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "databaseStatements", warningMessage, warningMessage);
            messages.add(selectStatementHasNoOutput);
        }
    }

    private void checkIfOutputIsSelectedWhenChecked(List<ComponentValidationMessage> messages, List<DatabaseStatement> models) {
        for (DatabaseStatement statement : models) {
            if (!statement.isWillWriteToOutput() || !statement.getOutputToWriteTo().isEmpty()) continue;
            String warningMessage = "The statement' " + statement.getName() + "' is configured to write to an output but no output is selected yet.";
            ComponentValidationMessage outputCheckedButNoDefined = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "databaseStatements", warningMessage, warningMessage);
            messages.add(outputCheckedButNoDefined);
        }
    }

    private void checkIfDatabaseDefinitionIsNotEmpty(ComponentDescription componentDescription, List<ComponentValidationMessage> messages) {
        if (this.getProperty(componentDescription, "databaseHost") == null) {
            messages.add(this.getEmptyHostWarning());
        } else if (this.getProperty(componentDescription, "databaseHost").isEmpty()) {
            messages.add(this.getEmptyHostWarning());
        }
        if (this.getProperty(componentDescription, "databasePort") == null) {
            messages.add(this.getEmptyPortWarning());
        } else if (this.getProperty(componentDescription, "databasePort").isEmpty()) {
            messages.add(this.getEmptyPortWarning());
        }
        if (this.getProperty(componentDescription, "databaseScheme") == null) {
            messages.add(this.getEmptySchemeWarning());
        } else if (this.getProperty(componentDescription, "databaseScheme").isEmpty()) {
            messages.add(this.getEmptySchemeWarning());
        }
    }

    private ComponentValidationMessage getEmptySchemeWarning() {
        String warningMessage = "Database Scheme needs to be defined - see Database tab";
        ComponentValidationMessage databaseSchemeNull = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseScheme", warningMessage, warningMessage);
        return databaseSchemeNull;
    }

    private ComponentValidationMessage getEmptyPortWarning() {
        String warningMessage = "Database Port needs to be defined - see Database tab";
        ComponentValidationMessage databasePortNull = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databasePort", warningMessage, warningMessage);
        return databasePortNull;
    }

    private ComponentValidationMessage getEmptyHostWarning() {
        String warningMessage = "Database Host needs to be defined - see Database tab";
        ComponentValidationMessage databaseHostNull = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "databaseHost", warningMessage, warningMessage);
        return databaseHostNull;
    }
}

