/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.core.internal;

import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.api.Toolkit;
import de.rcenvironment.toolkit.core.internal.ToolkitInstanceTracker;
import java.util.List;
import org.apache.commons.logging.LogFactory;

final class ToolkitImpl
implements Toolkit {
    private final ImmutableServiceRegistry serviceRegistry;
    private final List<Runnable> shutdownHooks;
    private boolean shutdownTriggered = false;

    ToolkitImpl(ImmutableServiceRegistry serviceRegistry, List<Runnable> shutdownHooks) {
        this.serviceRegistry = serviceRegistry;
        this.shutdownHooks = shutdownHooks;
    }

    @Override
    public ImmutableServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return this.serviceRegistry.getService(serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ToolkitImpl toolkitImpl = this;
        synchronized (toolkitImpl) {
            if (this.shutdownTriggered) {
                throw new IllegalStateException("Received more than one shutdown() call");
            }
            this.shutdownTriggered = true;
        }
        for (Runnable shutdownHook : this.shutdownHooks) {
            try {
                shutdownHook.run();
            }
            catch (RuntimeException e) {
                LogFactory.getLog(this.getClass()).error((Object)"Error executing shutdown hook", (Throwable)e);
            }
        }
        ToolkitInstanceTracker.getInstance().markDisposed(this);
    }
}

