/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.textstream.receivers;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.util.LinkedList;
import java.util.List;

public class MultiTextOutputReceiver
implements TextOutputReceiver {
    private List<TextOutputReceiver> forwardTargets = new LinkedList<TextOutputReceiver>();

    public MultiTextOutputReceiver() {
    }

    public MultiTextOutputReceiver(TextOutputReceiver firstTextOutputReceiver, TextOutputReceiver secondTextOutputReceiver) {
        this();
        this.forwardTargets.add(firstTextOutputReceiver);
        this.forwardTargets.add(secondTextOutputReceiver);
    }

    public void addTextOutputReceiver(TextOutputReceiver newTextOutputReceiver) {
        if (!this.forwardTargets.contains(newTextOutputReceiver)) {
            this.forwardTargets.add(newTextOutputReceiver);
        }
    }

    public void removeTextOutputReceiver(TextOutputReceiver textOutputReceiverToRemove) {
        this.forwardTargets.remove(textOutputReceiverToRemove);
    }

    @Override
    public void onStart() {
        for (TextOutputReceiver forwardTarget : this.forwardTargets) {
            forwardTarget.onStart();
        }
    }

    @Override
    public void addOutput(String line) {
        for (TextOutputReceiver forwardTarget : this.forwardTargets) {
            forwardTarget.addOutput(line);
        }
    }

    @Override
    public void onFinished() {
        for (TextOutputReceiver forwardTarget : this.forwardTargets) {
            forwardTarget.onFinished();
        }
    }

    @Override
    public void onFatalError(Exception e) {
        for (TextOutputReceiver forwardTarget : this.forwardTargets) {
            forwardTarget.onFatalError(e);
        }
    }
}

