/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.channel.legacy;

import de.rcenvironment.core.utils.common.variables.legacy.TypedValue;
import de.rcenvironment.core.utils.common.variables.legacy.VariableType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class VariantArray
implements Serializable {
    private static final String EXCEPTION_WRONGDIMENSIONS = "Wrong number of dimensions provided in VariantArray";
    private static final long serialVersionUID = -974534708839659363L;
    private final String name;
    private final int[] dimensions;
    private final int[] multipliers;
    private TypedValue[] array;
    private boolean compressed = false;

    private VariantArray(String theName, TypedValue[] values, int ... dimensionSizes) {
        if (dimensionSizes == null || dimensionSizes.length <= 0) {
            throw new IllegalArgumentException(EXCEPTION_WRONGDIMENSIONS);
        }
        this.name = theName;
        this.dimensions = dimensionSizes;
        this.multipliers = VariantArray.calculateMultipliers(this.dimensions);
        this.array = values;
    }

    public VariantArray(String theName, int ... dimensionSizes) {
        if (dimensionSizes == null || dimensionSizes.length <= 0) {
            throw new IllegalArgumentException(EXCEPTION_WRONGDIMENSIONS);
        }
        this.name = theName;
        this.dimensions = dimensionSizes;
        this.multipliers = VariantArray.calculateMultipliers(this.dimensions);
        this.array = new TypedValue[this.getSize()];
        this.setDefaultType(VariableType.Empty);
    }

    public VariantArray(String theName, VariantArray from) {
        if (from == null) {
            throw new IllegalArgumentException("Cannot use copy constructor with null argument");
        }
        this.name = theName;
        this.dimensions = new int[from.dimensions.length];
        this.multipliers = new int[from.multipliers.length];
        this.array = new TypedValue[from.array.length];
        System.arraycopy(from.dimensions, 0, this.dimensions, 0, from.dimensions.length);
        System.arraycopy(from.multipliers, 0, this.multipliers, 0, from.multipliers.length);
        System.arraycopy(from.array, 0, this.array, 0, from.array.length);
    }

    public VariantArray setValue(TypedValue value, int ... index) {
        this.array[this.index((int[])index)] = new TypedValue(value);
        return this;
    }

    public static VariantArray addValuesToVariantArray(VariantArray main, VariantArray arrayToAdd) {
        if (main.dimensions.length - 1 != arrayToAdd.dimensions.length) {
            throw new IllegalArgumentException(EXCEPTION_WRONGDIMENSIONS);
        }
        int counter = 0;
        int[] nArray = arrayToAdd.dimensions;
        int n = arrayToAdd.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (main.dimensions[counter + 1] != i) {
                throw new IllegalArgumentException("Wrong structure of dimensions provided in VariantArray");
            }
            ++counter;
            ++n2;
        }
        TypedValue[] newArray = new TypedValue[main.array.length + arrayToAdd.getSize()];
        System.arraycopy(main.array, 0, newArray, 0, main.array.length);
        System.arraycopy(arrayToAdd.array, 0, newArray, main.array.length, arrayToAdd.array.length);
        int[] newDimensions = main.dimensions;
        newDimensions[0] = newDimensions[0] + 1;
        return new VariantArray(main.name, newArray, newDimensions);
    }

    public VariantArray setValue(Serializable value, int ... index) {
        this.array[this.index((int[])index)] = new TypedValue(value);
        return this;
    }

    public TypedValue getValue(int ... index) {
        return this.array[this.index(index)];
    }

    public VariantArray setDefaultValue(Serializable value) {
        int i = 0;
        while (i < this.array.length) {
            this.array[i] = new TypedValue(value);
            ++i;
        }
        return this;
    }

    public VariantArray setDefaultType(VariableType type) {
        if (type == VariableType.Empty) {
            int i = 0;
            while (i < this.array.length) {
                this.array[i] = TypedValue.EMPTY;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.array.length) {
                this.array[i] = new TypedValue(type);
                ++i;
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getSize() {
        if (this.compressed) {
            return this.array.length;
        }
        return this.multipliers[0];
    }

    public boolean isMatrixComplete() {
        TypedValue[] typedValueArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            TypedValue value = typedValueArray[n2];
            if (value == null || value == TypedValue.EMPTY || value.getType() == VariableType.Empty) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int[] getIndex(int index) {
        int max = this.dimensions.length - 1;
        int[] position = new int[max + 1];
        position[max] = index % this.dimensions[max];
        int i = max - 1;
        while (i >= 0) {
            position[i] = index % this.multipliers[i] / this.multipliers[i + 1];
            --i;
        }
        return position;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariantArray ");
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append("[");
        int d = 0;
        while (d < this.dimensions.length - 1) {
            sb.append(Integer.toString(this.dimensions[d]));
            sb.append(",");
            ++d;
        }
        sb.append(Integer.toString(this.dimensions[this.dimensions.length - 1]));
        sb.append("]");
        return sb.toString();
    }

    protected static int[] calculateMultipliers(int[] dimensions) {
        int[] ret = new int[dimensions.length];
        int product = 1;
        int d = dimensions.length - 1;
        while (d >= 0) {
            ret[d] = product *= dimensions[d];
            --d;
        }
        return ret;
    }

    protected int index(int[] indexes) {
        int ret = 0;
        int i = 0;
        while (i < indexes.length - 1) {
            ret += this.multipliers[i + 1] * indexes[i];
            ++i;
        }
        return ret += indexes[indexes.length - 1];
    }

    public VariantArray pruneDimension(int dimension, boolean lowest, boolean highest) {
        int reduce;
        int[] tmp;
        int cell;
        int count;
        int i;
        if (!lowest && !highest) {
            return this;
        }
        int toPruneLowest = 0;
        int toPruneHighest = 0;
        int hypersliceElements = this.multipliers[0] / this.dimensions[dimension];
        if (lowest) {
            i = 0;
            while (i < this.dimensions[dimension]) {
                count = 0;
                cell = 0;
                while (cell < this.multipliers[0]) {
                    tmp = this.getIndex(cell);
                    if (this.array[cell].getType() == VariableType.Empty && tmp[dimension] == i) {
                        ++count;
                    }
                    ++cell;
                }
                if (count != hypersliceElements) break;
                ++toPruneLowest;
                ++i;
            }
        }
        if (highest && toPruneLowest < this.dimensions[dimension]) {
            i = this.dimensions[dimension] - 1;
            while (i >= 0) {
                count = 0;
                cell = 0;
                while (cell < this.multipliers[0]) {
                    tmp = this.getIndex(cell);
                    if (this.array[cell].getType() == VariableType.Empty && tmp[dimension] == i) {
                        ++count;
                    }
                    ++cell;
                }
                if (count != hypersliceElements) break;
                ++toPruneHighest;
                --i;
            }
        }
        if (toPruneLowest + toPruneHighest >= this.dimensions[dimension]) {
            toPruneLowest = 0;
            toPruneHighest = this.dimensions[dimension];
        }
        if ((reduce = toPruneLowest + toPruneHighest) == 0) {
            return new VariantArray(this.name, this);
        }
        int[] newDimensions = new int[this.dimensions.length];
        System.arraycopy(this.dimensions, 0, newDimensions, 0, this.dimensions.length);
        int n = dimension;
        newDimensions[n] = newDimensions[n] - reduce;
        toPruneHighest = this.dimensions[dimension] - toPruneHighest;
        VariantArray newArray = new VariantArray(this.name, newDimensions);
        int newCell = 0;
        int cell2 = 0;
        while (cell2 < this.multipliers[0]) {
            int[] tmp2 = this.getIndex(cell2);
            int i2 = tmp2[dimension];
            if (i2 >= toPruneLowest && i2 < toPruneHighest) {
                newArray.array[newCell++] = this.array[cell2];
            }
            ++cell2;
        }
        return newArray;
    }

    public VariantArray pruneDimensionZero() {
        List<VariantArray> list = this.unitizeHighestDimension();
        int i = list.size() - 1;
        while (i >= 0) {
            VariantArray entry = list.get(i);
            if (!entry.isEmpty()) break;
            list.remove(entry);
            --i;
        }
        int[] finalDimensions = new int[1 + list.get(0).getDimensions().length];
        System.arraycopy(list.get(0).getDimensions(), 0, finalDimensions, 1, finalDimensions.length - 1);
        VariantArray va = new VariantArray(list.get(0).getName(), finalDimensions);
        for (VariantArray slice : list) {
            va = VariantArray.addValuesToVariantArray(va, slice);
        }
        return va;
    }

    public boolean isEmpty() {
        boolean isEmptyContent = false;
        if (this.array.length == 0) {
            isEmptyContent = true;
        }
        TypedValue[] typedValueArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            TypedValue val = typedValueArray[n2];
            if (val.getStringValue() != null && !val.getStringValue().equals("") && val.getType() != VariableType.Empty) {
                isEmptyContent = false;
                break;
            }
            isEmptyContent = true;
            ++n2;
        }
        return isEmptyContent;
    }

    public VariantArray compress() {
        ArrayList<TypedValue> list = new ArrayList<TypedValue>();
        TypedValue last = null;
        int count = 0;
        TypedValue[] typedValueArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            TypedValue tv = typedValueArray[n2];
            if (last == null) {
                last = tv;
                count = 1;
            } else if (last.getType() == VariableType.Empty) {
                if (tv.getType() == VariableType.Empty) {
                    ++count;
                } else {
                    VariantArray.writeOutRle(count, last, list);
                    count = 1;
                    last = tv;
                }
            } else if (tv.getType() == VariableType.Empty) {
                VariantArray.writeOutRle(count, last, list);
                count = 1;
                last = tv;
            } else if (tv.getType() == last.getType() && tv.getValue().equals(last.getValue())) {
                ++count;
            } else {
                VariantArray.writeOutRle(count, last, list);
                count = 1;
                last = tv;
            }
            ++n2;
        }
        VariantArray.writeOutRle(count, last, list);
        this.compressed = true;
        this.array = list.toArray(new TypedValue[0]);
        return this;
    }

    private static void writeOutRle(int count, TypedValue value, List<TypedValue> list) {
        if (count > 1) {
            list.add(new TypedValue(VariableType.RLE, Integer.toString(count)));
        }
        list.add(value);
    }

    public VariantArray uncompress() {
        if (!this.compressed) {
            return this;
        }
        TypedValue[] old = this.array;
        this.array = new TypedValue[this.multipliers[0]];
        int source = 0;
        int target = 0;
        while (source < old.length) {
            TypedValue tv;
            if ((tv = old[source++]).getType() == VariableType.RLE) {
                TypedValue rleValue = old[source++];
                int count = Integer.valueOf((String)((Object)tv.getValue()));
                int c = 0;
                while (c < count) {
                    this.array[target++] = rleValue.getType() == VariableType.Empty ? TypedValue.EMPTY : new TypedValue(rleValue);
                    ++c;
                }
                continue;
            }
            this.array[target++] = tv;
        }
        this.compressed = false;
        return this;
    }

    protected TypedValue[] getInternalArray() {
        return this.array;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public List<VariantArray> unitizeHighestDimension() {
        ArrayList<VariantArray> list = new ArrayList<VariantArray>();
        if (this.dimensions.length == 1) {
            int sizeDimension = this.dimensions[0];
            int dimensionrunner = 0;
            while (dimensionrunner < sizeDimension) {
                TypedValue[] newValueArray = new TypedValue[]{this.getValue(dimensionrunner++)};
                VariantArray va = new VariantArray(this.name, newValueArray, 1);
                list.add(va);
            }
        } else {
            int sizeOfHighestDimension = this.dimensions[0];
            int pointerToEmptyEntry = 0;
            int globalrunner = 1;
            while (globalrunner <= sizeOfHighestDimension) {
                TypedValue[] newValueArray = new TypedValue[this.getSize() / sizeOfHighestDimension];
                int index = 0;
                while (index < newValueArray.length) {
                    newValueArray[index] = this.getValue(this.getIndex(pointerToEmptyEntry));
                    ++pointerToEmptyEntry;
                    ++index;
                }
                int[] d = VariantArray.cutFirstEntry(this.dimensions);
                VariantArray va = new VariantArray(this.name, newValueArray, d);
                list.add(va);
                ++globalrunner;
            }
        }
        return list;
    }

    private static int[] cutFirstEntry(int[] array) {
        int[] result = new int[array.length - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i + 1];
            ++i;
        }
        if (result.length == 1) {
            int value = result[0];
            result = new int[2];
            result[1] = 1;
            result[0] = value;
        }
        return result;
    }
}

