/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import de.rcenvironment.core.start.validators.internal.OriginalProfileDirectoryAccessibleValidator;
import java.util.ArrayList;
import java.util.List;

public class ProfileDirectoryVersionValidator
implements InstanceValidator {
    private static final String PROFILE_VALIDATION_FAILED = "Profile directory version";
    private static ConfigurationService configService;

    public InstanceValidationResult validate() {
        if (!configService.hasIntendedProfileDirectoryValidVersion()) {
            String errorText1 = "The required version of the profile directory is " + Profile.PROFILE_VERSION_NUMBER + " but the profile directory's current version is newer. Most likely reason: It was used with" + " a newer version of RCE before.";
            String errorText2 = "As downgrade is not supported, the configured profile directory cannot be used with this RCE version. Use a newer version of RCE or choose another profile directory. (See the user guide for more information about the profile directory.)";
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)PROFILE_VALIDATION_FAILED, (String)(String.valueOf(errorText1) + " " + errorText2), (String)(String.valueOf(errorText1) + "\n\n" + errorText2));
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Profile directory has valid version.");
    }

    protected void bindConfigurationService(ConfigurationService configIn) {
        configService = configIn;
    }

    public List<Class<? extends InstanceValidator>> getNecessaryPredecessors() {
        ArrayList<Class<? extends InstanceValidator>> predecessors = new ArrayList<Class<? extends InstanceValidator>>();
        predecessors.add(OriginalProfileDirectoryAccessibleValidator.class);
        return predecessors;
    }
}

