/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.common.validation.internal;

import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationService;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceValidationServiceImpl
implements InstanceValidationService {
    protected Map<Class<? extends InstanceValidator>, InstanceValidationResult> executedValidators = new HashMap<Class<? extends InstanceValidator>, InstanceValidationResult>();
    private final Log log = LogFactory.getLog(InstanceValidationServiceImpl.class);
    private List<InstanceValidator> validators = new LinkedList<InstanceValidator>();

    protected void bindInstanceValidator(InstanceValidator newValidation) {
        this.validators.add(newValidation);
    }

    protected boolean necessaryValidatorsExecuted(InstanceValidator validator) {
        List<Class<? extends InstanceValidator>> necessaryPredecessors = validator.getNecessaryPredecessors();
        if (necessaryPredecessors == null) {
            return true;
        }
        for (Class<? extends InstanceValidator> necessaryPredecessor : necessaryPredecessors) {
            if (!this.executedValidators.containsKey(necessaryPredecessor)) {
                return false;
            }
            InstanceValidationResult instanceValidationResult = this.executedValidators.get(necessaryPredecessor);
            if (InstanceValidationResult.InstanceValidationResultType.PASSED.equals((Object)instanceValidationResult.getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<InstanceValidationResult.InstanceValidationResultType, List<InstanceValidationResult>> validateInstance() {
        int pendingValidatorsBeforeIteration;
        HashMap<InstanceValidationResult.InstanceValidationResultType, List<InstanceValidationResult>> results = new HashMap<InstanceValidationResult.InstanceValidationResultType, List<InstanceValidationResult>>();
        results.put(InstanceValidationResult.InstanceValidationResultType.PASSED, new ArrayList());
        results.put(InstanceValidationResult.InstanceValidationResultType.FAILED_PROCEEDING_ALLOWED, new ArrayList());
        results.put(InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED, new ArrayList());
        LinkedList<InstanceValidator> pendingValidators = new LinkedList<InstanceValidator>(this.validators);
        do {
            pendingValidatorsBeforeIteration = pendingValidators.size();
            LinkedList<InstanceValidator> currentValidators = new LinkedList<InstanceValidator>(pendingValidators);
            for (InstanceValidator validator : currentValidators) {
                InstanceValidationResult result;
                if (!this.necessaryValidatorsExecuted(validator)) continue;
                try {
                    result = validator.validate();
                }
                catch (RuntimeException e) {
                    this.log.error((Object)StringUtils.format((String)"Unexpected exception from instance validator '%s'", (Object[])new Object[]{validator.getClass().getName()}), (Throwable)e);
                    result = InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown("Instance validator", "An unexpected excetion occurred during instance validation. See log for more details.");
                }
                ((List)results.get((Object)result.getType())).add(result);
                this.executedValidators.put(validator.getClass(), result);
                pendingValidators.remove(validator);
            }
        } while (!pendingValidators.isEmpty() && pendingValidators.size() < pendingValidatorsBeforeIteration);
        if (!pendingValidators.isEmpty()) {
            this.log.error((Object)StringUtils.format((String)"%d instance validator have not been executed, as there have missing predecessors: ", (Object[])new Object[]{pendingValidators.size()}));
            for (InstanceValidator validator : pendingValidators) {
                this.log.error((Object)StringUtils.format((String)"%s has not been executed.", (Object[])new Object[]{validator.getClass().getName()}));
            }
            InstanceValidationResult result = InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown("Instance validator", "Not all necessary validators have been executed. See log for more details.");
            ((List)results.get((Object)result.getType())).add(result);
        }
        return results;
    }
}

