/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

import java.io.File;
import java.util.Random;

public final class RCELauncherHelper {
    public static final int LAUNCHER_VERSION = 810;
    public static final String PROP_RCE_LAUNCHER_VERSION = "de.rcenvironment.launcher.version";
    static final String PROP_BUNDLE_CONFIGURATION_LOCATION = "bundles.configuration.location";
    static final String PROP_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String FILE_SCHEMA = "file:";
    private static final String PROP_RCE_LAUNCHER = "de.rcenvironment.launcher";
    private static final String PROP_RCE_LAUNCH_ID = "rce.launch.id";
    private static String[] implicitNoSplashArguments = new String[]{"--headless", "--configure", "--batch", "--exec", "--shutdown"};
    private static final String OSGI_INSTALL_AREA_MISCONFIGURED = "osgi.install.area is not configured correctly: ";

    private RCELauncherHelper() {
    }

    public static boolean implicitNoSplash(String arg) {
        for (String implicitNoSplashArgument : implicitNoSplashArguments) {
            if (!implicitNoSplashArgument.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public static void setSystemPropertyToMarkCustomLaunch() {
        System.getProperties().put(PROP_RCE_LAUNCHER, PROP_RCE_LAUNCHER);
    }

    public static void setSystemPropertyToIdentifyLauncher() {
        System.getProperties().put(PROP_RCE_LAUNCHER_VERSION, Integer.toString(810));
    }

    public static void setSystemPropertyToIdentifyInstance() {
        System.getProperties().put(PROP_RCE_LAUNCH_ID, Long.toString(System.currentTimeMillis()) + "_" + Long.toString(new Random().nextLong()));
    }

    public static void setConfigurationLocationAbsolute() {
        String bundleConfigurationLocation = System.getProperty(PROP_BUNDLE_CONFIGURATION_LOCATION);
        if (bundleConfigurationLocation == null) {
            return;
        }
        File bundleConfigurationLocationFile = new File(bundleConfigurationLocation);
        boolean absolute = bundleConfigurationLocationFile.isAbsolute();
        if (!absolute) {
            String osgiInstallArea = System.getProperty(PROP_OSGI_INSTALL_AREA);
            if (osgiInstallArea == null) {
                System.err.println(OSGI_INSTALL_AREA_MISCONFIGURED + osgiInstallArea);
                return;
            }
            File osgiInstallAreaFile = osgiInstallArea.startsWith(FILE_SCHEMA) ? new File(osgiInstallArea.substring(FILE_SCHEMA.length())) : new File(osgiInstallArea);
            if (osgiInstallAreaFile.exists() && osgiInstallAreaFile.isDirectory()) {
                System.setProperty(PROP_BUNDLE_CONFIGURATION_LOCATION, new File(osgiInstallAreaFile, bundleConfigurationLocation).getAbsolutePath());
            } else {
                System.err.println(OSGI_INSTALL_AREA_MISCONFIGURED + osgiInstallArea);
            }
        }
    }

    public static void replaceDoubleDashConsoleOption(String[] args, int i) {
        if (args[i].equalsIgnoreCase("--console")) {
            args[i] = "-console";
        }
    }
}

