/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.jetty.internal;

import de.rcenvironment.core.jetty.JettyService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class JettyServiceImpl
implements JettyService {
    private static final Log LOGGER = LogFactory.getLog(JettyServiceImpl.class);
    private static final int TIMEOUT = 600000;
    private Map<String, Server> allDeployedServer = new HashMap<String, Server>();

    @Override
    public void deployWebService(Object webService, String address) {
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setAddress(address);
        svrFactory.setServiceBean(webService);
        Server server = svrFactory.create();
        this.allDeployedServer.put(address, server);
    }

    @Override
    public void undeployWebService(String address) {
        Server serverInstance = this.allDeployedServer.get(address);
        if (serverInstance != null) {
            serverInstance.stop();
        } else {
            LOGGER.warn((Object)("No Web service deployed with the given address: " + address));
        }
    }

    @Override
    public Object createWebServiceClient(Class<?> webServiceInterface, String address) {
        JaxWsProxyFactoryBean clientFactory = new JaxWsProxyFactoryBean();
        clientFactory.setServiceClass(webServiceInterface);
        clientFactory.setAddress(address);
        Object clientObject = clientFactory.create();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(600000L);
        httpClientPolicy.setReceiveTimeout(600000L);
        Client client = ClientProxy.getClient((Object)clientObject);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        httpConduit.setClient(httpClientPolicy);
        return clientObject;
    }
}

