/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.gui.utils.common.ProjectFileEncodingUtils;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.xpathchooser.VariableEntry;
import de.rcenvironment.core.gui.xpathchooser.XPathChooserHelper;
import de.rcenvironment.core.gui.xpathchooser.model.XSDElement;
import de.rcenvironment.core.gui.xpathchooser.model.XSDGenerator;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class XPathChooserDialog
extends TitleAreaDialog {
    private static final int STANDARD_WIDTH = 800;
    private static final int STANDARD_HEIGHT = 600;
    private static final Log LOGGER = LogFactory.getLog(XPathChooserDialog.class);
    private XPathChooserHelper chooser;
    private VariableEntry selectedVariables;

    public XPathChooserDialog(Shell aParentShell, XSDElement root) {
        block9: {
            super(aParentShell);
            this.chooser = null;
            this.setBlockOnOpen(true);
            this.setShellStyle(2160);
            try {
                if (root == null) {
                    String xml = null;
                    IFile ifile = PropertyTabGuiHelper.selectFileFromProjects((Shell)aParentShell, (String)"Load XML reference file", (String)"Select an XML document which structure you want to load as reference:", (String)"xml");
                    if (ifile != null) {
                        try {
                            xml = ProjectFileEncodingUtils.loadIfileAsString((IFile)ifile, (String)"UTF-8");
                        }
                        catch (CoreException e) {
                            LOGGER.error((Object)e);
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)e);
                        }
                    }
                    if (xml == null) break block9;
                    XSDElement myRoot = new XSDElement(null, "root");
                    myRoot.setElements(XSDGenerator.generate(new StringReader(xml)).getElements());
                    try {
                        myRoot.getElements().get(0).getAttributes().remove(0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Catched IndexOutOfBoundException (Ignore missing schema)");
                    }
                    this.chooser = new XPathChooserHelper(myRoot);
                    break block9;
                }
                this.chooser = new XPathChooserHelper(root);
            }
            catch (XMLStreamException xMLStreamException) {
                LOGGER.error((Object)"Could not parse provided XML document");
                MessageDialog.openError((Shell)aParentShell, (String)"Error", (String)"Could not parse provided XML document.");
                this.chooser = null;
            }
        }
    }

    public XPathChooserHelper getChooser() {
        return this.chooser;
    }

    public void create() {
        super.create();
        this.setTitle("XPath Variables Dialog");
        this.setMessage("Define an XPath by selecting a tree node.", 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        Composite c = new Composite(container, 4);
        GridData gd = new GridData(1808);
        gd.heightHint = 600;
        gd.widthHint = 800;
        c.setLayoutData((Object)gd);
        if (this.chooser != null) {
            this.chooser.createContents(c);
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("XPath Variables Dialog");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (this.chooser != null) {
            this.selectedVariables = this.chooser.getVariable();
        }
        this.setReturnCode(0);
        this.close();
    }

    public VariableEntry getSelectedVariable() {
        return this.selectedVariables;
    }

    public void setSelectedVariable(VariableEntry variable) {
        this.selectedVariables = variable;
    }
}

