/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.view.properties.AbstractInputSection;
import de.rcenvironment.core.gui.workflow.view.properties.EditableInputLabelProvider;
import de.rcenvironment.core.gui.workflow.view.properties.InputQueueDialogController;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;

public class InputSection
extends AbstractInputSection {
    private static InputSection instance;
    private Map<String, String> componentNameToIdMapping;

    public InputSection() {
        instance = this;
    }

    public static InputSection getInstance() {
        return instance;
    }

    @Override
    protected void retrieveWorkflowInformation(IWorkbenchPart part, ISelection selection) {
        Object firstSelectionElement = ((IStructuredSelection)selection).getFirstElement();
        this.wfExeInfo = (WorkflowExecutionInformation)((WorkflowExecutionInformationPart)((Object)firstSelectionElement)).getModel();
        this.componentNameToIdMapping = new HashMap<String, String>();
        for (WorkflowNode workflowNode : this.wfExeInfo.getWorkflowDescription().getWorkflowNodes()) {
            ComponentExecutionInformation componentExecutionInformation = this.wfExeInfo.getComponentExecutionInformation(workflowNode.getIdentifier());
            this.componentNameToIdMapping.put(componentExecutionInformation.getInstanceName(), componentExecutionInformation.getExecutionIdentifier());
        }
    }

    @Override
    protected void initializeTreeViewer(IWorkbenchPart part, ISelection selection) {
        this.inputTreeViewer.setLabelProvider((IBaseLabelProvider)new EditableInputLabelProvider(this.wfExeInfo));
        this.inputTreeViewer.setInput(this.wfExeInfo.getWorkflowDescription());
    }

    @Override
    protected void openInputDialog(TreeItem item) {
        TreeItem childItem = item;
        while (item.getParentItem() != null) {
            item = item.getParentItem();
        }
        String componentId = this.componentNameToIdMapping.get(item.getText());
        new InputQueueDialogController(this.wfExeInfo, componentId, childItem.getText()).open();
    }
}

