/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.EndpointContentProvider;
import de.rcenvironment.core.gui.workflow.EndpointLabelProvider;
import de.rcenvironment.core.gui.workflow.view.properties.InputEditingHelper;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class EditableInputLabelProvider
extends EndpointLabelProvider
implements ITableLabelProvider {
    private WorkflowExecutionInformation workflowInformation;
    private String workflowId;
    private String componentId;

    public EditableInputLabelProvider(WorkflowExecutionInformation workflowInformation) {
        super(EndpointType.INPUT);
        this.workflowInformation = workflowInformation;
        this.workflowId = workflowInformation.getExecutionIdentifier();
    }

    public EditableInputLabelProvider(String workflowId, String componentId) {
        super(EndpointType.INPUT);
        this.workflowId = workflowId;
        this.componentId = componentId;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        String inputValue = "";
        if (element instanceof EndpointContentProvider.Endpoint) {
            if (this.componentId == null) {
                if (columnIndex == 1) {
                    inputValue = InputEditingHelper.getLatestInputValue(this.workflowInformation, (EndpointContentProvider.Endpoint)element);
                }
            } else if (columnIndex == 1) {
                inputValue = InputEditingHelper.getLatestInputValueFromEndpoint(this.workflowId, this.componentId, (EndpointContentProvider.Endpoint)element);
            }
        }
        return inputValue;
    }
}

