/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicInputWithOutputsCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputWithOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputWithOutputsCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputWithOutputsCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.ForwardingEndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputCoupledWithOutputsSelectionPane
extends ForwardingEndpointSelectionPane {
    private final String dynEndpointId;
    private final String addDynOutputId;
    private final String outputNameSuffix;
    private final Refreshable outputPane;
    private Map<String, String> metaDataInput = new HashMap<String, String>();
    private Map<String, String> metaDataOutput = new HashMap<String, String>();
    private Map<String, String> metaDataOutputWithSuffix = new HashMap<String, String>();

    public InputCoupledWithOutputsSelectionPane(String title, String dynEndpointId, String addDynOutputId, String outputNameSuffix, WorkflowNodeCommand.Executor executor, Refreshable outputPane) {
        super(title, EndpointType.INPUT, dynEndpointId, new String[0], executor);
        this.dynEndpointId = dynEndpointId;
        this.addDynOutputId = addDynOutputId;
        this.outputNameSuffix = outputNameSuffix;
        this.outputPane = outputPane;
    }

    @Override
    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        this.metaDataInput.putAll(metaData);
        AddDynamicInputWithOutputsCommand command = new AddDynamicInputWithOutputsCommand(this.dynEndpointId, this.addDynOutputId, this.outputNameSuffix, name, type, this.metaDataInput, this, this.outputPane);
        command.setMetaDataOutput(this.metaDataOutput);
        command.setMetaDataOutputWithSuffix(this.metaDataOutputWithSuffix);
        this.execute(command);
    }

    @Override
    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        WorkflowNodeCommand command;
        if (oldDescription.getDynamicEndpointIdentifier().equals(this.dynEndpointIdToManage)) {
            command = new EditDynamicInputWithOutputsCommand(oldDescription, newDescription, this.outputNameSuffix, this, this.outputPane);
            ((EditDynamicInputWithOutputCommand)command).setMetaDataOutput(this.metaDataOutput);
            ((EditDynamicInputWithOutputsCommand)command).setMetaDataOutputWithSuffix(this.metaDataOutputWithSuffix);
        } else {
            command = new EditDynamicInputCommand(oldDescription.getDynamicEndpointIdentifier(), oldDescription.getName(), newDescription.getName(), newDescription.getDataType(), (Map<String, String>)newDescription.getMetaData(), this);
        }
        this.execute(command);
    }

    @Override
    protected void executeRemoveCommand(List<String> names) {
        RemoveDynamicInputWithOutputsCommand command = new RemoveDynamicInputWithOutputsCommand(this.dynEndpointId, this.addDynOutputId, this.outputNameSuffix, names, this, this.outputPane);
        this.execute(command);
    }

    @Override
    public void setMetaDataInput(Map<String, String> metaDataInput) {
        this.metaDataInput = metaDataInput;
    }

    public void setMetaDataOutput(Map<String, String> metaDataOutput) {
        this.metaDataOutput = metaDataOutput;
    }

    public void setMetaDataOutputWithSuffix(Map<String, String> metaDataOutputWithSuffix) {
        this.metaDataOutputWithSuffix = metaDataOutputWithSuffix;
    }
}

