/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.connections;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.workflow.editor.commands.ConnectionDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.connections.EndpointTreeViewer;
import de.rcenvironment.core.gui.workflow.editor.connections.Messages;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;

public class ConnectionCanvas
extends FigureCanvas {
    protected static final int DEFAULT_TOLERANCE = 5;
    private Figure parentFigure;
    private Menu contextMenu;
    private MenuItem deleteMenuItem;
    private Set<ConnectionFigure> currentSelection = new HashSet<ConnectionFigure>();
    private WorkflowDescription description;
    private EndpointTreeViewer sourceTreeViewer;
    private EndpointTreeViewer targetTreeViewer;
    private CommandStack editorsCommandStack;

    public ConnectionCanvas(Composite parent, int style) {
        super(parent, style);
        this.parentFigure = new Figure();
        this.parentFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.setContents((IFigure)this.parentFigure);
        this.parentFigure.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (e.button == 1) {
                    ConnectionCanvas.this.setSelection(null, (e.getState() & 0x40000) != 0);
                    Set<ConnectionFigure> selection = ConnectionCanvas.this.findConnectionsAt(e.x, e.y, 5);
                    ConnectionCanvas.this.setSelection(selection, (e.getState() & 0x40000) != 0);
                    ConnectionCanvas.this.deleteMenuItem.setEnabled(!selection.isEmpty());
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    ConnectionCanvas.this.deleteSelectedConnections();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.contextMenu = new Menu((Control)this);
        this.setMenu(this.contextMenu);
        this.deleteMenuItem = new MenuItem(this.contextMenu, 0);
        this.deleteMenuItem.setEnabled(false);
        this.deleteMenuItem.setText(Messages.delete);
        this.deleteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConnectionCanvas.this.deleteSelectedConnections();
            }
        });
    }

    private void setSelection(Set<ConnectionFigure> connections, boolean controlDown) {
        block8: {
            if (!controlDown) {
                for (ConnectionFigure connection : this.currentSelection) {
                    connection.setSelected(false);
                }
                this.currentSelection.clear();
            }
            if (connections == null) break block8;
            if (controlDown) {
                LinkedList<ConnectionFigure> toDelete = new LinkedList<ConnectionFigure>();
                for (ConnectionFigure c : connections) {
                    if (this.currentSelection.contains((Object)c)) {
                        toDelete.add(c);
                        continue;
                    }
                    this.currentSelection.add(c);
                    c.setSelected(true);
                }
                for (ConnectionFigure c : toDelete) {
                    this.currentSelection.remove((Object)c);
                    c.setSelected(false);
                }
            } else {
                this.currentSelection.addAll(connections);
                for (ConnectionFigure connection : this.currentSelection) {
                    connection.setSelected(true);
                }
            }
        }
    }

    private Set<ConnectionFigure> getSelection() {
        return Collections.unmodifiableSet(this.currentSelection);
    }

    public void setEditorsCommandStack(CommandStack editorsCommandStack) {
        this.editorsCommandStack = editorsCommandStack;
    }

    private void deleteSelectedConnections() {
        this.deleteConnections(this.getSelection());
        this.setSelection(null, false);
    }

    private void deleteConnections(Collection<ConnectionFigure> connections) {
        boolean dirty = false;
        ArrayList<Connection> connectionsToDelete = new ArrayList<Connection>();
        for (ConnectionFigure connectionFigure : connections) {
            connectionsToDelete.add(connectionFigure.getConnection());
            dirty = true;
        }
        if (this.editorsCommandStack == null) {
            this.description.removeConnections(connectionsToDelete);
            this.targetTreeViewer.refresh();
            this.sourceTreeViewer.refresh();
        } else {
            ConnectionDeleteCommand connectionDeleteCommand = new ConnectionDeleteCommand(this.description, connectionsToDelete);
            this.editorsCommandStack.execute((Command)connectionDeleteCommand);
        }
        if (dirty) {
            this.repaint();
        }
    }

    protected ConnectionFigure findFirstConnectionAt(int x, int y, int tolerance) {
        List children = this.parentFigure.getChildren();
        int toleranceIndex = 0;
        while (toleranceIndex <= tolerance) {
            Rectangle hitarea = new Rectangle(x - toleranceIndex, y - toleranceIndex, 1 + 2 * toleranceIndex, 1 + 2 * toleranceIndex);
            for (Object child : children) {
                ConnectionFigure childFigure;
                if (!(child instanceof ConnectionFigure) || !(childFigure = (ConnectionFigure)((Object)child)).intersects(hitarea)) continue;
                return childFigure;
            }
            ++toleranceIndex;
        }
        return null;
    }

    protected Set<ConnectionFigure> findConnectionsAt(int x, int y, int tolerance) {
        HashSet<ConnectionFigure> result = new HashSet<ConnectionFigure>();
        List children = this.parentFigure.getChildren();
        int toleranceIndex = 0;
        while (toleranceIndex <= tolerance) {
            Rectangle hitarea = new Rectangle(x - toleranceIndex, y - toleranceIndex, 1 + 2 * toleranceIndex, 1 + 2 * toleranceIndex);
            for (Object child : children) {
                ConnectionFigure childFigure;
                if (!(child instanceof ConnectionFigure) || !(childFigure = (ConnectionFigure)((Object)child)).intersects(hitarea)) continue;
                result.add(childFigure);
            }
            if (!result.isEmpty()) break;
            ++toleranceIndex;
        }
        return Collections.unmodifiableSet(result);
    }

    public void initialize(WorkflowDescription desc, EndpointTreeViewer source, EndpointTreeViewer target) {
        this.description = desc;
        this.sourceTreeViewer = source;
        this.targetTreeViewer = target;
    }

    public void updateCanvas(WorkflowDescription desc) {
        this.description = desc;
        this.repaint();
    }

    public void repaint() {
        this.parentFigure.removeAll();
        for (Connection c : this.description.getConnections()) {
            TreeItem outputItem = this.sourceTreeViewer.findEndpoint(c.getSourceNode(), c.getOutput().getName());
            TreeItem inputItem = this.targetTreeViewer.findEndpoint(c.getTargetNode(), c.getInput().getName());
            if (inputItem == null || outputItem == null) continue;
            int outputY = outputItem.getBounds().y + outputItem.getBounds().height / 2;
            int outputX = 0;
            int inputY = inputItem.getBounds().y + inputItem.getBounds().height / 2;
            int inputX = this.parentFigure.getBounds().width;
            ConnectionFigure line = new ConnectionFigure(c, new Point(outputX, outputY), new Point(inputX, inputY));
            line.setAntialias(1);
            this.parentFigure.add((IFigure)line);
        }
    }

    private class ConnectionFigure
    extends PolylineConnection {
        private final Connection connection;

        ConnectionFigure(Connection connection, Point start, Point end) {
            this.connection = connection;
            this.setStart(start);
            this.setEnd(end);
            this.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.setForegroundColor(ColorConstants.blue);
            } else {
                this.setForegroundColor(ColorConstants.black);
            }
        }

        public boolean intersects(Rectangle rect) {
            if (!super.intersects(rect)) {
                return false;
            }
            int lineWidth = this.getLineWidth();
            int lineWidthAdjustment = lineWidth - 1;
            Point start = this.getStart();
            Point end = this.getEnd();
            Line2D.Float line = new Line2D.Float(start.x, start.y, end.x, end.y);
            Rectangle2D.Double rectangle = new Rectangle2D.Double(rect.x - lineWidthAdjustment, rect.y - lineWidthAdjustment, rect.width + 2 * lineWidthAdjustment, rect.height + 2 * lineWidthAdjustment);
            return line.intersects(rectangle);
        }
    }
}

