/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WizardInsertCopyCommandDialog
extends Dialog {
    private static final String REQUIRED = " (required)";
    private static final String FILE = "File";
    private static final String SLASH = "/";
    private static final String DIRECTORY_PREFIX = "Directory: ";
    private static final String INPUT_PREFIX = "Input ";
    private static final String TARGET_STRING = "*TARGET*";
    private static final String SOURCE_STRING = "*SOURCE*";
    private static final String SHUTIL_COPYTREE_STRING = StringUtils.format((String)"shutil.copytree(\"%s\", \"%s\")", (Object[])new Object[]{"*SOURCE*", "*TARGET*"});
    private static final String SHUTIL_COPY_STRING = StringUtils.format((String)"shutil.copy(\"%s\", \"%s\")", (Object[])new Object[]{"*SOURCE*", "*TARGET*"});
    private static final int SOURCE = 0;
    private static final int TARGET = 1;
    private Button fileToFileButton;
    private Button dirButton;
    private String command;
    private final List<String> inputs;
    private final String[] directories;
    private Button fileToDirButton;
    private Button[] predefOptionButtons;
    private Button[] customOptionButtons;
    private Combo[] predefCombos;
    private Text[] predefTexts;
    private Text[] customTexts;
    private Button[] customChooseButtons;
    private Label previewCommandLabel;
    private Label[] slashLabel;
    private CLabel validationLabel;

    public WizardInsertCopyCommandDialog(Shell parentShell, List<String> endpointNames, String[] directories) {
        super(parentShell);
        this.inputs = endpointNames;
        this.directories = directories;
        this.setShellStyle(0xC70 | WizardInsertCopyCommandDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.copyDialogShellText);
        this.command = SHUTIL_COPY_STRING;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData g = new GridData(1808);
        container.setLayoutData((Object)g);
        Composite typeContainer = new Composite(container, 0);
        typeContainer.setLayout((Layout)new GridLayout(5, false));
        Label sourceType = new Label(typeContainer, 0);
        sourceType.setText(Messages.copy);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 1;
        sourceType.setLayoutData((Object)labelData);
        this.fileToFileButton = new Button(typeContainer, 16);
        this.fileToFileButton.setText(Messages.copyFileToFile);
        GridData fileData = new GridData();
        this.fileToFileButton.setLayoutData((Object)fileData);
        this.fileToFileButton.setSelection(true);
        this.fileToDirButton = new Button(typeContainer, 16);
        this.fileToDirButton.setText(Messages.copyFileToDir);
        GridData fileToDirData = new GridData();
        this.fileToDirButton.setLayoutData((Object)fileToDirData);
        this.dirButton = new Button(typeContainer, 16);
        this.dirButton.setText(Messages.copyDirToDir);
        GridData dirData = new GridData();
        dirData.horizontalSpan = 2;
        this.dirButton.setLayoutData((Object)dirData);
        this.predefOptionButtons = new Button[2];
        this.customOptionButtons = new Button[2];
        this.predefCombos = new Combo[2];
        this.predefTexts = new Text[2];
        this.slashLabel = new Label[2];
        this.customTexts = new Text[2];
        this.customChooseButtons = new Button[2];
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.buildUpElements(0, container);
        Label separator3 = new Label(container, 258);
        separator3.setLayoutData((Object)new GridData(768));
        separator3.setVisible(false);
        this.buildUpElements(1, container);
        Label separator2 = new Label(container, 258);
        separator2.setLayoutData((Object)new GridData(768));
        Label previewLabel = new Label(container, 0);
        previewLabel.setText(Messages.insertCommand);
        this.previewCommandLabel = new Label(container, 0);
        this.previewCommandLabel.setLayoutData((Object)new GridData(768));
        this.validationLabel = new CLabel(container, 0);
        this.validationLabel.setLayoutData((Object)new GridData(768));
        this.validationLabel.setVisible(false);
        this.validationLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
        return container;
    }

    private Text buildUpElements(int type, Composite container) {
        Label label = new Label(container, 0);
        if (type == 0) {
            label.setText(Messages.source);
        } else {
            label.setText(Messages.target);
        }
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        GridData compData = new GridData(768);
        compData.horizontalIndent = 10;
        composite.setLayoutData((Object)compData);
        Button predefPathButton = new Button(composite, 16);
        predefPathButton.setText(Messages.predefinedPath);
        GridData pathButtonData = new GridData();
        pathButtonData.horizontalSpan = 5;
        predefPathButton.setLayoutData((Object)pathButtonData);
        predefPathButton.setSelection(true);
        this.predefOptionButtons[type] = predefPathButton;
        Combo combo = new Combo(composite, 8);
        GridData comboData = new GridData();
        this.fillCombo(combo, type);
        combo.setLayoutData((Object)comboData);
        this.predefCombos[type] = combo;
        Label slash = new Label(composite, 0);
        slash.setText(SLASH);
        GridData slashData = new GridData();
        slashData.widthHint = 5;
        slash.setLayoutData((Object)slashData);
        this.slashLabel[type] = slash;
        Text predefText = new Text(composite, 2048);
        GridData predefTextData = new GridData(768);
        predefTextData.horizontalSpan = 3;
        predefText.setLayoutData((Object)predefTextData);
        predefText.setMessage(Messages.subfolderOrFilename);
        this.predefTexts[type] = predefText;
        Button customPathButton = new Button(composite, 16);
        customPathButton.setText(Messages.customPath);
        GridData customButtonData = new GridData(768);
        customButtonData.horizontalSpan = 5;
        customPathButton.setLayoutData((Object)customButtonData);
        this.customOptionButtons[type] = customPathButton;
        Text text = new Text(composite, 2048);
        GridData sourceTextData = new GridData(768);
        sourceTextData.horizontalSpan = 4;
        text.setLayoutData((Object)sourceTextData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardInsertCopyCommandDialog.this.updateSelectionAndValidateInput();
            }
        });
        this.customTexts[type] = text;
        Button selectionButton = new Button(composite, 8);
        selectionButton.setText(" ... ");
        selectionButton.addSelectionListener((SelectionListener)new FileDirButtonChooser(text));
        this.customChooseButtons[type] = selectionButton;
        return text;
    }

    private void fillCombo(Combo combo, int type) {
        String selection = combo.getText();
        combo.removeAll();
        for (String input : this.inputs) {
            if (input.startsWith(FILE) && type == 0 && (this.fileToFileButton.getSelection() || this.fileToDirButton.getSelection())) {
                combo.add(INPUT_PREFIX + input);
                continue;
            }
            if (!input.startsWith(FILE) || type != 1 || !this.fileToFileButton.getSelection()) continue;
            combo.add(INPUT_PREFIX + input);
        }
        String[] stringArray = this.directories;
        int n = this.directories.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            combo.add(DIRECTORY_PREFIX + dir);
            ++n2;
        }
        if (selection != null && combo.indexOf(selection) >= 0) {
            combo.select(combo.indexOf(selection));
        }
    }

    public void create() {
        super.create();
        this.installListeners();
        this.updateSelectionAndValidateInput();
    }

    private void installListeners() {
        UpdateListener ul = new UpdateListener();
        this.fileToFileButton.addSelectionListener((SelectionListener)ul);
        this.fileToDirButton.addSelectionListener((SelectionListener)ul);
        this.dirButton.addSelectionListener((SelectionListener)ul);
        int i = 0;
        while (i < 2) {
            this.predefOptionButtons[i].addSelectionListener((SelectionListener)ul);
            this.customOptionButtons[i].addSelectionListener((SelectionListener)ul);
            this.predefCombos[i].addSelectionListener((SelectionListener)ul);
            this.customChooseButtons[i].addSelectionListener((SelectionListener)ul);
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.predefTexts[i].addModifyListener((ModifyListener)ul);
            this.customTexts[i].addModifyListener((ModifyListener)ul);
            ++i;
        }
    }

    protected void updateSelectionAndValidateInput() {
        int i = 0;
        while (i < 2) {
            this.customTexts[i].setEnabled(!this.predefOptionButtons[i].getSelection());
            this.customChooseButtons[i].setEnabled(!this.predefOptionButtons[i].getSelection());
            this.predefCombos[i].setEnabled(this.predefOptionButtons[i].getSelection());
            this.predefTexts[i].setEnabled(this.predefOptionButtons[i].getSelection());
            if (this.predefCombos[i].getText() != null && this.predefCombos[i].getText().startsWith("Input File")) {
                this.predefTexts[i].setVisible(false);
                this.slashLabel[i].setVisible(false);
            } else {
                this.predefTexts[i].setVisible(true);
                this.slashLabel[i].setVisible(true);
            }
            ++i;
        }
        if (this.fileToFileButton.getSelection()) {
            this.predefTexts[0].setMessage(String.valueOf(Messages.subfolderOrFilename) + REQUIRED);
            this.predefTexts[1].setMessage(Messages.subfolderOrFilename);
        } else if (this.fileToDirButton.getSelection()) {
            this.predefTexts[0].setMessage(String.valueOf(Messages.subfolderOrFilename) + REQUIRED);
            this.predefTexts[1].setMessage(Messages.subfolderOrFilename.substring(0, Messages.subfolderOrFilename.indexOf(SLASH)));
        } else if (this.dirButton.getSelection()) {
            this.predefTexts[0].setMessage(Messages.subfolderOrFilename.substring(0, Messages.subfolderOrFilename.indexOf(SLASH)));
            this.predefTexts[1].setMessage(String.valueOf(Messages.subfolderOrFilename.substring(0, Messages.subfolderOrFilename.indexOf(SLASH))) + REQUIRED);
        }
        boolean isSourceValid = true;
        LinkedList<String> validationMessages = new LinkedList<String>();
        if (this.predefOptionButtons[0].getSelection()) {
            if (this.predefCombos[0].getText() == null || this.predefCombos[0].getText().isEmpty()) {
                isSourceValid = false;
                validationMessages.add("Relative source path not valid.");
            }
            if ((this.fileToFileButton.getSelection() || this.fileToDirButton.getSelection()) && (this.predefTexts[0].getText() == null || this.predefTexts[0].getText().isEmpty() && !this.predefCombos[0].getText().startsWith("Input File"))) {
                isSourceValid = false;
                validationMessages.add("Relative source file not valid.");
            }
        } else if (this.customTexts[0].getText() == null || this.customTexts[0].getText().isEmpty()) {
            isSourceValid = false;
            validationMessages.add("Absolute source path not valid.");
        } else if (!new File(this.customTexts[0].getText()).isAbsolute()) {
            isSourceValid = false;
            validationMessages.add("Source path is not absolute.");
        }
        boolean isTargetValid = true;
        if (this.predefOptionButtons[1].getSelection()) {
            if (this.predefCombos[1].getText() == null || this.predefCombos[1].getText().isEmpty()) {
                isTargetValid = false;
                validationMessages.add("Relative target path not valid.");
            }
            if (this.dirButton.getSelection() && (this.predefTexts[1].getText() == null || this.predefTexts[1].getText().isEmpty())) {
                isTargetValid = false;
                validationMessages.add("Relative target directory not valid.");
            }
        } else if (this.customTexts[1].getText() == null || this.customTexts[1].getText().isEmpty()) {
            isTargetValid = false;
            validationMessages.add("Absolute target path not valid.");
        } else if (!new File(this.customTexts[1].getText()).isAbsolute()) {
            isTargetValid = false;
            validationMessages.add("Target path is not absolute.");
        }
        if (!validationMessages.isEmpty()) {
            this.validationLabel.setForeground(Display.getCurrent().getSystemColor(3));
            this.validationLabel.setText((String)validationMessages.get(0));
            this.validationLabel.setVisible(true);
            this.validationLabel.pack();
        } else {
            this.validationLabel.setVisible(false);
        }
        boolean isValid = isSourceValid && isTargetValid;
        this.buildCommand(isValid);
        this.getButton(0).setEnabled(isValid);
    }

    private void buildCommand(boolean isValid) {
        String slash;
        this.command = this.dirButton.getSelection() ? SHUTIL_COPYTREE_STRING : SHUTIL_COPY_STRING;
        if (this.predefOptionButtons[0].getSelection()) {
            slash = SLASH;
            if (this.predefCombos[0].getText() != null && this.predefCombos[0].getText().startsWith("Input File")) {
                slash = "";
            }
            this.command = this.command.replace(SOURCE_STRING, String.valueOf(this.getPlaceholder(this.predefCombos[0].getText())) + slash + this.predefTexts[0].getText());
        } else {
            this.command = this.command.replace(SOURCE_STRING, this.customTexts[0].getText());
        }
        if (this.predefOptionButtons[1].getSelection()) {
            slash = SLASH;
            if (this.predefCombos[1].getText() != null && this.predefCombos[1].getText().startsWith("Input File")) {
                slash = "";
            }
            this.command = this.command.replace(TARGET_STRING, String.valueOf(this.getPlaceholder(this.predefCombos[1].getText())) + slash + this.predefTexts[1].getText());
        } else {
            this.command = this.command.replace(TARGET_STRING, this.customTexts[1].getText());
        }
        if (isValid) {
            this.previewCommandLabel.setText(this.command);
        } else {
            this.previewCommandLabel.setText("-");
        }
    }

    private String getPlaceholder(String selection) {
        if (selection != null && !selection.isEmpty()) {
            String name = selection.substring(selection.indexOf(":") + 2);
            String insertString = "${%s:%s}";
            if (selection.startsWith(INPUT_PREFIX)) {
                insertString = StringUtils.format((String)insertString, (Object[])new Object[]{"in", name});
            } else if (selection.startsWith(DIRECTORY_PREFIX)) {
                int i = 0;
                while (!name.equals(ToolIntegrationConstants.DIRECTORIES_PLACEHOLDERS_DISPLAYNAMES[i])) {
                    ++i;
                }
                if (i < ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER.length) {
                    insertString = StringUtils.format((String)insertString, (Object[])new Object[]{"dir", ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[i]});
                }
            }
            return insertString;
        }
        return "";
    }

    public String getCopyCommand() {
        return this.command;
    }

    private class FileDirButtonChooser
    implements SelectionListener {
        private final Text text;

        FileDirButtonChooser(Text text) {
            this.text = text;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            String result = "";
            if (WizardInsertCopyCommandDialog.this.fileToFileButton.getSelection() || WizardInsertCopyCommandDialog.this.fileToDirButton.getSelection() && arg0.getSource().equals(WizardInsertCopyCommandDialog.this.customChooseButtons[0])) {
                FileDialog f = new FileDialog(WizardInsertCopyCommandDialog.this.getShell());
                result = f.open();
            } else {
                DirectoryDialog d = new DirectoryDialog(WizardInsertCopyCommandDialog.this.getShell());
                result = d.open();
            }
            if (result != null) {
                this.text.clearSelection();
                this.text.setText(result.replaceAll("\\\\", WizardInsertCopyCommandDialog.SLASH));
                this.text.forceFocus();
            }
        }
    }

    private class UpdateListener
    implements SelectionListener,
    ModifyListener {
        private UpdateListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            if (arg0.getSource().equals(WizardInsertCopyCommandDialog.this.fileToDirButton) || arg0.getSource().equals(WizardInsertCopyCommandDialog.this.fileToFileButton) || arg0.getSource().equals(WizardInsertCopyCommandDialog.this.dirButton)) {
                WizardInsertCopyCommandDialog.this.fillCombo(WizardInsertCopyCommandDialog.this.predefCombos[0], 0);
                WizardInsertCopyCommandDialog.this.fillCombo(WizardInsertCopyCommandDialog.this.predefCombos[1], 1);
            }
            WizardInsertCopyCommandDialog.this.updateSelectionAndValidateInput();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void modifyText(ModifyEvent arg0) {
            WizardInsertCopyCommandDialog.this.updateSelectionAndValidateInput();
        }
    }
}

