/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.endpoint;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class EndpointHelper {
    @Deprecated
    private EndpointHelper() {
    }

    private static List<String> getMetadataGUINames(EndpointMetaDataConstants.Visibility visibility, EndpointType endpointType, List<String> dynEndpointIdsToConsider, List<String> statEndpointNamesToConsider, ComponentInstanceProperties compInstProps) {
        LinkedHashSet<String> resultList = new LinkedHashSet<String>();
        Set dynamicEndpointDefinitions = null;
        Set staticEndpointDefinitions = null;
        if (compInstProps != null) {
            EndpointDescriptionsManager endpointManager = EndpointHelper.getEndpointDescriptionsManager(endpointType, compInstProps);
            dynamicEndpointDefinitions = endpointManager.getDynamicEndpointDefinitions(dynEndpointIdsToConsider);
            staticEndpointDefinitions = endpointManager.getStaticEndpointDefinitions(statEndpointNamesToConsider);
            TreeMap staticGroups = new TreeMap();
            for (EndpointDefinition currentDefinition : staticEndpointDefinitions) {
                EndpointMetaDataDefinition metaDataDefinition = currentDefinition.getMetaDataDefinition();
                for (Object metaDatumKey : metaDataDefinition.getMetaDataKeys()) {
                    if (!metaDataDefinition.getVisibility((String)metaDatumKey).equals((Object)visibility) || !EndpointHelper.checkConfigurationFilter(metaDataDefinition.getGuiVisibilityFilter((String)metaDatumKey), compInstProps.getConfigurationDescription())) continue;
                    Map<Integer, String> sortedKeyMap = null;
                    if (staticGroups.get(metaDataDefinition.getGuiGroup((String)metaDatumKey)) != null) {
                        sortedKeyMap = (Map)staticGroups.get(metaDataDefinition.getGuiGroup((String)metaDatumKey));
                    } else {
                        sortedKeyMap = new TreeMap();
                        staticGroups.put(metaDataDefinition.getGuiGroup((String)metaDatumKey), sortedKeyMap);
                    }
                    sortedKeyMap.put(metaDataDefinition.getGuiPosition((String)metaDatumKey), metaDataDefinition.getGuiName((String)metaDatumKey));
                }
            }
            for (Map groups : staticGroups.values()) {
                for (String key : groups.values()) {
                    resultList.add(key);
                }
            }
            TreeMap dynamicGroups = new TreeMap();
            for (EndpointDefinition dynamicDescription : dynamicEndpointDefinitions) {
                if (dynamicDescription == null) continue;
                EndpointMetaDataDefinition metaDataDefinition = dynamicDescription.getMetaDataDefinition();
                for (String metaDatumKey : dynamicDescription.getMetaDataDefinition().getMetaDataKeys()) {
                    if (!dynamicDescription.getMetaDataDefinition().getVisibility(metaDatumKey).equals((Object)visibility) || !EndpointHelper.checkConfigurationFilter(metaDataDefinition.getGuiVisibilityFilter(metaDatumKey), compInstProps.getConfigurationDescription())) continue;
                    Map<Integer, String> sortedKeyMap = null;
                    if (dynamicGroups.get(metaDataDefinition.getGuiGroup(metaDatumKey)) != null) {
                        sortedKeyMap = (Map)dynamicGroups.get(metaDataDefinition.getGuiGroup(metaDatumKey));
                    } else {
                        sortedKeyMap = new TreeMap();
                        dynamicGroups.put(metaDataDefinition.getGuiGroup(metaDatumKey), sortedKeyMap);
                    }
                    sortedKeyMap.put(metaDataDefinition.getGuiPosition(metaDatumKey), metaDataDefinition.getGuiName(metaDatumKey));
                }
            }
            for (Map groups : dynamicGroups.values()) {
                for (String key : groups.values()) {
                    resultList.add(key);
                }
            }
        }
        return new LinkedList<String>(resultList);
    }

    public static List<String> getAllStaticEndpointNames(EndpointType endpointType, ComponentInstanceProperties compInstProps) {
        ArrayList<String> endpointNames = new ArrayList<String>();
        EndpointDescriptionsManager endpointManager = EndpointHelper.getEndpointDescriptionsManager(endpointType, compInstProps);
        for (EndpointDefinition endpointDef : endpointManager.getStaticEndpointDefinitions()) {
            endpointNames.add(endpointDef.getName());
        }
        Collections.sort(endpointNames);
        return endpointNames;
    }

    public static List<String> getAllDynamicEndpointIds(EndpointType endpointType, ComponentInstanceProperties compInstProps) {
        ArrayList<String> endpointIds = new ArrayList<String>();
        EndpointDescriptionsManager endpointManager = EndpointHelper.getEndpointDescriptionsManager(endpointType, compInstProps);
        for (EndpointDefinition endpointDef : endpointManager.getDynamicEndpointDefinitions()) {
            endpointIds.add(endpointDef.getIdentifier());
        }
        return endpointIds;
    }

    private static EndpointDescriptionsManager getEndpointDescriptionsManager(EndpointType endpointType, ComponentInstanceProperties compInstProps) {
        EndpointDescriptionsManager endpointManager = endpointType == EndpointType.INPUT ? compInstProps.getInputDescriptionsManager() : compInstProps.getOutputDescriptionsManager();
        return endpointManager;
    }

    private static boolean checkConfigurationFilter(Map<String, List<String>> filter, ConfigurationDescription configurationDescription) {
        if (filter != null && !filter.isEmpty()) {
            for (String filterKey : filter.keySet()) {
                for (String filterValues : filter.get(filterKey)) {
                    String newFilterKey;
                    if (!filterKey.startsWith("configuration:") || configurationDescription.getConfigurationValue(newFilterKey = filterKey.split(":")[1]) == null || !configurationDescription.getConfigurationValue(newFilterKey).equals(filterValues)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean checkMetadataFilter(Map<String, List<String>> filter, Map<String, String> metaDataValues, ConfigurationDescription configDesc) {
        if (filter != null && !filter.isEmpty()) {
            boolean result = true;
            for (String filterKey : filter.keySet()) {
                for (String filterValues : filter.get(filterKey)) {
                    if (filterKey.startsWith("configuration:")) {
                        String newFilterKey = filterKey.split(":")[1];
                        if (configDesc.getConfigurationValue(newFilterKey) != null && configDesc.getConfigurationValue(newFilterKey).equals(filterValues)) continue;
                        result = false;
                        continue;
                    }
                    if (metaDataValues.get(filterKey) != null && metaDataValues.get(filterKey).equals(filterValues)) continue;
                    result = false;
                }
            }
            return result;
        }
        return true;
    }

    public static List<String> getMetaDataNamesForTable(EndpointType endpointType, List<String> dynEndpointIdsToConsider, List<String> statEndpointNamesToConsider, ComponentInstanceProperties configuration) {
        return EndpointHelper.getMetadataGUINames(EndpointMetaDataConstants.Visibility.shown, endpointType, dynEndpointIdsToConsider, statEndpointNamesToConsider, configuration);
    }
}

