/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.components;

import de.rcenvironment.core.gui.utils.common.components.FileValidator;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public final class PropertyTabGuiHelper {
    public static final int OFFSET = 5;
    public static final int PERC_100 = 100;
    private static final Log LOGGER = LogFactory.getLog(PropertyTabGuiHelper.class);
    private static FileValidator fileValidator = new FileValidator();

    private PropertyTabGuiHelper() {
    }

    public static Composite createActionButtons(Composite parent, TabbedPropertySheetWidgetFactory factory, Map<String, Map<String, Runnable>> buttonActionMap) {
        Composite composite = factory.createFlatFormComposite(parent);
        composite.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        Button lastButton = factory.createButton(composite, buttonActionMap.keySet().iterator().next(), 0x800000);
        lastButton.addMouseListener(PropertyTabGuiHelper.createActions(lastButton, buttonActionMap.values().iterator().next()));
        lastButton.setLayoutData((Object)data);
        buttonActionMap.remove(buttonActionMap.keySet().iterator().next());
        for (Map.Entry<String, Map<String, Runnable>> entry : buttonActionMap.entrySet()) {
            data = new FormData();
            data.top = new FormAttachment(0, 5);
            data.left = new FormAttachment((Control)lastButton, 5);
            lastButton = factory.createButton(composite, entry.getKey(), 0x800000);
            lastButton.addMouseListener(PropertyTabGuiHelper.createActions(lastButton, entry.getValue()));
            lastButton.setLayoutData((Object)data);
        }
        return composite;
    }

    private static MouseListener createActions(final Button button, final Map<String, Runnable> actions) {
        return new MouseListener(){

            public void action(MouseEvent event) {
                if (actions.size() > 1) {
                    final Menu menu = new Menu((Decorations)button.getShell(), 8);
                    menu.setLocation(button.toDisplay(event.x, event.y));
                    menu.setVisible(true);
                    for (final Map.Entry entry : actions.entrySet()) {
                        MenuItem item = new MenuItem(menu, 0);
                        item.setText((String)entry.getKey());
                        item.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent event) {
                                menu.setVisible(false);
                                menu.dispose();
                                ((Runnable)entry.getValue()).run();
                            }

                            public void widgetDefaultSelected(SelectionEvent event) {
                                this.widgetSelected(event);
                            }
                        });
                    }
                } else if (actions.size() == 1) {
                    ((Runnable)actions.values().iterator().next()).run();
                }
            }

            public void mouseDown(MouseEvent event) {
                this.action(event);
            }

            public void mouseDoubleClick(MouseEvent event) {
            }

            public void mouseUp(MouseEvent event) {
            }
        };
    }

    public static Section createSingleColumnSectionComposite(Composite parent, TabbedPropertySheetWidgetFactory factory, String title) {
        Composite composite = factory.createFlatFormComposite(parent);
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 1;
        composite.setLayout((Layout)layout);
        Section section = factory.createSection(composite, 256);
        section.setText(title);
        return section;
    }

    public static IFile selectFileFromActiveProject(Shell shell, String title, String message) {
        String project = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput().toString().split("/")[1];
        Object resource = PropertyTabGuiHelper.selectFileOrDirectoryFromWorkspace(shell, title, message, ResourcesPlugin.getWorkspace().getRoot().getProject(project), SelectionType.FILE);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static IFolder selectDirectoryFromActiveProject(Shell shell, String title, String message) {
        String project = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput().toString().split("/")[1];
        return (IFolder)PropertyTabGuiHelper.selectFileOrDirectoryFromWorkspace(shell, title, message, ResourcesPlugin.getWorkspace().getRoot().getProject(project), SelectionType.DIRECTORY);
    }

    public static IResource selectDirectoryFromActiveProjectIncludingItsRoot(Shell shell, String title, String message) {
        final IProject project = PropertyTabGuiHelper.getProjectOfCurrentlyActiveEditor();
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider()){

            protected Control createContents(Composite parent) {
                Control result = super.createContents(parent);
                if (project != null) {
                    this.getTreeViewer().setExpandedElements(new Object[]{project});
                }
                return result;
            }

            protected void updateButtonsEnableState(IStatus status) {
                this.getOkButton().setEnabled(status.isOK());
            }
        };
        selectionDialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return element == project || element instanceof IFolder;
            }
        });
        selectionDialog.setStatusLineAboveButtons(false);
        selectionDialog.setTitle(title);
        selectionDialog.setMessage(message);
        selectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        selectionDialog.setInitialSelection((Object)project);
        if (selectionDialog.open() == 0 && selectionDialog.getResult().length > 0) {
            return (IResource)selectionDialog.getResult()[0];
        }
        return null;
    }

    public static IFile selectFileFromProjects(Shell shell, String title, String message) {
        fileValidator.setFileSuffix("");
        return (IFile)PropertyTabGuiHelper.selectFileOrDirectoryFromWorkspace(shell, title, message, ResourcesPlugin.getWorkspace().getRoot(), SelectionType.FILE);
    }

    public static IFile selectFileFromProjects(Shell shell, String title, String message, String fileSuffix) {
        fileValidator.setFileSuffix(fileSuffix);
        return (IFile)PropertyTabGuiHelper.selectFileOrDirectoryFromWorkspace(shell, title, message, ResourcesPlugin.getWorkspace().getRoot(), SelectionType.FILE);
    }

    private static Object selectFileOrDirectoryFromWorkspace(Shell shell, String title, String message, Object input, SelectionType filter) {
        final IProject project = PropertyTabGuiHelper.getProjectOfCurrentlyActiveEditor();
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider()){

            protected void updateStatus(IStatus status) {
                this.updateButtonsEnableState(status);
            }

            protected Control createContents(Composite parent) {
                Control result = super.createContents(parent);
                if (project != null) {
                    this.getTreeViewer().setExpandedElements(new Object[]{project});
                }
                return result;
            }

            protected void updateButtonsEnableState(IStatus status) {
                this.getOkButton().setEnabled(status.isOK());
            }
        };
        selectionDialog.setStatusLineAboveButtons(false);
        if (filter == SelectionType.FILE) {
            selectionDialog.setValidator((ISelectionStatusValidator)fileValidator);
        } else if (filter == SelectionType.DIRECTORY) {
            selectionDialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parent, Object element) {
                    return element instanceof IFolder;
                }
            });
        }
        selectionDialog.setTitle(title);
        selectionDialog.setMessage(message);
        selectionDialog.setInput(input);
        selectionDialog.setAllowMultiple(false);
        if (selectionDialog.open() == 0 && selectionDialog.getResult().length > 0) {
            return selectionDialog.getResult()[0];
        }
        return null;
    }

    public static String selectFileFromFileSystem(Shell shell, String[] extensionFilters, String title, String filterPath) {
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setFilterExtensions(extensionFilters);
        fileDialog.setText(title);
        fileDialog.setFilterPath(filterPath);
        return fileDialog.open();
    }

    public static String selectFileFromFileSystem(Shell shell, String[] extensionFilters, String title) {
        return PropertyTabGuiHelper.selectFileFromFileSystem(shell, extensionFilters, title, null);
    }

    public static String selectDirectoryFromFileSystem(Shell shell, String title) {
        DirectoryDialog fileDialog = new DirectoryDialog(shell);
        fileDialog.setText(title);
        return fileDialog.open();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IProject getProjectOfCurrentlyActiveEditor() {
        String source = "Return the project path of the active editor: %s";
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorInput input = null;
        if (window == null) {
            LOGGER.debug((Object)StringUtils.format((String)source, (Object[])new Object[]{"No active workbench window"}));
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            LOGGER.debug((Object)StringUtils.format((String)source, (Object[])new Object[]{"No active page in workbench"}));
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            LOGGER.debug((Object)StringUtils.format((String)source, (Object[])new Object[]{"No active editor in workbench page"}));
            return null;
        }
        input = editor.getEditorInput();
        if (!input.exists()) {
            LOGGER.debug((Object)StringUtils.format((String)source, (Object[])new Object[]{"Editor input does not exist"}));
            return null;
        }
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile().getProject();
        }
        LOGGER.debug((Object)StringUtils.format((String)source, (Object[])new Object[]{"Wrong type of active editor input " + input.getClass()}));
        return null;
    }

    private static enum SelectionType {
        FILE,
        DIRECTORY,
        FILE_AND_DIRECTORY;

    }
}

