/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public final class ProjectFileEncodingUtils {
    private static final int BUF_SIZE = 8192;

    private ProjectFileEncodingUtils() {
    }

    public static String decodeString(byte[] data, String encoding) {
        return Charset.forName(encoding).decode(ByteBuffer.wrap(data)).toString();
    }

    public static String loadIfileAsString(IFile ifile, String encoding) throws CoreException, IOException {
        byte[] bytes = ProjectFileEncodingUtils.loadIfileAsBytes(ifile);
        return ProjectFileEncodingUtils.decodeString(bytes, encoding);
    }

    public static byte[] loadIfileAsBytes(IFile ifile) throws CoreException, IOException {
        int num;
        InputStream is = ifile.getContents();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((num = is.read(buffer)) > 0) {
            baos.write(buffer, 0, num);
        }
        is.close();
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] encodeString(String string, String encoding) {
        ByteBuffer bb = Charset.forName(encoding).encode(string);
        byte[] buffer = bb.array();
        return Arrays.copyOfRange(buffer, 0, bb.limit());
    }

    public static void saveStringAsIfile(IFile file, String string, String encoding) throws CoreException {
        ProjectFileEncodingUtils.saveBytesAsIfile(file, ProjectFileEncodingUtils.encodeString(string, encoding));
    }

    public static void saveBytesAsIfile(IFile file, byte[] bytes) throws CoreException {
        file.setContents((InputStream)new ByteArrayInputStream(bytes), true, false, null);
    }
}

