/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.types.api.InternalTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;

public class InternalTDImpl
implements InternalTD {
    private static final String SERIALIZE_KEY_TYPE = "t";
    private static final String SERIALIZE_KEY_IDENTIFIER = "i";
    private static final String SERIALIZE_KEY_HOPS = "h";
    private static final String SERIALIZE_KEY_PAYLOAD = "p";
    private final String identifier;
    private final InternalTDType type;
    private Queue<WorkflowGraphHop> hopsToTraverse = null;
    private String payload = null;

    public InternalTDImpl(InternalTDType type) {
        this(type, UUID.randomUUID().toString());
    }

    public InternalTDImpl(InternalTDType type, String identifier) {
        this.identifier = identifier;
        this.type = type;
    }

    public InternalTDImpl(InternalTDType type, Queue<WorkflowGraphHop> hopsToTraverse) {
        this(type, UUID.randomUUID().toString(), hopsToTraverse);
    }

    public InternalTDImpl(InternalTDType type, String identifier, Queue<WorkflowGraphHop> hopsToTraverse) {
        this(type, identifier);
        this.hopsToTraverse = hopsToTraverse;
    }

    public InternalTDImpl(InternalTDType type, Queue<WorkflowGraphHop> hopsToTraverse, String payload) {
        this(type, UUID.randomUUID().toString(), hopsToTraverse, payload);
    }

    public InternalTDImpl(InternalTDType type, String identifier, Queue<WorkflowGraphHop> hopsToTraverse, String payload) {
        this(type, identifier);
        this.hopsToTraverse = hopsToTraverse;
        this.payload = payload;
    }

    public DataType getDataType() {
        return DataType.Internal;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public InternalTDType getType() {
        return this.type;
    }

    public Queue<WorkflowGraphHop> getHopsToTraverse() {
        return this.hopsToTraverse;
    }

    public String getPayload() {
        return this.payload;
    }

    public String toString() {
        return "Internal: " + this.getType().name();
    }

    public String serialize() {
        String pyld;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put(SERIALIZE_KEY_TYPE, this.getType().name());
        rootNode.put(SERIALIZE_KEY_IDENTIFIER, this.getIdentifier());
        ArrayNode hopsArrayNode = mapper.createArrayNode();
        Queue<WorkflowGraphHop> hops = this.getHopsToTraverse();
        if (hops != null) {
            for (WorkflowGraphHop hop : this.getHopsToTraverse()) {
                ArrayNode hopArrayNode = mapper.createArrayNode();
                hopArrayNode.add(hop.getHopExecutionIdentifier());
                hopArrayNode.add(hop.getHopOuputName());
                hopArrayNode.add(hop.getTargetExecutionIdentifier());
                hopArrayNode.add(hop.getTargetInputName());
                hopsArrayNode.add((JsonNode)hopArrayNode);
            }
            rootNode.put(SERIALIZE_KEY_HOPS, (JsonNode)hopsArrayNode);
        }
        if ((pyld = this.getPayload()) != null) {
            rootNode.put(SERIALIZE_KEY_PAYLOAD, pyld);
        }
        return rootNode.toString();
    }

    public static InternalTDImpl fromString(String value) {
        ObjectNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = (ObjectNode)mapper.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        String typeStr = rootNode.get(SERIALIZE_KEY_TYPE).textValue();
        if (!InternalTDImpl.isValidType(typeStr)) {
            return null;
        }
        InternalTDType type = InternalTDType.valueOf(typeStr);
        String identifier = rootNode.get(SERIALIZE_KEY_IDENTIFIER).textValue();
        LinkedList<WorkflowGraphHop> hops = null;
        if (rootNode.has(SERIALIZE_KEY_HOPS)) {
            ArrayNode hopsArrayNode = (ArrayNode)rootNode.get(SERIALIZE_KEY_HOPS);
            hops = new LinkedList<WorkflowGraphHop>();
            Iterator hopsElements = hopsArrayNode.elements();
            while (hopsElements.hasNext()) {
                ArrayNode hopArrayNode = (ArrayNode)hopsElements.next();
                hops.add(new WorkflowGraphHop(hopArrayNode.get(0).asText(), hopArrayNode.get(1).asText(), hopArrayNode.get(2).asText(), hopArrayNode.get(3).asText()));
            }
        }
        String pyld = null;
        if (rootNode.has(SERIALIZE_KEY_PAYLOAD)) {
            pyld = rootNode.get(SERIALIZE_KEY_PAYLOAD).textValue();
        }
        return new InternalTDImpl(type, identifier, hops, pyld);
    }

    private static boolean isValidType(String typeStr) {
        int i = 0;
        while (i < InternalTDType.values().length) {
            if (InternalTDType.values()[i].toString().equals(typeStr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static enum InternalTDType {
        WorkflowFinish,
        NestedLoopReset,
        FailureInLoop;

    }
}

