/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.impl;

import de.rcenvironment.core.communication.api.ServiceCallContext;
import de.rcenvironment.core.communication.api.ServiceCallContextUtils;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.PersistedComponentData;
import de.rcenvironment.core.component.execution.internal.ComponentContextBridge;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentContextImpl
implements ComponentContext {
    private static final long serialVersionUID = -8834897231211155860L;
    private String compExeId;
    private String instanceName;
    private final LogicalNodeId node;
    private final String wfExeCrtlId;
    private final String wfCtrlInstanceName;
    private final LogicalNodeId wfCtrlNode;
    private LogicalNodeId defaultStorageNode;
    private File workingDirectory;
    private final ConfigurationDescription configurationDescription;
    private final Set<String> inputs = new HashSet<String>();
    private final Set<String> inputsNotConnected = new HashSet<String>();
    private final Set<String> outputs = new HashSet<String>();
    private final Map<String, String> dynInputsIds = new HashMap<String, String>();
    private final Map<String, String> dynOutputsIds = new HashMap<String, String>();
    private final Map<String, DataType> outputsDataTypes = new HashMap<String, DataType>();
    private final Map<String, DataType> inputsDataTypes = new HashMap<String, DataType>();
    private final Map<String, EndpointCharacter> outputsCharacter = new HashMap<String, EndpointCharacter>();
    private final Map<String, EndpointCharacter> inputsCharacter = new HashMap<String, EndpointCharacter>();
    private final Map<String, Map<String, String>> inputsMetaData = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> outputsMetaData = new HashMap<String, Map<String, String>>();
    private final String componentIdentifier;
    private final String componentName;
    private final ComponentContextBridge compExeCtxBridge;
    private final ServiceRegistryAccess serviceRegistryAccess;
    private final ComponentLog log = new ComponentLog(){

        @Override
        public void toolStdout(String message) {
            ComponentContextImpl.this.compExeCtxBridge.printConsoleRow(message, ConsoleRow.Type.TOOL_OUT);
        }

        @Override
        public void toolStderr(String message) {
            ComponentContextImpl.this.compExeCtxBridge.printConsoleRow(message, ConsoleRow.Type.TOOL_ERROR);
        }

        @Override
        public void componentWarn(String message) {
            ComponentContextImpl.this.compExeCtxBridge.printConsoleRow(message, ConsoleRow.Type.COMPONENT_WARN);
        }

        @Override
        public void componentInfo(String message) {
            ComponentContextImpl.this.compExeCtxBridge.printConsoleRow(message, ConsoleRow.Type.COMPONENT_INFO);
        }

        @Override
        public void componentError(String message) {
            ComponentContextImpl.this.compExeCtxBridge.printConsoleRow(message, ConsoleRow.Type.COMPONENT_ERROR);
        }

        @Override
        public void componentError(String message, Throwable t, String errorId) {
            ComponentContextImpl.this.compExeCtxBridge.printConsoleRow(StringUtils.format((String)"%s: %s (%s)", (Object[])new Object[]{message, t.getMessage(), errorId}), ConsoleRow.Type.COMPONENT_ERROR);
        }
    };

    public ComponentContextImpl(ComponentExecutionContext compExeCtx, ComponentContextBridge compExeCtxBridge) {
        this.compExeId = compExeCtx.getExecutionIdentifier();
        this.instanceName = compExeCtx.getInstanceName();
        this.node = compExeCtx.getNodeId();
        this.wfCtrlNode = compExeCtx.getWorkflowNodeId();
        this.wfExeCrtlId = compExeCtx.getWorkflowExecutionIdentifier();
        this.wfCtrlInstanceName = compExeCtx.getWorkflowInstanceName();
        this.defaultStorageNode = compExeCtx.getWorkflowNodeId();
        this.workingDirectory = compExeCtx.getWorkingDirectory();
        this.configurationDescription = compExeCtx.getComponentDescription().getConfigurationDescription();
        for (EndpointDescription ep : compExeCtx.getComponentDescription().getInputDescriptionsManager().getEndpointDescriptions()) {
            String inputExecutionConstraint = ep.getMetaData().get("inputExecutionConstraint_4aae3eea");
            if (inputExecutionConstraint == null) {
                inputExecutionConstraint = ep.getEndpointDefinition().getDefaultInputExecutionConstraint().name();
            }
            if (inputExecutionConstraint.equals(EndpointDefinition.InputExecutionContraint.Required.name()) || ep.isConnected()) {
                this.inputs.add(ep.getName());
                this.dynInputsIds.put(ep.getName(), ep.getDynamicEndpointIdentifier());
            } else if (!ep.isConnected()) {
                this.inputsNotConnected.add(ep.getName());
            }
            this.inputsDataTypes.put(ep.getName(), ep.getDataType());
            this.inputsCharacter.put(ep.getName(), ep.getEndpointDefinition().getEndpointCharacter());
            this.inputsMetaData.put(ep.getName(), ep.getMetaData());
        }
        for (EndpointDescription ep : compExeCtx.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
            this.outputs.add(ep.getName());
            this.dynOutputsIds.put(ep.getName(), ep.getDynamicEndpointIdentifier());
            this.outputsDataTypes.put(ep.getName(), ep.getDataType());
            this.outputsCharacter.put(ep.getName(), ep.getEndpointDefinition().getEndpointCharacter());
            this.outputsMetaData.put(ep.getName(), ep.getMetaData());
        }
        this.componentIdentifier = compExeCtx.getComponentDescription().getIdentifier();
        this.componentName = compExeCtx.getComponentDescription().getName();
        this.compExeCtxBridge = compExeCtxBridge;
        this.serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
    }

    @Override
    public String getExecutionIdentifier() {
        return this.compExeId;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public LogicalNodeId getNodeId() {
        return this.node;
    }

    @Override
    public LogicalNodeId getDefaultStorageNodeId() {
        return this.defaultStorageNode;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setInstanceIdentifier(String instanceIdentifier) {
        this.compExeId = instanceIdentifier;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setDefaultStorageNode(LogicalNodeId defaultStorageNode) {
        this.defaultStorageNode = defaultStorageNode;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public Set<String> getReadOnlyConfigurationKeys() {
        return Collections.unmodifiableSet(this.configurationDescription.getComponentConfigurationDefinition().getReadOnlyConfiguration().getConfigurationKeys());
    }

    @Override
    public Set<String> getConfigurationKeys() {
        return Collections.unmodifiableSet(this.configurationDescription.getConfiguration().keySet());
    }

    @Override
    public String getConfigurationValue(String key) {
        if (this.getConfigurationKeys().contains(key)) {
            return this.configurationDescription.getConfigurationValue(key);
        }
        if (this.getReadOnlyConfigurationKeys().contains(key)) {
            return this.configurationDescription.getComponentConfigurationDefinition().getReadOnlyConfiguration().getValue(key);
        }
        return null;
    }

    @Override
    public String getConfigurationMetaDataValue(String configKey, String metaDataKey) {
        return this.configurationDescription.getComponentConfigurationDefinition().getConfigurationMetaDataDefinition().getMetaDataValue(configKey, metaDataKey);
    }

    @Override
    public Set<String> getInputs() {
        return Collections.unmodifiableSet(this.inputs);
    }

    @Override
    public boolean isStaticInput(String inputName) {
        return this.getDynamicInputIdentifier(inputName) == null;
    }

    @Override
    public boolean isDynamicInput(String inputName) {
        return this.getDynamicInputIdentifier(inputName) != null;
    }

    @Override
    public boolean isDynamicOutput(String outputName) {
        return this.getDynamicOutputIdentifier(outputName) != null;
    }

    @Override
    public Set<String> getInputsWithDatum() {
        return Collections.unmodifiableSet(this.compExeCtxBridge.getInputsWithDatum());
    }

    @Override
    public DataType getInputDataType(String inputName) {
        return this.inputsDataTypes.get(inputName);
    }

    @Override
    public Set<String> getInputMetaDataKeys(String inputName) {
        return Collections.unmodifiableSet(this.inputsMetaData.keySet());
    }

    @Override
    public String getInputMetaDataValue(String inputName, String metaDataKey) {
        return this.inputsMetaData.get(inputName).get(metaDataKey);
    }

    @Override
    public TypedDatum readInput(String inputName) {
        return this.compExeCtxBridge.readInput(inputName);
    }

    @Override
    public Set<String> getOutputs() {
        return Collections.unmodifiableSet(this.outputs);
    }

    @Override
    public DataType getOutputDataType(String outputName) {
        return this.outputsDataTypes.get(outputName);
    }

    @Override
    public Set<String> getOutputMetaDataKeys(String outputName) {
        return Collections.unmodifiableSet(this.outputsMetaData.keySet());
    }

    @Override
    public String getOutputMetaDataValue(String outputName, String metaDataKey) {
        return this.outputsMetaData.get(outputName).get(metaDataKey);
    }

    @Override
    public void writeOutput(String outputName, TypedDatum value) {
        this.compExeCtxBridge.writeOutput(outputName, value);
    }

    @Override
    public void resetOutputs() {
        this.compExeCtxBridge.resetOutputs();
    }

    @Override
    public void closeOutput(String outputName) {
        this.compExeCtxBridge.closeOutput(outputName);
    }

    @Override
    public void closeAllOutputs() {
        this.compExeCtxBridge.closeAllOutputs();
    }

    @Override
    public boolean isOutputClosed(String outputName) {
        return this.compExeCtxBridge.isOutputClosed(outputName);
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        return (T)this.serviceRegistryAccess.getService(clazz);
    }

    @Override
    public int getExecutionCount() {
        return this.compExeCtxBridge.getExecutionCount();
    }

    @Override
    public LogicalNodeId getWorkflowNodeId() {
        return this.wfCtrlNode;
    }

    @Override
    public String getWorkflowExecutionIdentifier() {
        return this.wfExeCrtlId;
    }

    @Override
    public String getWorkflowInstanceName() {
        return this.wfCtrlInstanceName;
    }

    @Override
    public PersistedComponentData getPersistedData() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void writeIntermediateHistoryData(ComponentHistoryDataItem historyDataItem) {
        this.compExeCtxBridge.writeIntermediateHistoryData(historyDataItem);
    }

    @Override
    public void writeFinalHistoryDataItem(ComponentHistoryDataItem historyDataItem) {
        this.compExeCtxBridge.writeFinalHistoryDataItem(historyDataItem);
    }

    @Override
    public String getDynamicInputIdentifier(String inputName) {
        return this.dynInputsIds.get(inputName);
    }

    @Override
    public String getDynamicOutputIdentifier(String inputName) {
        return this.dynOutputsIds.get(inputName);
    }

    @Override
    public String getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public Long getComponentExecutionDataManagementId() {
        return this.compExeCtxBridge.getComponentExecutionDataManagementId();
    }

    @Override
    public Set<String> getInputsNotConnected() {
        return this.inputsNotConnected;
    }

    @Override
    public ComponentLog getLog() {
        return this.log;
    }

    @Override
    public ServiceCallContext getServiceCallContext() {
        return ServiceCallContextUtils.getCurrentServiceCallContext();
    }

    @Override
    public void announceExternalProgramStart() {
        this.compExeCtxBridge.printConsoleRow(ConsoleRow.WorkflowLifecyleEventType.TOOL_STARTING.name(), ConsoleRow.Type.LIFE_CYCLE_EVENT);
    }

    @Override
    public void announceExternalProgramTermination() {
        this.compExeCtxBridge.printConsoleRow(ConsoleRow.WorkflowLifecyleEventType.TOOL_FINISHED.name(), ConsoleRow.Type.LIFE_CYCLE_EVENT);
    }

    @Override
    public EndpointCharacter getInputCharacter(String inputName) {
        return this.inputsCharacter.get(inputName);
    }

    @Override
    public EndpointCharacter getOutputCharacter(String outputName) {
        return this.outputsCharacter.get(outputName);
    }

    @Override
    public List<String> getDynamicInputsWithIdentifier(String identifier) {
        LinkedList<String> result = new LinkedList<String>();
        for (String endpoint : this.inputs) {
            if (!this.isDynamicInput(endpoint) || !this.getDynamicInputIdentifier(endpoint).equals(identifier)) continue;
            result.add(endpoint);
        }
        return result;
    }

    @Override
    public List<String> getDynamicOutputsWithIdentifier(String identifier) {
        LinkedList<String> result = new LinkedList<String>();
        for (String endpoint : this.outputs) {
            if (!this.isDynamicOutput(endpoint) || !this.getDynamicOutputIdentifier(endpoint).equals(identifier)) continue;
            result.add(endpoint);
        }
        return result;
    }
}

