/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.FileUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConsoleRowUtils {
    private static final Log LOGGER = LogFactory.getLog(ConsoleRowUtils.class);

    private ConsoleRowUtils() {
    }

    public static TextStreamWatcher logToWorkflowConsole(ComponentLog componentLog, InputStream inputStream, ConsoleRow.Type consoleType, File logFile, boolean append) {
        if (logFile != null) {
            try {
                inputStream = FileUtils.setUpStreamDuplicationToOutputFile((InputStream)inputStream, (File)logFile, (boolean)true, (boolean)append);
            }
            catch (IOException e) {
                LOGGER.error((Object)("setting up log file failed: " + logFile.getAbsolutePath()), (Throwable)e);
            }
        }
        class WorkflowConsoleOutputReceiver
        implements TextOutputReceiver {
            private final /* synthetic */ ConsoleRow.Type val$consoleType;
            private final /* synthetic */ ComponentLog val$componentLog;

            WorkflowConsoleOutputReceiver(ConsoleRow.Type type, ComponentLog componentLog) {
                this.val$consoleType = type;
                this.val$componentLog = componentLog;
            }

            public void onStart() {
            }

            public void addOutput(String line) {
                switch (this.val$consoleType) {
                    case TOOL_OUT: {
                        this.val$componentLog.toolStdout(line);
                        break;
                    }
                    case TOOL_ERROR: {
                        this.val$componentLog.toolStderr(line);
                        LOGGER.warn((Object)line);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Console row type not supported: " + (Object)((Object)this.val$consoleType));
                    }
                }
            }

            public void onFinished() {
            }

            public void onFatalError(Exception e) {
            }
        }
        TextStreamWatcher watcher = TextStreamWatcherFactory.create((InputStream)inputStream, (TextOutputReceiver[])new TextOutputReceiver[]{new WorkflowConsoleOutputReceiver(consoleType, componentLog)});
        watcher.start();
        return watcher;
    }

    public static String composeConsoleNotificationId(LogicalNodeId nodeIdString, String specificIdString) {
        return StringUtils.format((String)"rce.component.console:%s:%s", (Object[])new Object[]{nodeIdString.getInstanceNodeIdString(), specificIdString});
    }
}

