/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.datamanagement.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.EndpointHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class DefaultComponentHistoryDataItem
implements ComponentHistoryDataItem {
    public static final String INPUTS = "in";
    public static final String OUTPUTS = "out";
    public static final String TIMESTAMP = "ts";
    public static final String NAME = "n";
    public static final String VALUE = "v";
    private static final long serialVersionUID = -3420034372755242546L;
    private static final String FORMAT_VERSION_COMMON = "f_vc";
    private static final String FORMAT_VERSION_1 = "1";
    private static final String CURRENT_FORMAT_VERSION = "1";
    protected Map<String, Deque<EndpointHistoryDataItem>> inputs = Collections.synchronizedMap(new HashMap());
    protected Map<String, Deque<EndpointHistoryDataItem>> outputs = Collections.synchronizedMap(new HashMap());
    protected Map<String, Map<String, String>> inputMetaData = Collections.synchronizedMap(new HashMap());
    protected Map<String, Map<String, String>> outputMetaData = Collections.synchronizedMap(new HashMap());
    private String identifier;

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public synchronized String serialize(TypedDatumSerializer serializer) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put(FORMAT_VERSION_COMMON, "1");
        rootNode.put(INPUTS, (JsonNode)this.getEndpointsAsJsonObjectNode(this.inputs, mapper, serializer));
        rootNode.put(OUTPUTS, (JsonNode)this.getEndpointsAsJsonObjectNode(this.outputs, mapper, serializer));
        return rootNode.toString();
    }

    public Map<String, Deque<EndpointHistoryDataItem>> getInputs() {
        return this.inputs;
    }

    public Map<String, Deque<EndpointHistoryDataItem>> getOutputs() {
        return this.outputs;
    }

    public Map<String, String> getMetaDataForInput(String endpointName) {
        return this.inputMetaData.get(endpointName);
    }

    public Map<String, String> getMetaDataForOutput(String endpointName) {
        return this.outputMetaData.get(endpointName);
    }

    public static DefaultComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer) throws IOException {
        DefaultComponentHistoryDataItem historyDataItem = new DefaultComponentHistoryDataItem();
        DefaultComponentHistoryDataItem.initializeDefaultHistoryDataFromString(historyDataItem, historyData, serializer);
        return historyDataItem;
    }

    protected static void initializeDefaultHistoryDataFromString(DefaultComponentHistoryDataItem historyDataItem, String historyData, TypedDatumSerializer serializer) throws IOException {
        historyDataItem.inputs = DefaultComponentHistoryDataItem.getInputsFromString(historyData, serializer);
        historyDataItem.outputs = DefaultComponentHistoryDataItem.getOutputsFromString(historyData, serializer);
    }

    private ObjectNode getEndpointsAsJsonObjectNode(Map<String, Deque<EndpointHistoryDataItem>> endpoints, ObjectMapper mapper, TypedDatumSerializer serializer) {
        ObjectNode endpointObjectNode = mapper.createObjectNode();
        for (String inputName : endpoints.keySet()) {
            ArrayNode endpointArrayNode = mapper.createArrayNode();
            for (EndpointHistoryDataItem endpointData : endpoints.get(inputName)) {
                ObjectNode endpointDataObjectNode = mapper.createObjectNode();
                endpointDataObjectNode.put(TIMESTAMP, endpointData.getTimestamp());
                endpointDataObjectNode.put(NAME, endpointData.getEndpointName());
                endpointDataObjectNode.put(VALUE, serializer.serialize(endpointData.getValue()));
                endpointArrayNode.add((JsonNode)endpointDataObjectNode);
            }
            endpointObjectNode.put(inputName, (JsonNode)endpointArrayNode);
        }
        return endpointObjectNode;
    }

    public synchronized void addInput(String inputName, TypedDatum value) {
        if (!this.inputs.containsKey(inputName)) {
            this.inputs.put(inputName, new LinkedList());
        }
        this.inputs.get(inputName).addLast(new EndpointHistoryDataItem(System.currentTimeMillis(), inputName, value));
    }

    public synchronized void setInputMetaData(String inputName, Map<String, String> metaData) {
        this.inputMetaData.put(inputName, metaData);
    }

    public synchronized void addOutput(String outputName, TypedDatum value) {
        if (!this.outputs.containsKey(outputName)) {
            this.outputs.put(outputName, new LinkedList());
        }
        this.outputs.get(outputName).addLast(new EndpointHistoryDataItem(System.currentTimeMillis(), outputName, value));
    }

    public synchronized void setOutputMetaData(String outputName, Map<String, String> metaData) {
        this.outputMetaData.put(outputName, metaData);
    }

    private static Map<String, Deque<EndpointHistoryDataItem>> getInputsFromString(String endpoints, TypedDatumSerializer serializer) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            JsonNode tree = mapper.readTree(endpoints);
            return DefaultComponentHistoryDataItem.getEndpointsFromString((ObjectNode)tree.get(INPUTS), serializer);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    private static Map<String, Deque<EndpointHistoryDataItem>> getOutputsFromString(String endpoints, TypedDatumSerializer serializer) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            JsonNode tree = mapper.readTree(endpoints);
            return DefaultComponentHistoryDataItem.getEndpointsFromString((ObjectNode)tree.get(OUTPUTS), serializer);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    private static Map<String, Deque<EndpointHistoryDataItem>> getEndpointsFromString(ObjectNode endpointObjectNode, TypedDatumSerializer serializer) {
        Map<String, Deque<EndpointHistoryDataItem>> endpoints = Collections.synchronizedMap(new HashMap());
        if (endpointObjectNode != null) {
            Iterator endpointNamesIterator = endpointObjectNode.fieldNames();
            while (endpointNamesIterator.hasNext()) {
                String endpointName = (String)endpointNamesIterator.next();
                endpoints.put(endpointName, new LinkedList());
                ArrayNode endpointJsonArray = (ArrayNode)endpointObjectNode.get(endpointName);
                Iterator endpointDataObjectNodesIterator = endpointJsonArray.elements();
                while (endpointDataObjectNodesIterator.hasNext()) {
                    ObjectNode endpointDataObjectNode = (ObjectNode)endpointDataObjectNodesIterator.next();
                    EndpointHistoryDataItem endpointHistoryData = new EndpointHistoryDataItem(endpointDataObjectNode.get(TIMESTAMP).longValue(), endpointDataObjectNode.get(NAME).textValue(), serializer.deserialize(endpointDataObjectNode.get(VALUE).textValue()));
                    endpoints.get(endpointName).add(endpointHistoryData);
                }
            }
        }
        return endpoints;
    }
}

