/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.datamanagement.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonComponentHistoryDataItem
extends DefaultComponentHistoryDataItem {
    protected static final String FORMAT_VERSION_1 = "1";
    protected static final String CURRENT_FORMAT_VERSION = "1";
    protected static final String FORMAT_VERSION = "f_v";
    protected static final String EXIT_CODE = "exit";
    private static final long serialVersionUID = 3747244536714110690L;
    protected Map<String, String> logs = new HashMap<String, String>();
    protected Integer exitCode;

    public String getFormatVersion() {
        return "1";
    }

    @Override
    public String serialize(TypedDatumSerializer serializer) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put(FORMAT_VERSION, this.getFormatVersion());
        if (this.exitCode != null) {
            rootNode.put(EXIT_CODE, this.exitCode);
        }
        return rootNode.toString();
    }

    protected ObjectNode getLogsAsJsonObjectNode(Map<String, String> logRefs, ObjectMapper mapper) {
        ObjectNode logsObjectNode = mapper.createObjectNode();
        for (String logFileName : logRefs.keySet()) {
            logsObjectNode.put(logFileName, logRefs.get(logFileName));
        }
        return logsObjectNode;
    }

    protected static void initializeCommonHistoryDataFromString(CommonComponentHistoryDataItem historyDataItem, String historyData, TypedDatumSerializer serializer) throws IOException {
        DefaultComponentHistoryDataItem.initializeDefaultHistoryDataFromString(historyDataItem, historyData, serializer);
        historyDataItem.exitCode = CommonComponentHistoryDataItem.getExitCodeFromString(historyData);
    }

    protected static Integer getExitCodeFromString(String exitCodeString) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            JsonNode tree = mapper.readTree(exitCodeString);
            if (tree.get(EXIT_CODE) != null) {
                return tree.get(EXIT_CODE).asInt();
            }
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        return null;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }
}

