/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationDefinitionImpl;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationExtensionDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionsProviderImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointGroupDefinitionImpl;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.component.model.impl.ComponentInterfaceImpl;
import de.rcenvironment.core.component.model.impl.ComponentRevisionImpl;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class ComponentUtils {
    public static final Log LOGGER = LogFactory.getLog(ComponentUtils.class);
    public static final int LOWER_COMPONENT_VERSION = -1;
    public static final int EQUAL_COMPONENT_VERSION = 0;
    public static final int GREATER_COMPONENT_VERSION = 1;
    public static final String PLACEHOLDER_REGEX = "\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}";
    public static final String VARIABLE_CWD = "${cwd}";
    public static final String VARIABLE = "${%s}";
    public static final String OUTPUT_TAG = "_rce_output_";
    public static final String MISSING_COMPONENT_PREFIX = "20ca0171b5e24e10a284af7c1d6d94e9missing_";
    public static final int ATTRIBUTE1 = 2;
    public static final int ATTRIBUTE2 = 5;
    public static final int PLACEHOLDERNAME = 7;
    public static final String PLACEHOLDER_PASSWORD_STORAGE_NODE = "placeholder";
    public static final String GLOBALATTRIBUTE = "global";
    public static final String ENCODEDATTRIBUTE = "*";
    public static final String PLACEHOLDER_PASSWORD_SYMBOL = "*";
    private static final String FILE_SEPERATOR = "/";

    private ComponentUtils() {
    }

    public static Map<LogicalNodeId, Integer> getNodesForComponent(Collection<ComponentInstallation> compInstallations, ComponentDescription compDesc) {
        ComponentInterface compInterface = compDesc.getComponentInstallation().getComponentRevision().getComponentInterface();
        String temp = ComponentUtils.getComponentInterfaceIdentifierWithoutVersion(compInterface.getIdentifier());
        String compInterfaceIdWithoutVersion = temp.contains(MISSING_COMPONENT_PREFIX) ? temp.replace(MISSING_COMPONENT_PREFIX, "") : temp;
        HashMap<LogicalNodeId, Integer> identifiers = new HashMap<LogicalNodeId, Integer>();
        for (ComponentInstallation compInstallation : compInstallations) {
            int compared;
            LogicalNodeId node;
            ComponentInterface compInterfaceToCheck = compInstallation.getComponentRevision().getComponentInterface();
            String compInterfaceIdToCheckWithoutVersion = ComponentUtils.getComponentInterfaceIdentifierWithoutVersion(compInterfaceToCheck.getIdentifier());
            if (!compInterfaceIdWithoutVersion.equals(compInterfaceIdToCheckWithoutVersion)) continue;
            try {
                node = NodeIdentifierUtils.parseLogicalNodeIdString((String)compInstallation.getNodeId());
            }
            catch (IdentifierException e) {
                throw NodeIdentifierUtils.wrapIdentifierException((IdentifierException)e);
            }
            try {
                Float versionToCheck = Float.valueOf(compInterfaceToCheck.getVersion());
                Float version = Float.valueOf(compInterface.getVersion());
                compared = versionToCheck.compareTo(version);
            }
            catch (NumberFormatException numberFormatException) {
                compared = compInterfaceToCheck.getVersion().compareTo(compInterface.getVersion());
            }
            if (compared < 0) {
                identifiers.put(node, -1);
                continue;
            }
            if (compared > 0) {
                identifiers.put(node, 1);
                continue;
            }
            identifiers.put(node, 0);
        }
        return identifiers;
    }

    public static boolean hasComponent(Collection<ComponentInstallation> installations, String componentId, LogicalNodeId node) {
        for (ComponentInstallation installation : installations) {
            if (!installation.getComponentRevision().getComponentInterface().getIdentifier().equals(componentId) || !installation.getNodeId().equals(node.getLogicalNodeIdString())) continue;
            return true;
        }
        return false;
    }

    public static List<ComponentInstallation> eliminateComponentInterfaceDuplicates(Collection<ComponentInstallation> compInstallations, LogicalNodeId localNode) {
        ArrayList<ComponentInstallation> filteredInstallations = new ArrayList<ComponentInstallation>();
        for (ComponentInstallation compInstallation : compInstallations) {
            String compInterfaceId = compInstallation.getComponentRevision().getComponentInterface().getIdentifier();
            String compInterfaceIdWithoutVersion = ComponentUtils.getComponentInterfaceIdentifierWithoutVersion(compInterfaceId);
            boolean contained = false;
            Iterator iterator = filteredInstallations.iterator();
            while (iterator.hasNext()) {
                String filteredCompInterfaceId = ((ComponentInstallation)iterator.next()).getComponentRevision().getComponentInterface().getIdentifier();
                String filteredCompInterfaceIdWithoutVersion = ComponentUtils.getComponentInterfaceIdentifierWithoutVersion(filteredCompInterfaceId);
                if (!compInterfaceIdWithoutVersion.equals(filteredCompInterfaceIdWithoutVersion)) continue;
                if (compInstallation.getNodeId().equals(localNode.getLogicalNodeIdString())) {
                    iterator.remove();
                    continue;
                }
                contained = true;
            }
            if (contained) continue;
            filteredInstallations.add(compInstallation);
        }
        return filteredInstallations;
    }

    public static String getComponentInterfaceIdentifierWithoutVersion(String compInterfaceId) {
        return compInterfaceId.substring(0, compInterfaceId.indexOf(FILE_SEPERATOR));
    }

    public static ComponentInstallation getExactMatchingComponentInstallationForNode(String compInterfaceId, Collection<ComponentInstallation> installations, LogicalNodeId node) {
        for (ComponentInstallation installation : installations) {
            if (!installation.getComponentRevision().getComponentInterface().getIdentifier().equals(compInterfaceId) || !installation.getNodeId().equals(node.getLogicalNodeIdString())) continue;
            LogFactory.getLog(ComponentUtils.class).debug((Object)StringUtils.format((String)"Resolved undefined component location for '%s' with installation on '%s'", (Object[])new Object[]{compInterfaceId, installation.getNodeId()}));
            return installation;
        }
        return null;
    }

    public static ComponentInstallation getComponentInstallationForNode(String compInterfaceId, Collection<ComponentInstallation> installations, LogicalNodeId node) {
        if (installations == null) {
            return null;
        }
        for (ComponentInstallation installation : installations) {
            if (!ComponentUtils.getComponentInterfaceIdentifierWithoutVersion(installation.getComponentRevision().getComponentInterface().getIdentifier()).equals(ComponentUtils.getComponentInterfaceIdentifierWithoutVersion(compInterfaceId)) || !installation.getNodeId().equals(node.getLogicalNodeIdString())) continue;
            return installation;
        }
        return null;
    }

    public static ComponentInstallation getComponentInstallation(String componentInterfaceId, Collection<ComponentInstallation> componentInstallations) {
        for (ComponentInstallation currentComponentInstallation : componentInstallations) {
            String currentComponentInterfaceId = currentComponentInstallation.getComponentRevision().getComponentInterface().getIdentifier();
            if (!currentComponentInterfaceId.equals(componentInterfaceId)) continue;
            return currentComponentInstallation;
        }
        return null;
    }

    public static ComponentInstallation createPlaceholderComponentInstallation(String identifier, String version, String name, LogicalNodeId nodeId) {
        if (name == null) {
            name = "N/A";
        }
        ComponentInterfaceImpl componentInterface = new ComponentInterfaceImpl();
        componentInterface.setIdentifier(MISSING_COMPONENT_PREFIX + identifier);
        componentInterface.setDisplayName(name);
        componentInterface.setGroupName("Other");
        componentInterface.setVersion(version);
        componentInterface.setIcon16(null);
        componentInterface.setIcon24(null);
        componentInterface.setIcon32(null);
        componentInterface.setLocalExecutionOnly(false);
        componentInterface.setPerformLazyDisposal(false);
        componentInterface.setInputDefinitionsProvider(new EndpointDefinitionsProviderImpl());
        componentInterface.setOutputDefinitionsProvider(new EndpointDefinitionsProviderImpl());
        componentInterface.setConfigurationDefinition(new ConfigurationDefinitionImpl());
        componentInterface.setConfigurationExtensionDefinitions(new HashSet<ConfigurationExtensionDefinitionImpl>());
        ComponentRevisionImpl componentRevision = new ComponentRevisionImpl();
        componentRevision.setComponentInterface(componentInterface);
        ComponentInstallationImpl componentInstallation = new ComponentInstallationImpl();
        componentInstallation.setInstallationId(componentInterface.getIdentifier());
        componentInstallation.setNodeIdFromObject(nodeId);
        componentInstallation.setComponentRevision(componentRevision);
        return componentInstallation;
    }

    public static boolean isGlobalPlaceholder(String placeholder) {
        Matcher matcherOfPlaceholder = ComponentUtils.getMatcherForPlaceholder(placeholder);
        return matcherOfPlaceholder.group(2) != null && matcherOfPlaceholder.group(2).equals(GLOBALATTRIBUTE) | (matcherOfPlaceholder.group(5) != null && matcherOfPlaceholder.group(5).equals(GLOBALATTRIBUTE));
    }

    public static Matcher getMatcherForPlaceholder(String placeholder) {
        Pattern pattern = Pattern.compile(PLACEHOLDER_REGEX);
        Matcher matcher = pattern.matcher(placeholder);
        matcher.find();
        return matcher;
    }

    public static String replaceOutputVariables(String text, Set<String> outputValues, String placeholderFormat) {
        for (String outputName : outputValues) {
            text = text.replace(StringUtils.format((String)placeholderFormat, (Object[])new Object[]{outputName}), OUTPUT_TAG + outputName + OUTPUT_TAG);
        }
        return text;
    }

    public static String replacePropertyVariables(String script, Map<String, String> properties, String placeholderFormat) {
        for (String propName : properties.keySet()) {
            script = script.replace(StringUtils.format((String)placeholderFormat, (Object[])new Object[]{propName}), properties.get(propName));
        }
        return script;
    }

    public static String replaceCWDVariable(String text, String workDir) {
        String cwd = workDir;
        cwd = cwd.replace("\\\\", FILE_SEPERATOR);
        cwd = cwd.replace("\\", FILE_SEPERATOR);
        text = text.replace(VARIABLE_CWD, cwd);
        return text;
    }

    public static String replaceVariable(String text, String value, String placeholderName, String placeholderFormat) {
        value = value.replace("\\\\", FILE_SEPERATOR);
        value = value.replace("\\", FILE_SEPERATOR);
        text = text.replace(StringUtils.format((String)placeholderFormat, (Object[])new Object[]{placeholderName}), value);
        return text;
    }

    public static String extractOutputName(String taggedOutputName) {
        return taggedOutputName.replaceAll(OUTPUT_TAG, "");
    }

    public static boolean isEncryptedPlaceholder(String placeholder, List<String> encryptedPlaceholder) {
        if (encryptedPlaceholder != null) {
            return encryptedPlaceholder.contains(placeholder);
        }
        return false;
    }

    public static Set<EndpointGroupDefinitionImpl> extractDynamicInputGroupDefinitions(InputStream jsonInputStream) throws IOException {
        return ComponentUtils.extractInputGroupDefinitions(jsonInputStream, "dynamicInputGroups");
    }

    public static Set<EndpointGroupDefinitionImpl> extractStaticInputGroupDefinitions(InputStream jsonInputStream) throws IOException {
        return ComponentUtils.extractInputGroupDefinitions(jsonInputStream, "staticInputGroups");
    }

    private static Set<EndpointGroupDefinitionImpl> extractInputGroupDefinitions(InputStream jsonInputStream, String key) throws IOException {
        HashSet<EndpointGroupDefinitionImpl> endpointGroups = new HashSet<EndpointGroupDefinitionImpl>();
        for (Object definition : ComponentUtils.extractDefinitionAsList(jsonInputStream, key)) {
            try {
                EndpointGroupDefinitionImpl endpointGroup = new EndpointGroupDefinitionImpl();
                endpointGroup.setRawEndpointGroupDefinition((Map)definition);
                endpointGroups.add(endpointGroup);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        return endpointGroups;
    }

    public static Set<EndpointDefinitionImpl> extractStaticEndpointDefinition(InputStream jsonInputStream, List<InputStream> extendedJsonInputStream, EndpointType type) throws IOException {
        return ComponentUtils.extractEndpointDefinition(jsonInputStream, extendedJsonInputStream, type, true);
    }

    public static Set<EndpointDefinitionImpl> extractDynamicEndpointDefinition(InputStream jsonInputStream, List<InputStream> extendedJsonInputStream, EndpointType direction) throws IOException {
        return ComponentUtils.extractEndpointDefinition(jsonInputStream, extendedJsonInputStream, direction, false);
    }

    private static Set<EndpointDefinitionImpl> extractEndpointDefinition(InputStream jsonInputStream, List<InputStream> extendedJsonInputStream, EndpointType type, boolean isStatic) throws IOException {
        HashSet<EndpointDefinitionImpl> enpointDefinitions = new HashSet<EndpointDefinitionImpl>();
        String key = isStatic ? (type == EndpointType.INPUT ? "staticInputs" : "staticOutputs") : (type == EndpointType.INPUT ? "dynamicInputs" : "dynamicOutputs");
        for (Object definition : ComponentUtils.extractDefinitionAsList(jsonInputStream, key)) {
            try {
                EndpointDefinitionImpl endpointDef = new EndpointDefinitionImpl();
                endpointDef.setRawEndpointDefinition((Map)definition);
                endpointDef.setEndpointType(type);
                enpointDefinitions.add(endpointDef);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        key = isStatic ? (type == EndpointType.INPUT ? "staticInputMetaData" : "staticOutputMetaData") : (type == EndpointType.INPUT ? "dynamicInputMetaData" : "dynamicOutputMetaData");
        for (InputStream inputStream : extendedJsonInputStream) {
            for (Object definition : ComponentUtils.extractDefinitionAsList(inputStream, key)) {
                try {
                    if (isStatic) {
                        String endpointName = (String)((Map)definition).get("name");
                        for (EndpointDefinitionImpl endpointDefinition : enpointDefinitions) {
                            if (!endpointDefinition.getName().equals(endpointName)) continue;
                            endpointDefinition.setRawEndpointDefinitionExtension((Map)definition);
                        }
                        continue;
                    }
                    String endpointIdentifier = (String)((Map)definition).get("identifier");
                    for (EndpointDefinitionImpl endpointDefinition : enpointDefinitions) {
                        if (!endpointDefinition.getIdentifier().equals(endpointIdentifier)) continue;
                        endpointDefinition.setRawEndpointDefinitionExtension((Map)definition);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(e);
                }
            }
        }
        return enpointDefinitions;
    }

    public static ConfigurationDefinitionImpl extractConfigurationDescription(InputStream configurationJson, InputStream placeholdersJson, InputStream activationFilterJson) throws IOException {
        ConfigurationDefinitionImpl configDef = new ConfigurationDefinitionImpl();
        configDef.setRawConfigurationDefinition(ComponentUtils.extractDefinitionAsList(configurationJson, "configuration"));
        configDef.setRawPlaceholderMetaDataDefinition(ComponentUtils.extractDefinitionAsList(placeholdersJson, "placeholders"));
        configDef.setRawActivationFilter(ComponentUtils.extractDefinitionAsMap(activationFilterJson, "activationFilter"));
        return configDef;
    }

    public static ConfigurationExtensionDefinitionImpl extractConfigurationExtensionDescription(InputStream configurationJson, InputStream placeholdersJson, InputStream activationFilterJson) throws IOException {
        ConfigurationExtensionDefinitionImpl extConfigDef = new ConfigurationExtensionDefinitionImpl();
        extConfigDef.setRawConfigurationDefinition(ComponentUtils.extractDefinitionAsList(configurationJson, "configuration"));
        extConfigDef.setRawPlaceholderMetaDataDefinition(ComponentUtils.extractDefinitionAsList(placeholdersJson, "placeholders"));
        extConfigDef.setRawActivationFilter(ComponentUtils.extractDefinitionAsMap(activationFilterJson, "activationFilter"));
        return extConfigDef;
    }

    public static String createErrorLogMessage(Throwable t) {
        return ComponentUtils.addCauseToExceptionErrorLogMessage(t, "");
    }

    public static String createErrorLogMessage(String errorMessage, String errorId) {
        return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{errorMessage, errorId});
    }

    public static String createErrorLogMessage(Throwable t, String errorId) {
        return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{ComponentUtils.addCauseToExceptionErrorLogMessage(t, ""), errorId});
    }

    private static String addCauseToExceptionErrorLogMessage(Throwable cause, String errorMessage) {
        if (!errorMessage.isEmpty()) {
            errorMessage = String.valueOf(errorMessage) + "; cause: ";
        }
        errorMessage = cause.getMessage() == null || cause.getMessage().isEmpty() || cause.getCause() != null && cause.getMessage().startsWith(cause.getCause().getClass().getCanonicalName()) ? String.valueOf(errorMessage) + "Unexpected error: " + cause.getClass().getSimpleName() : String.valueOf(errorMessage) + cause.getMessage();
        if (cause.getCause() != null) {
            errorMessage = ComponentUtils.addCauseToExceptionErrorLogMessage(cause.getCause(), errorMessage);
        }
        return errorMessage;
    }

    private static List<Object> extractDefinitionAsList(InputStream jsonInputStream, String key) throws IOException {
        Object extractedObj = ComponentUtils.extractDefinitionAsObject(jsonInputStream, key);
        if (extractedObj == null) {
            return new ArrayList<Object>();
        }
        return (List)extractedObj;
    }

    private static Map<String, Object> extractDefinitionAsMap(InputStream jsonInputStream, String key) throws IOException {
        Object extractedObj = ComponentUtils.extractDefinitionAsObject(jsonInputStream, key);
        if (extractedObj == null) {
            return new HashMap<String, Object>();
        }
        return (Map)extractedObj;
    }

    private static Object extractDefinitionAsObject(InputStream jsonInputStream, String key) throws IOException {
        Map descriptions;
        String errorMessage = "parsing JSON file failed";
        try {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            descriptions = (Map)JsonUtils.getDefaultObjectMapper().readValue(jsonInputStream, (TypeReference)typeRef);
        }
        catch (JsonParseException e) {
            throw new IOException(errorMessage, e);
        }
        catch (JsonMappingException e) {
            throw new IOException(errorMessage, e);
        }
        jsonInputStream.close();
        return descriptions.get(key);
    }

    public static URL readIconURL(String bundleName, String iconName) {
        URL url = null;
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            Enumeration result = Platform.getBundle((String)bundleName).findEntries(FILE_SEPERATOR, iconName, true);
            if (result != null) {
                url = result.hasMoreElements() ? (URL)result.nextElement() : null;
            }
        } else {
            LOGGER.warn((Object)("Bundle for loading icons could not be found: " + bundleName));
        }
        return url;
    }
}

