/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.wrapper;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.datamanagement.stateful.StatefulComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.wrapper.BasicWrapperHook;
import de.rcenvironment.core.component.wrapper.MonitoringEventListener;
import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.AbstractTextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.LoggingTextOutReceiver;
import de.rcenvironment.core.utils.common.validation.ValidationFailureException;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WrapperBase<C, R> {
    protected final MonitoringEventListener monitoringListener;
    protected final StdoutMonitoringForwarder stdoutMonitoringForwarder;
    protected final StderrMonitoringForwarder stderrMonitoringForwarder;
    protected final Log log = LogFactory.getLog(this.getClass());
    private final List<BasicWrapperHook> registeredHooks;
    private final StatefulComponentDataManagementService fileReferenceHandler;
    private ComponentContext componentContext;

    protected WrapperBase(StatefulComponentDataManagementService fileReferenceHandler, MonitoringEventListener listener, ComponentContext compInformation) {
        this.monitoringListener = listener;
        this.fileReferenceHandler = fileReferenceHandler;
        this.stdoutMonitoringForwarder = new StdoutMonitoringForwarder();
        this.stderrMonitoringForwarder = new StderrMonitoringForwarder();
        this.registeredHooks = new ArrayList<BasicWrapperHook>();
        this.componentContext = compInformation;
    }

    public void registerHook(BasicWrapperHook hook) {
        this.registeredHooks.add(hook);
    }

    public void unregisterHook(BasicWrapperHook hook) {
        this.registeredHooks.remove(hook);
    }

    public void setupStaticEnvironment() throws IOException, ValidationFailureException {
    }

    public void tearDownStaticEnvironment() throws IOException {
    }

    public abstract R execute(C var1) throws Exception;

    public R execute(C runConfiguration, BasicWrapperHook singleRunHook) throws Exception {
        this.registerHook(singleRunHook);
        try {
            R r = this.execute(runConfiguration);
            return r;
        }
        finally {
            this.unregisterHook(singleRunHook);
        }
    }

    protected void uploadInputFiles(Map<String, String> fileMap, CommandLineExecutor executor) throws IOException {
        for (Map.Entry<String, String> entry : fileMap.entrySet()) {
            String filename = entry.getKey();
            String reference = entry.getValue();
            this.uploadFileFromReference(filename, reference, executor);
        }
    }

    private void uploadFileFromReference(String filename, String reference, CommandLineExecutor executor) throws IOException {
        File tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("upload." + filename + "-*.tmp");
        tempFile.deleteOnExit();
        try {
            this.getDataManagementService().copyReferenceToLocalFile(reference, tempFile, (ResolvableNodeId)this.componentContext.getDefaultStorageNodeId());
            executor.uploadFileToWorkdir(tempFile, filename);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    protected String downloadFileToReference(String filename, CommandLineExecutor executor) throws IOException {
        File targetFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("download." + filename + "-*.tmp");
        targetFile.deleteOnExit();
        try {
            executor.downloadFileFromWorkdir(filename, targetFile);
            String string = this.getDataManagementService().createTaggedReferenceFromLocalFile(targetFile, filename);
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)targetFile);
        }
    }

    protected void prepareAndTestEnvironment(CommandLineExecutor executor) throws InterruptedException, IOException {
        this.log.debug((Object)"Environment pre-test starting");
        executor.start("echo \"Effective Workdir: `pwd`\"", null);
        InputStream ansysStdout = executor.getStdout();
        InputStream ansysStderr = executor.getStderr();
        TextStreamWatcher stdoutWatcher = TextStreamWatcherFactory.create((InputStream)ansysStdout, (TextOutputReceiver[])new TextOutputReceiver[]{new LoggingTextOutReceiver("Environment pre-test Stdout")});
        TextStreamWatcher stderrWatcher = TextStreamWatcherFactory.create((InputStream)ansysStderr, (TextOutputReceiver[])new TextOutputReceiver[]{new LoggingTextOutReceiver("Environment pre-test Stderr")});
        stdoutWatcher.start();
        stderrWatcher.start();
        executor.waitForTermination();
        stdoutWatcher.waitForTermination();
        stderrWatcher.waitForTermination();
        this.log.debug((Object)"Environment pre-test complete");
    }

    protected StatefulComponentDataManagementService getDataManagementService() {
        return this.fileReferenceHandler;
    }

    protected final class StderrMonitoringForwarder
    extends AbstractTextOutputReceiver {
        protected StderrMonitoringForwarder() {
        }

        public void addOutput(String line) {
            WrapperBase.this.monitoringListener.appendStderr(line);
        }
    }

    protected final class StdoutMonitoringForwarder
    extends AbstractTextOutputReceiver {
        protected StdoutMonitoringForwarder() {
        }

        public void addOutput(String line) {
            WrapperBase.this.monitoringListener.appendStdout(line);
        }
    }
}

