/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleModelSnapshot;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowFilter;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowLogService;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowModelService;
import de.rcenvironment.core.component.workflow.execution.api.GenericSubscriptionManager;
import de.rcenvironment.core.component.workflow.execution.impl.ConsoleSubscriptionEventProcessor;
import de.rcenvironment.core.component.workflow.execution.internal.ConsoleModelSnapshotImpl;
import de.rcenvironment.core.component.workflow.execution.internal.ConsoleRowProcessor;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;

public class ConsoleRowModelServiceImpl
implements ConsoleRowModelService,
ConsoleRowProcessor {
    private static final int MAX_UNFILTERED_ROWS_RETENTION = 35000;
    private static final int MAX_SNAPSHOT_SIZE = 25000;
    private static GenericSubscriptionManager subscriptionManager;
    private static CountDownLatch initialSubscriptionLatch;
    private Deque<ConsoleRow> allRows;
    private ConsoleRowFilter currentFilter;
    private Deque<ConsoleRow> filteredRows;
    private SortedSet<String> workflows;
    private SortedSet<String> components;
    private int sequenceIdCounter = 1;
    private int filteredListLastChanged;
    private int workflowListLastChanged;
    private int componentListLastChanged;
    private ConsoleRowLogService consoleRowLogService;
    private WorkflowHostService workflowHostService;
    private CommunicationService communicationService;

    public ConsoleRowModelServiceImpl() {
        this.resetModel();
        this.currentFilter = new ConsoleRowFilter();
        initialSubscriptionLatch = new CountDownLatch(1);
    }

    public void activate() {
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Initial ConsoleRow model subscriptions")
            public void run() {
                subscriptionManager = new GenericSubscriptionManager(new ConsoleSubscriptionEventProcessor(ConsoleRowModelServiceImpl.this, ConsoleRowModelServiceImpl.this.consoleRowLogService), ConsoleRowModelServiceImpl.this.communicationService, ConsoleRowModelServiceImpl.this.workflowHostService);
                subscriptionManager.updateSubscriptionsForPrefixes(new String[]{"rce.component.console:"});
                initialSubscriptionLatch.countDown();
            }
        });
    }

    @Override
    public void ensureConsoleCaptureIsInitialized() throws InterruptedException {
        initialSubscriptionLatch.await();
    }

    @Override
    public synchronized void updateSubscriptions() {
        try {
            initialSubscriptionLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for initial subscriptions to complete", e);
        }
        subscriptionManager.updateSubscriptionsForPrefixes(new String[]{"rce.component.console:"});
    }

    @Override
    public synchronized ConsoleModelSnapshot getSnapshotIfModifiedSince(int sequenceId) {
        if (sequenceId == this.sequenceIdCounter) {
            return null;
        }
        if (sequenceId >= this.filteredListLastChanged && sequenceId >= this.workflowListLastChanged && sequenceId >= this.componentListLastChanged) {
            return null;
        }
        ConsoleModelSnapshotImpl snapshot = new ConsoleModelSnapshotImpl();
        if (this.filteredListLastChanged > sequenceId) {
            snapshot.setFilteredRows(new ArrayList<ConsoleRow>(this.filteredRows));
        }
        if (this.workflowListLastChanged > sequenceId) {
            snapshot.setWorkflowList(new ArrayList<String>(this.workflows));
        }
        if (this.componentListLastChanged > sequenceId) {
            snapshot.setComponentList(new ArrayList<String>(this.components));
        }
        snapshot.setSequenceId(this.sequenceIdCounter);
        return snapshot;
    }

    @Override
    public synchronized void processConsoleRows(List<ConsoleRow> rows) {
        ++this.sequenceIdCounter;
        for (ConsoleRow row : rows) {
            if (!this.accept(row)) continue;
            this.allRows.addLast(row);
            if (this.currentFilter.accept(row)) {
                this.filteredRows.addLast(row);
                this.filteredListLastChanged = this.sequenceIdCounter;
            }
            if (this.workflows.add(row.getWorkflowName())) {
                this.workflowListLastChanged = this.sequenceIdCounter;
            }
            if (!this.components.add(row.getComponentName())) continue;
            this.componentListLastChanged = this.sequenceIdCounter;
        }
        this.trimUnfilteredModel();
        this.trimFilteredList();
    }

    private boolean accept(ConsoleRow row) {
        if (row.getType().equals((Object)ConsoleRow.Type.WORKFLOW_ERROR)) {
            return row.getWorkflowName() != null && !row.getWorkflowName().isEmpty();
        }
        return row.getWorkflowName() != null && !row.getWorkflowName().isEmpty() && row.getComponentName() != null && !row.getComponentName().isEmpty();
    }

    @Override
    public synchronized void setRowFilter(ConsoleRowFilter newFilter) {
        ++this.sequenceIdCounter;
        this.currentFilter = newFilter.clone();
        this.filteredRows = new LinkedList<ConsoleRow>();
        for (ConsoleRow row : this.allRows) {
            if (!this.currentFilter.accept(row)) continue;
            this.filteredRows.addLast(row);
        }
        this.filteredListLastChanged = this.sequenceIdCounter;
        this.trimFilteredList();
    }

    public void bindConsoleRowLogService(ConsoleRowLogService newInstance) {
        this.consoleRowLogService = newInstance;
    }

    private void resetModel() {
        this.allRows = new LinkedList<ConsoleRow>();
        this.filteredRows = new LinkedList<ConsoleRow>();
        this.filteredListLastChanged = this.sequenceIdCounter;
        this.workflows = new TreeSet<String>();
        this.workflowListLastChanged = this.sequenceIdCounter;
        this.components = new TreeSet<String>();
        this.componentListLastChanged = this.sequenceIdCounter;
        this.currentFilter = new ConsoleRowFilter();
    }

    private void trimUnfilteredModel() {
        while (this.allRows.size() > 35000) {
            this.allRows.removeFirst();
        }
    }

    private void trimFilteredList() {
        while (this.filteredRows.size() > 25000) {
            this.filteredRows.removeFirst();
        }
    }

    @Override
    public synchronized void clearAll() {
        ++this.sequenceIdCounter;
        this.resetModel();
    }

    public void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    protected void bindWorkflowHostService(WorkflowHostService newWorkflowHostService) {
        this.workflowHostService = newWorkflowHostService;
    }
}

